/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.autotune.service;

import com.avaje.ebean.bean.NodeUsageCollector;
import com.avaje.ebean.text.PathProperties;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.BeanProperty;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssoc;
import com.avaje.ebeaninternal.server.el.ElPropertyValue;
import com.avaje.ebeaninternal.server.query.SplitName;
import java.util.LinkedHashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileOriginNodeUsage {
    private static final Logger logger = LoggerFactory.getLogger(ProfileOriginNodeUsage.class);
    private final Object monitor = new Object();
    private final String path;
    private int profileCount;
    private int profileUsedCount;
    private boolean modified;
    private final Set<String> aggregateUsed = new LinkedHashSet<String>();

    public ProfileOriginNodeUsage(String path) {
        this.path = "".equals(path) ? null : path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buildTunedFetch(PathProperties pathProps, BeanDescriptor<?> rootDesc, boolean addVersionProperty) {
        Object object = this.monitor;
        synchronized (object) {
            BeanProperty versionProp;
            BeanDescriptor<Object> desc = rootDesc;
            if (this.path != null) {
                ElPropertyValue elGetValue = rootDesc.getElGetValue(this.path);
                if (elGetValue == null) {
                    logger.warn("AutoTune: Can't find join for path[" + this.path + "] for " + rootDesc.getName());
                    return;
                }
                BeanProperty beanProperty = elGetValue.getBeanProperty();
                if (beanProperty instanceof BeanPropertyAssoc) {
                    desc = ((BeanPropertyAssoc)beanProperty).getTargetDescriptor();
                }
            }
            for (String propName : this.aggregateUsed) {
                BeanProperty beanProp = desc.getBeanPropertyFromPath(propName);
                if (beanProp == null) {
                    logger.warn("AutoTune: Can't find property[" + propName + "] for " + desc.getName());
                    continue;
                }
                if (beanProp instanceof BeanPropertyAssoc) {
                    BeanPropertyAssoc assocProp = (BeanPropertyAssoc)beanProp;
                    String targetIdProp = assocProp.getTargetIdProperty();
                    String manyPath = SplitName.add(this.path, assocProp.getName());
                    pathProps.addToPath(manyPath, targetIdProp);
                    continue;
                }
                if (beanProp.isLob() && !beanProp.isFetchEager()) continue;
                pathProps.addToPath(this.path, beanProp.getName());
            }
            if ((this.modified || addVersionProperty) && desc != null && (versionProp = desc.getVersionProperty()) != null) {
                pathProps.addToPath(this.path, versionProp.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void collectUsageInfo(NodeUsageCollector profile) {
        Object object = this.monitor;
        synchronized (object) {
            Set<String> used = profile.getUsed();
            ++this.profileCount;
            if (!used.isEmpty()) {
                ++this.profileUsedCount;
                this.aggregateUsed.addAll(used);
            }
            if (profile.isModified()) {
                this.modified = true;
            }
        }
    }

    public String toString() {
        return "path[" + this.path + "] profileCount[" + this.profileCount + "] used[" + this.profileUsedCount + "] props" + this.aggregateUsed;
    }
}

