/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.autotune.service;

import com.avaje.ebean.bean.NodeUsageCollector;
import com.avaje.ebean.bean.ObjectGraphNode;
import com.avaje.ebean.bean.ObjectGraphOrigin;
import com.avaje.ebean.config.AutoTuneConfig;
import com.avaje.ebeaninternal.api.SpiEbeanServer;
import com.avaje.ebeaninternal.api.SpiQuery;
import com.avaje.ebeaninternal.server.autotune.AutoTuneCollection;
import com.avaje.ebeaninternal.server.autotune.ProfilingListener;
import com.avaje.ebeaninternal.server.autotune.service.ProfileOrigin;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ProfileManager
implements ProfilingListener {
    private final boolean queryTuningAddVersion;
    private final double profilingRate;
    private final int profilingBase;
    private final Map<String, ProfileOrigin> profileMap = new ConcurrentHashMap<String, ProfileOrigin>();
    private final Object monitor = new Object();
    private final SpiEbeanServer server;

    public ProfileManager(AutoTuneConfig config, SpiEbeanServer server) {
        this.server = server;
        this.profilingRate = config.getProfilingRate();
        this.profilingBase = config.getProfilingBase();
        this.queryTuningAddVersion = config.isQueryTuningAddVersion();
    }

    @Override
    public boolean isProfileRequest(ObjectGraphNode origin, SpiQuery<?> query) {
        ProfileOrigin profileOrigin = this.profileMap.get(origin.getOriginQueryPoint().getKey());
        if (profileOrigin == null) {
            this.profileMap.put(origin.getOriginQueryPoint().getKey(), this.createProfileOrigin(origin, query));
            return true;
        }
        return profileOrigin.isProfile();
    }

    private ProfileOrigin createProfileOrigin(ObjectGraphNode origin, SpiQuery<?> query) {
        ProfileOrigin profileOrigin = new ProfileOrigin(origin.getOriginQueryPoint(), this.queryTuningAddVersion, this.profilingBase, this.profilingRate);
        profileOrigin.setOriginalQuery(query.getDetail().toString());
        return profileOrigin;
    }

    @Override
    public void collectQueryInfo(ObjectGraphNode node, long beans, long micros) {
        ObjectGraphOrigin origin;
        if (node != null && (origin = node.getOriginQueryPoint()) != null) {
            ProfileOrigin stats = this.getProfileOrigin(origin);
            stats.collectQueryInfo(node, beans, micros);
        }
    }

    @Override
    public void collectNodeUsage(NodeUsageCollector usageCollector) {
        ProfileOrigin profileOrigin = this.getProfileOrigin(usageCollector.getNode().getOriginQueryPoint());
        profileOrigin.collectUsageInfo(usageCollector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProfileOrigin getProfileOrigin(ObjectGraphOrigin originQueryPoint) {
        Object object = this.monitor;
        synchronized (object) {
            ProfileOrigin stats = this.profileMap.get(originQueryPoint.getKey());
            if (stats == null) {
                stats = new ProfileOrigin(originQueryPoint, this.queryTuningAddVersion, this.profilingBase, this.profilingRate);
                this.profileMap.put(originQueryPoint.getKey(), stats);
            }
            return stats;
        }
    }

    public AutoTuneCollection profilingCollection(boolean reset) {
        AutoTuneCollection req = new AutoTuneCollection();
        for (ProfileOrigin origin : this.profileMap.values()) {
            BeanDescriptor<?> desc = this.server.getBeanDescriptorById(origin.getOrigin().getBeanType());
            if (desc == null) continue;
            origin.profilingCollection(desc, req, reset);
        }
        return req;
    }
}

