/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.extraddl.model;

import com.avaje.ebeaninternal.extraddl.model.DdlScript;
import com.avaje.ebeaninternal.extraddl.model.ExtraDdl;
import java.io.InputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtraDdlXmlReader {
    private static final Logger logger = LoggerFactory.getLogger(ExtraDdlXmlReader.class);

    public static String buildExtra(String platformName) {
        ExtraDdl read = ExtraDdlXmlReader.read("/extra-ddl.xml");
        if (read == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(300);
        for (DdlScript script : read.getDdlScript()) {
            if (!ExtraDdlXmlReader.matchPlatform(platformName, script.getPlatforms())) continue;
            logger.debug("include script {}", (Object)script.getName());
            sb.append(script.getValue()).append("\n");
        }
        return sb.toString();
    }

    public static boolean matchPlatform(String platformName, String platforms) {
        String[] names;
        if (platforms == null || platforms.trim().isEmpty()) {
            return true;
        }
        for (String name : names = platforms.split("[,;]")) {
            if (!name.trim().toLowerCase().contains(platformName)) continue;
            return true;
        }
        return false;
    }

    public static ExtraDdl read(String resourcePath) {
        InputStream is = ExtraDdlXmlReader.class.getResourceAsStream(resourcePath);
        if (is == null) {
            return null;
        }
        return ExtraDdlXmlReader.read(is);
    }

    public static ExtraDdl read(InputStream is) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ExtraDdl.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            return (ExtraDdl)unmarshaller.unmarshal(is);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }
}

