/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.api;

import com.avaje.ebean.EbeanServer;
import com.avaje.ebean.bean.BeanCollection;
import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebeaninternal.api.LoadManyBuffer;
import com.avaje.ebeaninternal.api.LoadRequest;
import com.avaje.ebeaninternal.api.SpiQuery;
import com.avaje.ebeaninternal.server.core.OrmQueryRequest;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import com.avaje.ebeaninternal.server.lib.util.StringHelper;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadManyRequest
extends LoadRequest {
    private static final Logger logger = LoggerFactory.getLogger(LoadManyRequest.class);
    private final List<BeanCollection<?>> batch;
    private final LoadManyBuffer loadContext;
    private final boolean onlyIds;
    private final boolean loadCache;

    public LoadManyRequest(LoadManyBuffer loadContext, boolean onlyIds, boolean loadCache) {
        this(loadContext, null, true, onlyIds, loadCache);
    }

    public LoadManyRequest(LoadManyBuffer loadContext, OrmQueryRequest<?> parentRequest) {
        this(loadContext, parentRequest, false, false, false);
    }

    private LoadManyRequest(LoadManyBuffer loadContext, OrmQueryRequest<?> parentRequest, boolean lazy, boolean onlyIds, boolean loadCache) {
        super(parentRequest, lazy);
        this.loadContext = loadContext;
        this.batch = loadContext.getBatch();
        this.onlyIds = onlyIds;
        this.loadCache = loadCache;
    }

    @Override
    public Class<?> getBeanType() {
        return this.loadContext.getBeanDescriptor().getBeanType();
    }

    public String getDescription() {
        return "path:" + this.loadContext.getFullPath() + " size:" + this.batch.size();
    }

    public List<BeanCollection<?>> getBatch() {
        return this.batch;
    }

    public LoadManyBuffer getLoadContext() {
        return this.loadContext;
    }

    public boolean isOnlyIds() {
        return this.onlyIds;
    }

    public boolean isLoadCache() {
        return this.loadCache;
    }

    public int getBatchSize() {
        return this.loadContext.getBatchSize();
    }

    private List<Object> getParentIdList(int batchSize) {
        ArrayList<Object> idList = new ArrayList<Object>(batchSize);
        BeanPropertyAssocMany<?> many = this.getMany();
        for (int i = 0; i < this.batch.size(); ++i) {
            BeanCollection<?> bc = this.batch.get(i);
            idList.add(many.getParentId(bc.getOwnerBean()));
        }
        int extraIds = batchSize - this.batch.size();
        if (extraIds > 0) {
            Object firstId = idList.get(0);
            for (int i = 0; i < extraIds; ++i) {
                idList.add(firstId);
            }
        }
        return idList;
    }

    private BeanPropertyAssocMany<?> getMany() {
        return this.loadContext.getBeanProperty();
    }

    public SpiQuery<?> createQuery(EbeanServer server, int batchSize) {
        String extraWhere;
        BeanPropertyAssocMany<?> many = this.getMany();
        SpiQuery query = (SpiQuery)server.createQuery(many.getTargetType());
        String orderBy = many.getLazyFetchOrderBy();
        if (orderBy != null) {
            query.orderBy(orderBy);
        }
        if ((extraWhere = many.getExtraWhere()) != null) {
            String ew = StringHelper.replaceString(extraWhere, "${ta}", "t0");
            query.where().raw(ew);
        }
        query.setLazyLoadForParents(many);
        List<Object> idList = this.getParentIdList(batchSize);
        many.addWhereParentIdIn(query, idList, this.loadContext.isUseDocStore());
        query.setPersistenceContext(this.loadContext.getPersistenceContext());
        String mode = this.isLazy() ? "+lazy" : "+query";
        query.setLoadDescription(mode, this.getDescription());
        if (this.isLazy()) {
            query.setLazyLoadBatchSize(this.getBatchSize());
        }
        this.loadContext.configureQuery(query);
        if (this.isOnlyIds()) {
            query.select(many.getTargetIdProperty());
        }
        return query;
    }

    public void postLoad() {
        BeanDescriptor<?> desc = this.loadContext.getBeanDescriptor();
        BeanPropertyAssocMany<?> many = this.getMany();
        for (int i = 0; i < this.batch.size(); ++i) {
            BeanCollection<?> bc = this.batch.get(i);
            if (bc.checkEmptyLazyLoad()) {
                if (!logger.isDebugEnabled()) continue;
                EntityBean ownerBean = bc.getOwnerBean();
                Object parentId = desc.getId(ownerBean);
                logger.debug("BeanCollection after lazy load was empty. type:" + ownerBean.getClass().getName() + " id:" + parentId + " owner:" + ownerBean);
                continue;
            }
            if (!this.isLoadCache()) continue;
            Object parentId = desc.getId(bc.getOwnerBean());
            desc.cacheManyPropPut(many, bc, parentId);
        }
    }
}

