/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.dbmigration.model.build;

import com.avaje.ebean.dbmigration.model.MColumn;
import com.avaje.ebean.dbmigration.model.MCompoundForeignKey;
import com.avaje.ebean.dbmigration.model.MTable;
import com.avaje.ebean.dbmigration.model.build.ModelBuildContext;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.BeanProperty;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import com.avaje.ebeaninternal.server.deploy.TableJoin;
import com.avaje.ebeaninternal.server.deploy.TableJoinColumn;

public class ModelBuildIntersectionTable {
    private final ModelBuildContext ctx;
    private final BeanPropertyAssocMany<?> manyProp;
    private final TableJoin intersectionTableJoin;
    private final TableJoin tableJoin;
    private MTable intersectionTable;
    private int countForeignKey;

    public ModelBuildIntersectionTable(ModelBuildContext ctx, BeanPropertyAssocMany<?> manyProp) {
        this.ctx = ctx;
        this.manyProp = manyProp;
        this.intersectionTableJoin = manyProp.getIntersectionTableJoin();
        this.tableJoin = manyProp.getTableJoin();
    }

    public void build() {
        this.intersectionTable = this.createTable();
        MTable existingTable = this.ctx.addTable(this.intersectionTable);
        if (existingTable != null) {
            throw new IllegalStateException("Property " + this.manyProp.getFullBeanName() + " has duplicate ManyToMany intersection table " + this.intersectionTable.getName() + ". Please use @JoinTable to define unique table to use");
        }
        this.buildFkConstraints();
        if (this.manyProp.getTargetDescriptor().isDraftable()) {
            this.ctx.createDraft(this.intersectionTable, false);
        }
    }

    private void buildFkConstraints() {
        BeanDescriptor<?> localDesc = this.manyProp.getBeanDescriptor();
        this.buildFkConstraints(localDesc, this.intersectionTableJoin.columns(), true);
        BeanDescriptor targetDesc = this.manyProp.getTargetDescriptor();
        this.buildFkConstraints(targetDesc, this.tableJoin.columns(), false);
        this.intersectionTable.checkDuplicateForeignKeys();
    }

    private void buildFkConstraints(BeanDescriptor<?> desc, TableJoinColumn[] columns, boolean direction) {
        String tableName = this.intersectionTableJoin.getTable();
        String baseTable = this.ctx.normaliseTable(desc.getBaseTable());
        String fkName = this.ctx.foreignKeyConstraintName(tableName, baseTable, ++this.countForeignKey);
        String fkIndex = this.ctx.foreignKeyIndexName(tableName, baseTable, this.countForeignKey);
        MCompoundForeignKey foreignKey = new MCompoundForeignKey(fkName, desc.getBaseTable(), fkIndex);
        this.intersectionTable.addForeignKey(foreignKey);
        for (int i = 0; i < columns.length; ++i) {
            String localCol = direction ? columns[i].getForeignDbColumn() : columns[i].getLocalDbColumn();
            String refCol = !direction ? columns[i].getForeignDbColumn() : columns[i].getLocalDbColumn();
            foreignKey.addColumnPair(localCol, refCol);
        }
    }

    private MTable createTable() {
        BeanDescriptor<?> localDesc = this.manyProp.getBeanDescriptor();
        BeanDescriptor targetDesc = this.manyProp.getTargetDescriptor();
        String tableName = this.intersectionTableJoin.getTable();
        MTable table = new MTable(tableName);
        if (!this.manyProp.isExcludedFromHistory() && localDesc.isHistorySupport()) {
            table.setWithHistory(true);
        }
        table.setPkName(this.ctx.primaryKeyName(tableName));
        TableJoinColumn[] columns = this.intersectionTableJoin.columns();
        for (int i = 0; i < columns.length; ++i) {
            this.addColumn(table, localDesc, columns[i].getForeignDbColumn(), columns[i].getLocalDbColumn());
        }
        TableJoinColumn[] otherColumns = this.tableJoin.columns();
        for (int i = 0; i < otherColumns.length; ++i) {
            this.addColumn(table, targetDesc, otherColumns[i].getLocalDbColumn(), otherColumns[i].getForeignDbColumn());
        }
        return table;
    }

    private void addColumn(MTable table, BeanDescriptor<?> desc, String column, String findPropColumn) {
        BeanProperty p = desc.getIdBinder().findBeanProperty(findPropColumn);
        if (p == null) {
            throw new RuntimeException("Could not find id property for " + findPropColumn);
        }
        MColumn col = new MColumn(column, this.ctx.getColumnDefn(p, true), true);
        col.setPrimaryKey(true);
        table.addColumn(col);
    }
}

