/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.dbmigration.model;

import com.avaje.ebean.dbmigration.model.MigrationResource;
import com.avaje.ebean.dbmigration.model.MigrationVersion;
import com.avaje.ebean.dbmigration.model.ModelContainer;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationModel {
    private static final Logger logger = LoggerFactory.getLogger(MigrationModel.class);
    private final ModelContainer model = new ModelContainer();
    private final File modelDirectory;
    private final String modelSuffix;
    private MigrationVersion lastVersion;

    public MigrationModel(File modelDirectory, String modelSuffix) {
        this.modelDirectory = modelDirectory;
        this.modelSuffix = modelSuffix;
    }

    public ModelContainer read() {
        this.readMigrations();
        return this.model;
    }

    private void readMigrations() {
        File[] xmlFiles = this.modelDirectory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().toLowerCase().endsWith(MigrationModel.this.modelSuffix);
            }
        });
        ArrayList<MigrationResource> resources = new ArrayList<MigrationResource>();
        for (File xmlFile : xmlFiles) {
            resources.add(new MigrationResource(xmlFile, this.createVersion(xmlFile)));
        }
        Collections.sort(resources);
        for (MigrationResource migrationResource : resources) {
            logger.debug("read {}", (Object)migrationResource);
            this.model.apply(migrationResource.read(), migrationResource.getVersion());
        }
        if (!resources.isEmpty()) {
            this.lastVersion = ((MigrationResource)resources.get(resources.size() - 1)).getVersion();
        }
    }

    private MigrationVersion createVersion(File xmlFile) {
        String fileName = xmlFile.getName();
        String versionName = fileName.substring(0, fileName.length() - this.modelSuffix.length());
        return MigrationVersion.parse(versionName);
    }

    public String getNextVersion(String initialVersion) {
        return this.lastVersion == null ? initialVersion : this.lastVersion.nextVersion();
    }
}

