/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.dbmigration.model;

import com.avaje.ebean.dbmigration.migration.AddColumn;
import com.avaje.ebean.dbmigration.migration.AddHistoryTable;
import com.avaje.ebean.dbmigration.migration.AddTableComment;
import com.avaje.ebean.dbmigration.migration.AlterColumn;
import com.avaje.ebean.dbmigration.migration.Column;
import com.avaje.ebean.dbmigration.migration.CreateTable;
import com.avaje.ebean.dbmigration.migration.DropColumn;
import com.avaje.ebean.dbmigration.migration.DropHistoryTable;
import com.avaje.ebean.dbmigration.migration.DropTable;
import com.avaje.ebean.dbmigration.migration.IdentityType;
import com.avaje.ebean.dbmigration.migration.UniqueConstraint;
import com.avaje.ebean.dbmigration.model.MColumn;
import com.avaje.ebean.dbmigration.model.MCompoundForeignKey;
import com.avaje.ebean.dbmigration.model.MCompoundUniqueConstraint;
import com.avaje.ebean.dbmigration.model.ModelContainer;
import com.avaje.ebean.dbmigration.model.ModelDiff;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MTable {
    private static final Logger logger = LoggerFactory.getLogger(MTable.class);
    private final String name;
    private MTable draftTable;
    private boolean draft;
    private String pkName;
    private String comment;
    private String tablespace;
    private String indexTablespace;
    private IdentityType identityType;
    private String sequenceName;
    private int sequenceInitial;
    private int sequenceAllocate;
    private boolean withHistory;
    private Map<String, MColumn> columns = new LinkedHashMap<String, MColumn>();
    private List<MCompoundUniqueConstraint> uniqueConstraints = new ArrayList<MCompoundUniqueConstraint>();
    private List<MCompoundForeignKey> compoundKeys = new ArrayList<MCompoundForeignKey>();
    private String whenCreatedColumn;
    private AddColumn addColumn;
    private List<String> droppedColumns = new ArrayList<String>();

    public MTable createDraftTable() {
        this.draftTable = new MTable(this.name + "_draft");
        this.draftTable.draft = true;
        this.draftTable.whenCreatedColumn = this.whenCreatedColumn;
        this.draftTable.identityType = this.identityType;
        for (MColumn col : this.allColumns()) {
            this.draftTable.addColumn(col.copyForDraft());
        }
        return this.draftTable;
    }

    public MTable(CreateTable createTable) {
        this.name = createTable.getName();
        this.pkName = createTable.getPkName();
        this.comment = createTable.getComment();
        this.tablespace = createTable.getTablespace();
        this.indexTablespace = createTable.getIndexTablespace();
        this.withHistory = Boolean.TRUE.equals(createTable.isWithHistory());
        this.draft = Boolean.TRUE.equals(createTable.isDraft());
        this.sequenceName = createTable.getSequenceName();
        this.sequenceInitial = this.toInt(createTable.getSequenceInitial());
        this.sequenceAllocate = this.toInt(createTable.getSequenceAllocate());
        List<Column> cols = createTable.getColumn();
        for (Column column : cols) {
            this.addColumn(column);
        }
    }

    public MTable(String name) {
        this.name = name;
    }

    public DropTable dropTable() {
        DropTable dropTable = new DropTable();
        dropTable.setName(this.name);
        return dropTable;
    }

    public CreateTable createTable() {
        CreateTable createTable = new CreateTable();
        createTable.setName(this.name);
        createTable.setPkName(this.pkName);
        createTable.setComment(this.comment);
        createTable.setTablespace(this.tablespace);
        createTable.setIndexTablespace(this.indexTablespace);
        createTable.setSequenceName(this.sequenceName);
        createTable.setSequenceInitial(this.toBigInteger(this.sequenceInitial));
        createTable.setSequenceAllocate(this.toBigInteger(this.sequenceAllocate));
        createTable.setIdentityType(this.identityType);
        if (this.withHistory) {
            createTable.setWithHistory(Boolean.TRUE);
        }
        if (this.draft) {
            createTable.setDraft(Boolean.TRUE);
        }
        for (MColumn column : this.allColumns()) {
            if (!this.draft && column.isDraftOnly()) continue;
            createTable.getColumn().add(column.createColumn());
        }
        for (MCompoundForeignKey compoundKey : this.compoundKeys) {
            createTable.getForeignKey().add(compoundKey.createForeignKey());
        }
        for (MCompoundUniqueConstraint constraint : this.uniqueConstraints) {
            UniqueConstraint uq = new UniqueConstraint();
            uq.setName(constraint.getName());
            String[] columns = constraint.getColumns();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < columns.length; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(columns[i]);
            }
            uq.setColumnNames(sb.toString());
            createTable.getUniqueConstraint().add(uq);
        }
        return createTable;
    }

    public void compare(ModelDiff modelDiff, MTable newTable) {
        if (this.withHistory != newTable.withHistory) {
            if (this.withHistory) {
                DropHistoryTable dropHistoryTable = new DropHistoryTable();
                dropHistoryTable.setBaseTable(this.name);
                modelDiff.addDropHistoryTable(dropHistoryTable);
            } else {
                AddHistoryTable addHistoryTable = new AddHistoryTable();
                addHistoryTable.setBaseTable(this.name);
                modelDiff.addAddHistoryTable(addHistoryTable);
            }
        }
        this.addColumn = null;
        Map<String, MColumn> newColumnMap = newTable.getColumns();
        for (MColumn newColumn : newColumnMap.values()) {
            MColumn localColumn = this.getColumn(newColumn.getName());
            if (localColumn == null) {
                if (newColumn.isDraftOnly() && !this.draft) continue;
                this.diffNewColumn(newColumn);
                continue;
            }
            localColumn.compare(modelDiff, this, newColumn);
        }
        for (MColumn existingColumn : this.allColumns()) {
            MColumn newColumn = newColumnMap.get(existingColumn.getName());
            if (newColumn == null) {
                this.diffDropColumn(modelDiff, existingColumn);
                continue;
            }
            if (!newColumn.isDraftOnly() || this.draft) continue;
            logger.trace("... drop column {} from table {} as now draftOnly", (Object)newColumn.getName(), (Object)this.name);
            this.diffDropColumn(modelDiff, existingColumn);
        }
        if (this.addColumn != null) {
            modelDiff.addAddColumn(this.addColumn);
        }
        if (MColumn.different(this.comment, newTable.comment)) {
            AddTableComment addTableComment = new AddTableComment();
            addTableComment.setName(this.name);
            addTableComment.setComment(newTable.comment);
            modelDiff.addTableComment(addTableComment);
        }
    }

    public void apply(AddColumn addColumn) {
        this.checkTableName(addColumn.getTableName());
        for (Column column : addColumn.getColumn()) {
            this.addColumn(column);
        }
    }

    public void apply(AlterColumn alterColumn) {
        this.checkTableName(alterColumn.getTableName());
        String columnName = alterColumn.getColumnName();
        MColumn existingColumn = this.getColumn(columnName);
        if (existingColumn == null) {
            throw new IllegalStateException("Column [" + columnName + "] does not exist for AlterColumn change?");
        }
        existingColumn.apply(alterColumn);
    }

    public void apply(DropColumn dropColumn) {
        this.checkTableName(dropColumn.getTableName());
        MColumn removed = this.columns.remove(dropColumn.getColumnName());
        if (removed == null) {
            throw new IllegalStateException("Column [" + dropColumn.getColumnName() + "] does not exist for DropColumn change on table [" + dropColumn.getTableName() + "]?");
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean isDraft() {
        return this.draft;
    }

    public void setPkName(String pkName) {
        this.pkName = pkName;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getTablespace() {
        return this.tablespace;
    }

    public String getIndexTablespace() {
        return this.indexTablespace;
    }

    public boolean isWithHistory() {
        return this.withHistory;
    }

    public MTable setWithHistory(boolean withHistory) {
        this.withHistory = withHistory;
        return this;
    }

    public List<String> allHistoryColumns(boolean includeDropped) {
        ArrayList<String> columnNames = new ArrayList<String>(this.columns.size());
        for (MColumn column : this.columns.values()) {
            if (!column.isIncludeInHistory()) continue;
            columnNames.add(column.getName());
        }
        if (includeDropped && !this.droppedColumns.isEmpty()) {
            for (String droppedColumn : this.droppedColumns) {
                columnNames.add(droppedColumn);
            }
        }
        return columnNames;
    }

    public Collection<MColumn> allColumns() {
        return this.columns.values();
    }

    public MColumn getColumn(String name) {
        return this.columns.get(name);
    }

    private Map<String, MColumn> getColumns() {
        return this.columns;
    }

    public List<MCompoundUniqueConstraint> getUniqueConstraints() {
        return this.uniqueConstraints;
    }

    public List<MCompoundForeignKey> getCompoundKeys() {
        return this.compoundKeys;
    }

    public void setSequenceName(String sequenceName) {
        this.sequenceName = sequenceName;
    }

    public void setSequenceInitial(int sequenceInitial) {
        this.sequenceInitial = sequenceInitial;
    }

    public void setSequenceAllocate(int sequenceAllocate) {
        this.sequenceAllocate = sequenceAllocate;
    }

    public void setWhenCreatedColumn(String whenCreatedColumn) {
        this.whenCreatedColumn = whenCreatedColumn;
    }

    public String getWhenCreatedColumn() {
        return this.whenCreatedColumn;
    }

    public void setIdentityType(IdentityType identityType) {
        this.identityType = identityType;
    }

    public List<MColumn> primaryKeyColumns() {
        ArrayList<MColumn> pk = new ArrayList<MColumn>(3);
        for (MColumn column : this.allColumns()) {
            if (!column.isPrimaryKey()) continue;
            pk.add(column);
        }
        return pk;
    }

    private void checkTableName(String tableName) {
        if (!this.name.equals(tableName)) {
            throw new IllegalArgumentException("addColumn tableName [" + tableName + "] does not match [" + this.name + "]");
        }
    }

    private void addColumn(Column column) {
        this.columns.put(column.getName(), new MColumn(column));
    }

    public void addColumn(MColumn column) {
        this.columns.put(column.getName(), column);
    }

    public void addUniqueConstraint(String[] columns, boolean oneToOne, String constraintName) {
        this.uniqueConstraints.add(new MCompoundUniqueConstraint(columns, oneToOne, constraintName));
    }

    public void addUniqueConstraint(List<MColumn> columns, boolean oneToOne, String constraintName) {
        String[] cols = new String[columns.size()];
        for (int i = 0; i < columns.size(); ++i) {
            cols[i] = columns.get(i).getName();
        }
        this.addUniqueConstraint(cols, oneToOne, constraintName);
    }

    public void addForeignKey(MCompoundForeignKey compoundKey) {
        this.compoundKeys.add(compoundKey);
    }

    public MColumn addColumn(String dbCol, String columnDefn, boolean notnull) {
        MColumn existingColumn = this.getColumn(dbCol);
        if (existingColumn != null) {
            if (notnull) {
                existingColumn.setNotnull(true);
            }
            return existingColumn;
        }
        MColumn newCol = new MColumn(dbCol, columnDefn, notnull);
        this.addColumn(newCol);
        return newCol;
    }

    private void diffNewColumn(MColumn newColumn) {
        if (this.addColumn == null) {
            this.addColumn = new AddColumn();
            this.addColumn.setTableName(this.name);
            if (this.withHistory) {
                this.addColumn.setWithHistory(Boolean.TRUE);
            }
        }
        this.addColumn.getColumn().add(newColumn.createColumn());
    }

    private void diffDropColumn(ModelDiff modelDiff, MColumn existingColumn) {
        DropColumn dropColumn = new DropColumn();
        dropColumn.setTableName(this.name);
        dropColumn.setColumnName(existingColumn.getName());
        if (this.withHistory && !existingColumn.isHistoryExclude()) {
            dropColumn.setWithHistory(Boolean.TRUE);
        }
        modelDiff.addDropColumn(dropColumn);
    }

    public void registerPendingDropColumn(String columnName) {
        this.droppedColumns.add(columnName);
    }

    private int toInt(BigInteger value) {
        return value == null ? 0 : value.intValue();
    }

    private BigInteger toBigInteger(int value) {
        return value == 0 ? null : BigInteger.valueOf(value);
    }

    public void checkDuplicateForeignKeys() {
        if (this.hasDuplicateForeignKeys()) {
            int counter = 1;
            for (MCompoundForeignKey fk : this.compoundKeys) {
                fk.addNameSuffix(counter++);
            }
        }
    }

    private boolean hasDuplicateForeignKeys() {
        HashSet<String> fkNames = new HashSet<String>();
        for (MCompoundForeignKey fk : this.compoundKeys) {
            if (fkNames.add(fk.getName())) continue;
            return true;
        }
        return false;
    }

    public void adjustReferences(ModelContainer modelContainer) {
        Collection<MColumn> cols = this.allColumns();
        for (MColumn col : cols) {
            String references = col.getReferences();
            if (references == null) continue;
            String baseTable = this.extractBaseTable(references);
            MTable refBaseTable = modelContainer.getTable(baseTable);
            if (refBaseTable.draftTable == null) continue;
            String newReferences = this.deriveReferences(references, refBaseTable.draftTable.getName());
            col.setReferences(newReferences);
        }
    }

    private String extractBaseTable(String references) {
        int lastDot = references.lastIndexOf(46);
        return references.substring(0, lastDot);
    }

    private String deriveReferences(String references, String draftTableName) {
        int lastDot = references.lastIndexOf(46);
        return draftTableName + "." + references.substring(lastDot + 1);
    }
}

