/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.dbmigration.model;

import com.avaje.ebean.config.DbConstraintNaming;
import com.avaje.ebean.dbmigration.ddlgeneration.DdlHandler;
import com.avaje.ebean.dbmigration.ddlgeneration.DdlWrite;
import com.avaje.ebean.dbmigration.ddlgeneration.platform.DefaultConstraintMaxLength;
import com.avaje.ebean.dbmigration.migration.ChangeSet;
import com.avaje.ebean.dbmigration.model.MConfiguration;
import com.avaje.ebean.dbmigration.model.ModelContainer;
import com.avaje.ebean.dbmigration.model.ModelDiff;
import com.avaje.ebean.dbmigration.model.build.ModelBuildBeanVisitor;
import com.avaje.ebean.dbmigration.model.build.ModelBuildContext;
import com.avaje.ebean.dbmigration.model.visitor.BeanVisitor;
import com.avaje.ebean.dbmigration.model.visitor.VisitAllUsing;
import com.avaje.ebeaninternal.api.SpiEbeanServer;
import java.io.IOException;

public class CurrentModel {
    private final SpiEbeanServer server;
    private final DbConstraintNaming constraintNaming;
    private final DbConstraintNaming.MaxLength maxLength;
    private final boolean platformTypes;
    private ModelContainer model;
    private ChangeSet changeSet;
    private DdlWrite write;

    public CurrentModel(SpiEbeanServer server) {
        this(server, server.getServerConfig().getConstraintNaming(), true);
    }

    public CurrentModel(SpiEbeanServer server, DbConstraintNaming constraintNaming) {
        this(server, constraintNaming, false);
    }

    private CurrentModel(SpiEbeanServer server, DbConstraintNaming constraintNaming, boolean platformTypes) {
        this.server = server;
        this.constraintNaming = constraintNaming;
        this.maxLength = CurrentModel.maxLength(server, constraintNaming);
        this.platformTypes = platformTypes;
    }

    private static DbConstraintNaming.MaxLength maxLength(SpiEbeanServer server, DbConstraintNaming naming) {
        if (naming.getMaxLength() != null) {
            return naming.getMaxLength();
        }
        int maxConstraintNameLength = server.getDatabasePlatform().getMaxConstraintNameLength();
        return new DefaultConstraintMaxLength(maxConstraintNameLength);
    }

    public ModelContainer read() {
        if (this.model == null) {
            this.model = new ModelContainer();
            ModelBuildContext context = new ModelBuildContext(this.model, this.constraintNaming, this.maxLength, this.platformTypes);
            ModelBuildBeanVisitor visitor = new ModelBuildBeanVisitor(context);
            VisitAllUsing visit = new VisitAllUsing((BeanVisitor)visitor, this.server);
            visit.visitAllBeans();
            context.adjustDraftReferences();
        }
        return this.model;
    }

    public void setChangeSet(ChangeSet changeSet) {
        this.changeSet = changeSet;
    }

    public ChangeSet getChangeSet() {
        this.read();
        if (this.changeSet == null) {
            this.changeSet = this.asChangeSet();
        }
        return this.changeSet;
    }

    public String getCreateDdl() throws IOException {
        this.createDdl();
        StringBuilder ddl = new StringBuilder(2000);
        ddl.append(this.write.apply().getBuffer());
        ddl.append(this.write.applyForeignKeys().getBuffer());
        ddl.append(this.write.applyHistory().getBuffer());
        return ddl.toString();
    }

    public String getDropAllDdl() throws IOException {
        this.createDdl();
        StringBuilder ddl = new StringBuilder(2000);
        ddl.append(this.write.dropAllForeignKeys().getBuffer());
        ddl.append(this.write.dropAll().getBuffer());
        return ddl.toString();
    }

    private void createDdl() throws IOException {
        if (this.write == null) {
            ChangeSet createChangeSet = this.getChangeSet();
            this.write = new DdlWrite(new MConfiguration(), this.model);
            DdlHandler handler = this.handler();
            handler.generate(this.write, createChangeSet);
        }
    }

    private DdlHandler handler() {
        return this.server.getDatabasePlatform().createDdlHandler(this.server.getServerConfig());
    }

    private ChangeSet asChangeSet() {
        ModelDiff diff = new ModelDiff();
        diff.compareTo(this.model);
        return diff.getApplyChangeSet();
    }
}

