/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.dbmigration.ddlgeneration.platform;

import com.avaje.ebean.config.DbConstraintNaming;
import com.avaje.ebean.config.ServerConfig;
import com.avaje.ebean.dbmigration.ddlgeneration.DdlBuffer;
import com.avaje.ebean.dbmigration.ddlgeneration.DdlWrite;
import com.avaje.ebean.dbmigration.ddlgeneration.platform.DbTriggerUpdate;
import com.avaje.ebean.dbmigration.ddlgeneration.platform.HistoryTableUpdate;
import com.avaje.ebean.dbmigration.ddlgeneration.platform.PlatformDdl;
import com.avaje.ebean.dbmigration.ddlgeneration.platform.PlatformHistoryDdl;
import com.avaje.ebean.dbmigration.migration.AddHistoryTable;
import com.avaje.ebean.dbmigration.migration.DropHistoryTable;
import com.avaje.ebean.dbmigration.model.MColumn;
import com.avaje.ebean.dbmigration.model.MTable;
import java.io.IOException;
import java.util.Collection;
import java.util.List;

public abstract class DbTriggerBasedHistoryDdl
implements PlatformHistoryDdl {
    protected DbConstraintNaming constraintNaming;
    protected PlatformDdl platformDdl;
    protected String sysPeriod;
    protected String sysPeriodStart;
    protected String sysPeriodEnd;
    protected String viewSuffix;
    protected String historySuffix;
    protected String currentTimestamp = "now(6)";
    protected String sysPeriodType = "datetime(6)";

    @Override
    public void configure(ServerConfig serverConfig, PlatformDdl platformDdl) {
        this.platformDdl = platformDdl;
        this.sysPeriod = serverConfig.getAsOfSysPeriod();
        this.viewSuffix = serverConfig.getAsOfViewSuffix();
        this.historySuffix = serverConfig.getHistoryTableSuffix();
        this.constraintNaming = serverConfig.getConstraintNaming();
        this.sysPeriodStart = this.sysPeriod + "_start";
        this.sysPeriodEnd = this.sysPeriod + "_end";
    }

    @Override
    public void updateTriggers(DdlWrite writer, HistoryTableUpdate update) throws IOException {
        MTable table = writer.getTable(update.getBaseTable());
        if (table == null) {
            throw new IllegalStateException("MTable " + update.getBaseTable() + " not found in writer? (required for history DDL)");
        }
        this.updateTriggers(writer, table, update);
    }

    protected abstract void updateHistoryTriggers(DbTriggerUpdate var1) throws IOException;

    protected void updateTriggers(DdlWrite writer, MTable table, HistoryTableUpdate update) throws IOException {
        writer.applyHistory().append("-- changes: ").append(update.description()).newLine();
        this.updateHistoryTriggers(this.createDbTriggerUpdate(writer, table));
    }

    protected DbTriggerUpdate createDbTriggerUpdate(DdlWrite writer, MTable table) {
        List<String> columns = this.columnNamesForApply(table);
        String baseTableName = table.getName();
        String historyTableName = this.historyTableName(baseTableName);
        return new DbTriggerUpdate(baseTableName, historyTableName, writer, columns);
    }

    @Override
    public void dropHistoryTable(DdlWrite writer, DropHistoryTable dropHistoryTable) throws IOException {
        String baseTable = dropHistoryTable.getBaseTable();
        this.dropTriggers(writer.applyDropDependencies(), baseTable);
        this.dropHistoryTableEtc(writer.applyDropDependencies(), baseTable);
    }

    @Override
    public void addHistoryTable(DdlWrite writer, AddHistoryTable addHistoryTable) throws IOException {
        String baseTable = addHistoryTable.getBaseTable();
        MTable table = writer.getTable(baseTable);
        if (table == null) {
            throw new IllegalStateException("MTable " + baseTable + " not found in writer? (required for history DDL)");
        }
        this.createWithHistory(writer, table);
    }

    @Override
    public void createWithHistory(DdlWrite writer, MTable table) throws IOException {
        String baseTable = table.getName();
        String whenCreatedColumn = table.getWhenCreatedColumn();
        this.dropTriggers(writer.dropAll(), baseTable);
        this.dropHistoryTableEtc(writer.dropAll(), baseTable);
        this.addHistoryTable(writer, table, whenCreatedColumn);
        this.createStoredFunction(writer, table);
        this.createTriggers(writer, table);
    }

    protected abstract void createTriggers(DdlWrite var1, MTable var2) throws IOException;

    protected abstract void dropTriggers(DdlBuffer var1, String var2) throws IOException;

    protected void createStoredFunction(DdlWrite writer, MTable table) throws IOException {
    }

    protected String normalise(String tableName) {
        return this.constraintNaming.normaliseTable(tableName);
    }

    protected String historyTableName(String baseTableName) {
        return baseTableName + this.historySuffix;
    }

    protected String procedureName(String baseTableName) {
        return baseTableName + "_history_version";
    }

    protected String triggerName(String baseTableName) {
        return this.normalise(baseTableName) + "_history_upd";
    }

    protected String updateTriggerName(String baseTableName) {
        return this.normalise(baseTableName) + "_history_upd";
    }

    protected String deleteTriggerName(String baseTableName) {
        return this.normalise(baseTableName) + "_history_del";
    }

    protected void addHistoryTable(DdlWrite writer, MTable table, String whenCreatedColumn) throws IOException {
        String baseTableName = table.getName();
        DdlBuffer apply = writer.applyHistory();
        this.addSysPeriodColumns(apply, baseTableName, whenCreatedColumn);
        this.createHistoryTable(apply, table);
        this.createWithHistoryView(apply, baseTableName);
    }

    protected void addSysPeriodColumns(DdlBuffer apply, String baseTableName, String whenCreatedColumn) throws IOException {
        apply.append("alter table ").append(baseTableName).append(" add column ").append(this.sysPeriodStart).append(" ").append(this.sysPeriodType).append(" default ").append(this.currentTimestamp).endOfStatement();
        apply.append("alter table ").append(baseTableName).append(" add column ").append(this.sysPeriodEnd).append(" ").append(this.sysPeriodType).endOfStatement();
        if (whenCreatedColumn != null) {
            apply.append("update ").append(baseTableName).append(" set ").append(this.sysPeriodStart).append(" = ").append(whenCreatedColumn).endOfStatement();
        }
    }

    protected void createHistoryTable(DdlBuffer apply, MTable table) throws IOException {
        apply.append("create table ").append(table.getName()).append(this.historySuffix).append("(").newLine();
        Collection<MColumn> cols = table.allColumns();
        for (MColumn column : cols) {
            if (column.isDraftOnly()) continue;
            this.writeColumnDefinition(apply, column.getName(), column.getType());
            apply.append(",").newLine();
        }
        this.writeColumnDefinition(apply, this.sysPeriodStart, this.sysPeriodType);
        apply.append(",").newLine();
        this.writeColumnDefinition(apply, this.sysPeriodEnd, this.sysPeriodType);
        apply.newLine().append(")").endOfStatement();
    }

    protected void writeColumnDefinition(DdlBuffer buffer, String columnName, String type) throws IOException {
        String platformType = this.platformDdl.convert(type, false);
        buffer.append("  ");
        buffer.append(this.platformDdl.lowerColumnName(columnName), 29);
        buffer.append(platformType);
    }

    protected void createWithHistoryView(DdlBuffer apply, String baseTableName) throws IOException {
        apply.append("create view ").append(baseTableName).append(this.viewSuffix).append(" as select * from ").append(baseTableName).append(" union all select * from ").append(baseTableName).append(this.historySuffix).endOfStatement().end();
    }

    protected void createWithHistoryView(DbTriggerUpdate update) throws IOException {
        DdlBuffer apply = update.historyBuffer();
        apply.append("create or replace view ").append(update.getBaseTable()).append(this.viewSuffix).append(" as select ");
        this.appendColumnNames(apply, update.getColumns(), "");
        this.appendSysPeriodColumns(apply, ", ");
        apply.append(" from ").append(update.getBaseTable()).append(" union all select ");
        this.appendColumnNames(apply, update.getColumns(), "");
        this.appendSysPeriodColumns(apply, ", ");
        apply.append(" from ").append(update.getHistoryTable()).endOfStatement().end();
    }

    protected void appendSysPeriodColumns(DdlBuffer apply, String prefix) throws IOException {
        this.appendColumnName(apply, prefix, this.sysPeriodStart);
        this.appendColumnName(apply, prefix, this.sysPeriodEnd);
    }

    protected void dropHistoryTableEtc(DdlBuffer buffer, String baseTableName) throws IOException {
        buffer.append("drop view ").append(baseTableName).append(this.viewSuffix).endOfStatement();
        this.dropSysPeriodColumns(buffer, baseTableName);
        buffer.append("drop table ").append(baseTableName).append(this.historySuffix).endOfStatement().end();
    }

    protected void dropSysPeriodColumns(DdlBuffer buffer, String baseTableName) throws IOException {
        buffer.append("alter table ").append(baseTableName).append(" drop column ").append(this.sysPeriodStart).endOfStatement();
        buffer.append("alter table ").append(baseTableName).append(" drop column ").append(this.sysPeriodEnd).endOfStatement();
    }

    protected void appendInsertIntoHistory(DdlBuffer buffer, String historyTable, List<String> columns) throws IOException {
        buffer.append("    insert into ").append(historyTable).append(" (").append(this.sysPeriodStart).append(",").append(this.sysPeriodEnd).append(",");
        this.appendColumnNames(buffer, columns, "");
        buffer.append(") values (OLD.").append(this.sysPeriodStart).append(", ").append(this.currentTimestamp).append(",");
        this.appendColumnNames(buffer, columns, "OLD.");
        buffer.append(");").newLine();
    }

    protected void appendColumnNames(DdlBuffer buffer, List<String> columns, String columnPrefix) throws IOException {
        for (int i = 0; i < columns.size(); ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(columnPrefix);
            buffer.append(columns.get(i));
        }
    }

    protected void appendColumnName(DdlBuffer buffer, String prefix, String columnName) throws IOException {
        if (columnName != null) {
            buffer.append(prefix).append(columnName);
        }
    }

    protected List<String> columnNamesForApply(MTable table) {
        return table.allHistoryColumns(true);
    }
}

