/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.config.dbplatform;

import com.avaje.ebean.Transaction;
import com.avaje.ebean.config.dbplatform.PlatformIdGenerator;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.persistence.PersistenceException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleSequenceIdGenerator
implements PlatformIdGenerator {
    private static final Logger logger = LoggerFactory.getLogger(SimpleSequenceIdGenerator.class);
    private final String sql;
    private final DataSource dataSource;
    private final String seqName;

    public SimpleSequenceIdGenerator(DataSource dataSource, String sql, String seqName) {
        this.dataSource = dataSource;
        this.sql = sql;
        this.seqName = seqName;
    }

    @Override
    public String getName() {
        return this.seqName;
    }

    @Override
    public boolean isDbSequence() {
        return true;
    }

    @Override
    public void preAllocateIds(int batchSize) {
    }

    @Override
    public Object nextId(Transaction t) {
        ResultSet rset;
        PreparedStatement pstmt;
        Connection c;
        boolean useTxnConnection;
        block9: {
            useTxnConnection = t != null;
            c = null;
            pstmt = null;
            rset = null;
            c = useTxnConnection ? t.getConnection() : this.dataSource.getConnection();
            pstmt = c.prepareStatement(this.sql);
            rset = pstmt.executeQuery();
            if (!rset.next()) break block9;
            Integer n = rset.getInt(1);
            if (useTxnConnection) {
                this.closeResources(rset, pstmt, null);
            } else {
                this.closeResources(rset, pstmt, c);
            }
            return n;
        }
        try {
            try {
                String m = "Always expecting 1 row from " + this.sql;
                throw new PersistenceException(m);
            }
            catch (SQLException e) {
                throw new PersistenceException("Error getting sequence nextval", (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            if (useTxnConnection) {
                this.closeResources(rset, pstmt, null);
            } else {
                this.closeResources(rset, pstmt, c);
            }
            throw throwable;
        }
    }

    private void closeResources(ResultSet rset, PreparedStatement pstmt, Connection c) {
        try {
            if (rset != null) {
                rset.close();
            }
        }
        catch (SQLException e) {
            logger.error("Error closing ResultSet", (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
        }
        catch (SQLException e) {
            logger.error("Error closing PreparedStatement", (Throwable)e);
        }
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (SQLException e) {
            logger.error("Error closing Connection", (Throwable)e);
        }
    }
}

