/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.config.dbplatform;

import com.avaje.ebean.BackgroundExecutor;
import com.avaje.ebean.config.dbplatform.DatabasePlatform;
import com.avaje.ebean.config.dbplatform.DbType;
import com.avaje.ebean.config.dbplatform.H2DbEncrypt;
import com.avaje.ebean.config.dbplatform.H2SequenceIdGenerator;
import com.avaje.ebean.config.dbplatform.IdType;
import com.avaje.ebean.config.dbplatform.PlatformIdGenerator;
import com.avaje.ebean.dbmigration.ddlgeneration.platform.HsqldbDdl;
import javax.sql.DataSource;

public class HsqldbPlatform
extends DatabasePlatform {
    public HsqldbPlatform() {
        this.name = "hsqldb";
        this.dbEncrypt = new H2DbEncrypt();
        this.platformDdl = new HsqldbDdl(this);
        this.dbIdentity.setIdType(IdType.IDENTITY);
        this.dbIdentity.setSupportsGetGeneratedKeys(true);
        this.dbIdentity.setSupportsSequence(true);
        this.dbIdentity.setSupportsIdentity(true);
        this.dbTypeMap.put(4, new DbType("integer", false));
    }

    @Override
    public PlatformIdGenerator createSequenceIdGenerator(BackgroundExecutor be, DataSource ds, String seqName, int batchSize) {
        return new H2SequenceIdGenerator(be, ds, seqName, batchSize);
    }
}

