/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.config.dbplatform;

import com.avaje.ebean.BackgroundExecutor;
import com.avaje.ebean.config.ServerConfig;
import com.avaje.ebean.config.dbplatform.DatabasePlatform;
import com.avaje.ebean.config.dbplatform.H2DbEncrypt;
import com.avaje.ebean.config.dbplatform.H2HistorySupport;
import com.avaje.ebean.config.dbplatform.H2SequenceIdGenerator;
import com.avaje.ebean.config.dbplatform.IdType;
import com.avaje.ebean.config.dbplatform.PlatformIdGenerator;
import com.avaje.ebean.dbmigration.ddlgeneration.platform.H2Ddl;
import java.util.Properties;
import javax.sql.DataSource;

public class H2Platform
extends DatabasePlatform {
    public H2Platform() {
        this.name = "h2";
        this.dbEncrypt = new H2DbEncrypt();
        this.platformDdl = new H2Ddl(this);
        this.historySupport = new H2HistorySupport();
        this.nativeUuidType = true;
        this.dbDefaultValue.setNow("now()");
        this.dbIdentity.setIdType(IdType.IDENTITY);
        this.dbIdentity.setSupportsGetGeneratedKeys(true);
        this.dbIdentity.setSupportsSequence(true);
        this.dbIdentity.setSupportsIdentity(true);
        this.likeClause = "like ?";
    }

    @Override
    public void configure(ServerConfig serverConfig) {
        String idType;
        super.configure(serverConfig);
        Properties properties = serverConfig.getProperties();
        if (properties != null && (idType = properties.getProperty("ebean.h2.idtype")) != null) {
            this.dbIdentity.setIdType(IdType.valueOf(idType));
        }
    }

    @Override
    public PlatformIdGenerator createSequenceIdGenerator(BackgroundExecutor be, DataSource ds, String seqName, int batchSize) {
        return new H2SequenceIdGenerator(be, ds, seqName, batchSize);
    }

    @Override
    protected String withForUpdate(String sql) {
        return sql + " for update";
    }
}

