/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.config.dbplatform;

import com.avaje.ebean.config.ServerConfig;
import com.avaje.ebean.config.dbplatform.DbType;
import java.util.HashMap;
import java.util.Map;

public class DbTypeMap {
    private static final DbType UUID_NATIVE = new DbType("uuid", false);
    private static final DbType UUID_PLACEHOLDER = new DbType("uuidPlaceholder");
    private static final DbType JSON_CLOB_PLACEHOLDER = new DbType("jsonClobPlaceholder");
    private static final DbType JSON_BLOB_PLACEHOLDER = new DbType("jsonBlobPlaceholder");
    private static final DbType JSON_VARCHAR_PLACEHOLDER = new DbType("jsonVarcharPlaceholder");
    static Map<String, Integer> lookup = new HashMap<String, Integer>();
    private final Map<Integer, DbType> typeMap = new HashMap<Integer, DbType>();

    public static DbTypeMap logicalTypes() {
        return new DbTypeMap(true);
    }

    public DbTypeMap() {
        this.loadDefaults(false);
    }

    private DbTypeMap(boolean logicalTypes) {
        this.loadDefaults(logicalTypes);
    }

    private void loadDefaults(boolean logicalTypes) {
        this.put(16, new DbType("boolean"));
        this.put(-7, new DbType("bit"));
        this.put(4, new DbType("integer"));
        this.put(-5, new DbType("bigint"));
        this.put(7, new DbType("float"));
        this.put(8, new DbType("double"));
        this.put(5, new DbType("smallint"));
        this.put(-6, new DbType("tinyint"));
        this.put(3, new DbType("decimal", 38));
        this.put(12, new DbType("varchar", 255));
        this.put(1, new DbType("char", 1));
        this.put(2004, new DbType("blob"));
        this.put(2005, new DbType("clob"));
        this.put(2003, new DbType("array"));
        if (logicalTypes) {
            this.put(5000, new DbType("hstore", false));
            this.put(5001, new DbType("json", false));
            this.put(5002, new DbType("jsonb", false));
            this.put(5004, new DbType("jsonclob"));
            this.put(5005, new DbType("jsonblob"));
            this.put(5003, new DbType("jsonvarchar", 1000));
            this.put(5010, UUID_NATIVE);
        } else {
            this.put(5001, JSON_CLOB_PLACEHOLDER);
            this.put(5002, JSON_CLOB_PLACEHOLDER);
            this.put(5004, JSON_CLOB_PLACEHOLDER);
            this.put(5005, JSON_BLOB_PLACEHOLDER);
            this.put(5003, JSON_VARCHAR_PLACEHOLDER);
            this.put(5010, UUID_PLACEHOLDER);
        }
        this.put(-4, new DbType("longvarbinary"));
        this.put(-1, new DbType("lonvarchar"));
        this.put(-3, new DbType("varbinary", 255));
        this.put(-2, new DbType("binary", 255));
        this.put(91, new DbType("date"));
        this.put(92, new DbType("time"));
        this.put(93, new DbType("timestamp"));
    }

    public DbType lookup(String name, boolean withScale) {
        Integer typeKey = lookup.get(name = name.trim().toUpperCase());
        if (typeKey == null) {
            throw new IllegalArgumentException("Unknown type [" + name + "] - not standard sql type");
        }
        switch (typeKey) {
            case 5005: {
                return this.get(2004);
            }
            case 5004: {
                return this.get(2005);
            }
            case 5003: {
                return this.get(12);
            }
            case 5001: {
                return this.getJsonType(5001, withScale);
            }
            case 5002: {
                return this.getJsonType(5002, withScale);
            }
        }
        return this.get(typeKey);
    }

    private DbType getJsonType(int type, boolean withScale) {
        DbType dbType = this.get(type);
        if (dbType == JSON_CLOB_PLACEHOLDER) {
            return withScale ? this.get(12) : this.get(2005);
        }
        if (dbType == JSON_BLOB_PLACEHOLDER) {
            return this.get(2004);
        }
        if (dbType == JSON_VARCHAR_PLACEHOLDER) {
            return this.get(12);
        }
        return this.get(type);
    }

    public void put(int jdbcType, DbType dbType) {
        this.typeMap.put(jdbcType, dbType);
    }

    public DbType get(int jdbcType) {
        return this.typeMap.get(jdbcType);
    }

    public void config(boolean nativeUuidType, ServerConfig.DbUuid dbUuid) {
        if (nativeUuidType && dbUuid.useNativeType()) {
            this.put(5010, UUID_NATIVE);
        } else if (dbUuid.useBinary()) {
            this.put(5010, this.get(-2).withLength(16));
        } else {
            this.put(5010, this.get(12).withLength(40));
        }
    }

    static {
        lookup.put("BOOLEAN", 16);
        lookup.put("BIT", -7);
        lookup.put("INTEGER", 4);
        lookup.put("BIGINT", -5);
        lookup.put("REAL", 7);
        lookup.put("FLOAT", 7);
        lookup.put("DOUBLE", 8);
        lookup.put("SMALLINT", 5);
        lookup.put("TINYINT", -6);
        lookup.put("DECIMAL", 3);
        lookup.put("VARCHAR", 12);
        lookup.put("VARCHAR2", 12);
        lookup.put("CHAR", 1);
        lookup.put("BLOB", 2004);
        lookup.put("CLOB", 2005);
        lookup.put("LONGVARBINARY", -4);
        lookup.put("LONGVARCHAR", -1);
        lookup.put("VARBINARY", -3);
        lookup.put("BINARY", -2);
        lookup.put("DATE", 91);
        lookup.put("TIME", 92);
        lookup.put("TIMESTAMP", 93);
        lookup.put("ARRAY", 2003);
        lookup.put("UUID", 5010);
        lookup.put("JSON", 5001);
        lookup.put("JSONB", 5002);
        lookup.put("JSONCLOB", 5004);
        lookup.put("JSONBLOB", 5005);
        lookup.put("JSONVARCHAR", 5003);
    }
}

