/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.config;

import com.avaje.ebean.PersistenceContextScope;
import com.avaje.ebean.cache.ServerCacheManager;
import com.avaje.ebean.cache.ServerCachePlugin;
import com.avaje.ebean.config.AutoTuneConfig;
import com.avaje.ebean.config.ClassLoadConfig;
import com.avaje.ebean.config.ContainerConfig;
import com.avaje.ebean.config.CurrentUserProvider;
import com.avaje.ebean.config.DbConstraintNaming;
import com.avaje.ebean.config.DbMigrationConfig;
import com.avaje.ebean.config.DocStoreConfig;
import com.avaje.ebean.config.EncryptDeployManager;
import com.avaje.ebean.config.EncryptKeyManager;
import com.avaje.ebean.config.Encryptor;
import com.avaje.ebean.config.ExternalTransactionManager;
import com.avaje.ebean.config.IdGenerator;
import com.avaje.ebean.config.JsonConfig;
import com.avaje.ebean.config.NamingConvention;
import com.avaje.ebean.config.PersistBatch;
import com.avaje.ebean.config.PropertiesWrapper;
import com.avaje.ebean.config.PropertyMap;
import com.avaje.ebean.config.UnderscoreNamingConvention;
import com.avaje.ebean.config.dbplatform.DatabasePlatform;
import com.avaje.ebean.config.dbplatform.DbEncrypt;
import com.avaje.ebean.event.BeanFindController;
import com.avaje.ebean.event.BeanPersistController;
import com.avaje.ebean.event.BeanPersistListener;
import com.avaje.ebean.event.BeanPostLoad;
import com.avaje.ebean.event.BeanQueryAdapter;
import com.avaje.ebean.event.BulkTableEventListener;
import com.avaje.ebean.event.ServerConfigStartup;
import com.avaje.ebean.event.TransactionEventListener;
import com.avaje.ebean.event.changelog.ChangeLogListener;
import com.avaje.ebean.event.changelog.ChangeLogPrepare;
import com.avaje.ebean.event.changelog.ChangeLogRegister;
import com.avaje.ebean.event.readaudit.ReadAuditLogger;
import com.avaje.ebean.event.readaudit.ReadAuditPrepare;
import com.fasterxml.jackson.core.JsonFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import javax.sql.DataSource;
import org.avaje.datasource.DataSourceConfig;

public class ServerConfig {
    private String name;
    private Map<String, Object> serviceObject = new HashMap<String, Object>();
    private ContainerConfig containerConfig;
    private Properties properties;
    private String resourceDirectory;
    private boolean register = true;
    private boolean defaultServer;
    private boolean disableClasspathSearch;
    private List<Class<?>> classes = new ArrayList();
    private List<String> packages = new ArrayList<String>();
    private DocStoreConfig docStoreConfig = new DocStoreConfig();
    private CurrentUserProvider currentUserProvider;
    private AutoTuneConfig autoTuneConfig = new AutoTuneConfig();
    private JsonConfig.DateTime jsonDateTime = JsonConfig.DateTime.MILLIS;
    private JsonConfig.Include jsonInclude = JsonConfig.Include.ALL;
    private String databasePlatformName;
    private DatabasePlatform databasePlatform;
    private int databaseSequenceBatchSize = 20;
    private int jdbcFetchSizeFindList;
    private int jdbcFetchSizeFindEach = 100;
    private String asOfViewSuffix = "_with_history";
    private String asOfSysPeriod = "sys_period";
    private String historyTableSuffix = "_history";
    private PersistBatch persistBatch = PersistBatch.NONE;
    private PersistBatch persistBatchOnCascade = PersistBatch.INHERIT;
    private int persistBatchSize = 20;
    private int lazyLoadBatchSize = 10;
    private int queryBatchSize = 100;
    private boolean eagerFetchLobs;
    private String dataTimeZone;
    private boolean ddlGenerate;
    private boolean ddlRun;
    private boolean ddlCreateOnly;
    private String ddlInitSql;
    private String ddlSeedSql;
    private boolean skipCacheAfterWrite = true;
    private boolean useJtaTransactionManager;
    private ExternalTransactionManager externalTransactionManager;
    private DataSource dataSource;
    private DataSourceConfig dataSourceConfig = new DataSourceConfig();
    private DbMigrationConfig migrationConfig = new DbMigrationConfig();
    private ClassLoadConfig classLoadConfig = new ClassLoadConfig();
    private boolean autoCommitMode;
    private boolean explicitTransactionBeginMode;
    private String dataSourceJndiName;
    private String databaseBooleanTrue;
    private String databaseBooleanFalse;
    private NamingConvention namingConvention = new UnderscoreNamingConvention();
    private DbConstraintNaming constraintNaming = new DbConstraintNaming();
    private boolean updateChangesOnly = true;
    private boolean updateAllPropertiesInBatch = true;
    private boolean updatesDeleteMissingChildren = true;
    private DbUuid dbUuid = DbUuid.AUTO_VARCHAR;
    private List<IdGenerator> idGenerators = new ArrayList<IdGenerator>();
    private List<BeanFindController> findControllers = new ArrayList<BeanFindController>();
    private List<BeanPersistController> persistControllers = new ArrayList<BeanPersistController>();
    private List<BeanPostLoad> postLoaders = new ArrayList<BeanPostLoad>();
    private List<BeanPersistListener> persistListeners = new ArrayList<BeanPersistListener>();
    private List<BeanQueryAdapter> queryAdapters = new ArrayList<BeanQueryAdapter>();
    private List<BulkTableEventListener> bulkTableEventListeners = new ArrayList<BulkTableEventListener>();
    private List<ServerConfigStartup> configStartupListeners = new ArrayList<ServerConfigStartup>();
    private List<TransactionEventListener> transactionEventListeners = new ArrayList<TransactionEventListener>();
    private boolean changeLogIncludeInserts = true;
    private ChangeLogPrepare changeLogPrepare;
    private ChangeLogListener changeLogListener;
    private ChangeLogRegister changeLogRegister;
    private ReadAuditLogger readAuditLogger;
    private ReadAuditPrepare readAuditPrepare;
    private EncryptKeyManager encryptKeyManager;
    private EncryptDeployManager encryptDeployManager;
    private Encryptor encryptor;
    private DbEncrypt dbEncrypt;
    private ServerCachePlugin serverCachePlugin;
    private ServerCacheManager serverCacheManager;
    private boolean collectQueryStatsByNode = true;
    private boolean collectQueryOrigins = true;
    private PersistenceContextScope persistenceContextScope = PersistenceContextScope.TRANSACTION;
    private JsonFactory jsonFactory;
    private boolean localTimeWithNanos;
    private boolean durationWithNanos;
    private int maxCallStack = 5;
    private boolean transactionRollbackOnChecked = true;
    private int backgroundExecutorSchedulePoolSize = 1;
    private int backgroundExecutorShutdownSecs = 30;
    private int cacheMaxSize = 10000;
    private int cacheMaxIdleTime = 600;
    private int cacheMaxTimeToLive = 21600;
    private int queryCacheMaxSize = 1000;
    private int queryCacheMaxIdleTime = 600;
    private int queryCacheMaxTimeToLive = 21600;
    private Object objectMapper;
    private boolean expressionEqualsWithNullAsNoop;
    private boolean expressionNativeIlike;
    private String jodaLocalTimeMode;
    private boolean disableL2Cache;

    public void putServiceObject(String key, Object configObject) {
        this.serviceObject.put(key, configObject);
    }

    public Object getServiceObject(String key) {
        return this.serviceObject.get(key);
    }

    public JsonFactory getJsonFactory() {
        return this.jsonFactory;
    }

    public void setJsonFactory(JsonFactory jsonFactory) {
        this.jsonFactory = jsonFactory;
    }

    public JsonConfig.DateTime getJsonDateTime() {
        return this.jsonDateTime;
    }

    public void setJsonDateTime(JsonConfig.DateTime jsonDateTime) {
        this.jsonDateTime = jsonDateTime;
    }

    public JsonConfig.Include getJsonInclude() {
        return this.jsonInclude;
    }

    public void setJsonInclude(JsonConfig.Include jsonInclude) {
        this.jsonInclude = jsonInclude;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ContainerConfig getContainerConfig() {
        return this.containerConfig;
    }

    public void setContainerConfig(ContainerConfig containerConfig) {
        this.containerConfig = containerConfig;
    }

    public boolean isRegister() {
        return this.register;
    }

    public void setRegister(boolean register) {
        this.register = register;
    }

    public boolean isDefaultServer() {
        return this.defaultServer;
    }

    public void setDefaultServer(boolean defaultServer) {
        this.defaultServer = defaultServer;
    }

    public CurrentUserProvider getCurrentUserProvider() {
        return this.currentUserProvider;
    }

    public void setCurrentUserProvider(CurrentUserProvider currentUserProvider) {
        this.currentUserProvider = currentUserProvider;
    }

    public PersistBatch getPersistBatch() {
        return this.persistBatch;
    }

    public void setPersistBatch(PersistBatch persistBatch) {
        this.persistBatch = persistBatch;
    }

    public PersistBatch getPersistBatchOnCascade() {
        return this.persistBatchOnCascade;
    }

    public void setPersistBatchOnCascade(PersistBatch persistBatchOnCascade) {
        this.persistBatchOnCascade = persistBatchOnCascade;
    }

    public void setPersistBatching(boolean persistBatching) {
        this.persistBatch = persistBatching ? PersistBatch.ALL : PersistBatch.NONE;
    }

    public int getPersistBatchSize() {
        return this.persistBatchSize;
    }

    public void setPersistBatchSize(int persistBatchSize) {
        this.persistBatchSize = persistBatchSize;
    }

    public int getQueryBatchSize() {
        return this.queryBatchSize;
    }

    public void setQueryBatchSize(int queryBatchSize) {
        this.queryBatchSize = queryBatchSize;
    }

    public int getLazyLoadBatchSize() {
        return this.lazyLoadBatchSize;
    }

    public void setLazyLoadBatchSize(int lazyLoadBatchSize) {
        this.lazyLoadBatchSize = lazyLoadBatchSize;
    }

    public void setDatabaseSequenceBatchSize(int databaseSequenceBatchSize) {
        this.databaseSequenceBatchSize = databaseSequenceBatchSize;
    }

    public int getJdbcFetchSizeFindList() {
        return this.jdbcFetchSizeFindList;
    }

    public void setJdbcFetchSizeFindList(int jdbcFetchSizeFindList) {
        this.jdbcFetchSizeFindList = jdbcFetchSizeFindList;
    }

    public int getJdbcFetchSizeFindEach() {
        return this.jdbcFetchSizeFindEach;
    }

    public void setJdbcFetchSizeFindEach(int jdbcFetchSizeFindEach) {
        this.jdbcFetchSizeFindEach = jdbcFetchSizeFindEach;
    }

    public ChangeLogPrepare getChangeLogPrepare() {
        return this.changeLogPrepare;
    }

    public void setChangeLogPrepare(ChangeLogPrepare changeLogPrepare) {
        this.changeLogPrepare = changeLogPrepare;
    }

    public ChangeLogListener getChangeLogListener() {
        return this.changeLogListener;
    }

    public void setChangeLogListener(ChangeLogListener changeLogListener) {
        this.changeLogListener = changeLogListener;
    }

    public ChangeLogRegister getChangeLogRegister() {
        return this.changeLogRegister;
    }

    public void setChangeLogRegister(ChangeLogRegister changeLogRegister) {
        this.changeLogRegister = changeLogRegister;
    }

    public boolean isChangeLogIncludeInserts() {
        return this.changeLogIncludeInserts;
    }

    public void setChangeLogIncludeInserts(boolean changeLogIncludeInserts) {
        this.changeLogIncludeInserts = changeLogIncludeInserts;
    }

    public ReadAuditLogger getReadAuditLogger() {
        return this.readAuditLogger;
    }

    public void setReadAuditLogger(ReadAuditLogger readAuditLogger) {
        this.readAuditLogger = readAuditLogger;
    }

    public ReadAuditPrepare getReadAuditPrepare() {
        return this.readAuditPrepare;
    }

    public void setReadAuditPrepare(ReadAuditPrepare readAuditPrepare) {
        this.readAuditPrepare = readAuditPrepare;
    }

    public DbMigrationConfig getMigrationConfig() {
        return this.migrationConfig;
    }

    public void setMigrationConfig(DbMigrationConfig migrationConfig) {
        this.migrationConfig = migrationConfig;
    }

    public String getDataTimeZone() {
        return System.getProperty("ebean.dataTimeZone", this.dataTimeZone);
    }

    public void setDataTimeZone(String dataTimeZone) {
        this.dataTimeZone = dataTimeZone;
    }

    public String getAsOfViewSuffix() {
        return this.asOfViewSuffix;
    }

    public void setAsOfViewSuffix(String asOfViewSuffix) {
        this.asOfViewSuffix = asOfViewSuffix;
    }

    public String getAsOfSysPeriod() {
        return this.asOfSysPeriod;
    }

    public void setAsOfSysPeriod(String asOfSysPeriod) {
        this.asOfSysPeriod = asOfSysPeriod;
    }

    public String getHistoryTableSuffix() {
        return this.historyTableSuffix;
    }

    public void setHistoryTableSuffix(String historyTableSuffix) {
        this.historyTableSuffix = historyTableSuffix;
    }

    public boolean isUseJtaTransactionManager() {
        return this.useJtaTransactionManager;
    }

    public void setUseJtaTransactionManager(boolean useJtaTransactionManager) {
        this.useJtaTransactionManager = useJtaTransactionManager;
    }

    public ExternalTransactionManager getExternalTransactionManager() {
        return this.externalTransactionManager;
    }

    public void setExternalTransactionManager(ExternalTransactionManager externalTransactionManager) {
        this.externalTransactionManager = externalTransactionManager;
    }

    public ServerCachePlugin getServerCachePlugin() {
        return this.serverCachePlugin;
    }

    public void setServerCachePlugin(ServerCachePlugin serverCachePlugin) {
        this.serverCachePlugin = serverCachePlugin;
    }

    public ServerCacheManager getServerCacheManager() {
        return this.serverCacheManager;
    }

    public void setServerCacheManager(ServerCacheManager serverCacheManager) {
        this.serverCacheManager = serverCacheManager;
    }

    public boolean isEagerFetchLobs() {
        return this.eagerFetchLobs;
    }

    public void setEagerFetchLobs(boolean eagerFetchLobs) {
        this.eagerFetchLobs = eagerFetchLobs;
    }

    public int getMaxCallStack() {
        return this.maxCallStack;
    }

    public void setMaxCallStack(int maxCallStack) {
        this.maxCallStack = maxCallStack;
    }

    public boolean isTransactionRollbackOnChecked() {
        return this.transactionRollbackOnChecked;
    }

    public void setTransactionRollbackOnChecked(boolean transactionRollbackOnChecked) {
        this.transactionRollbackOnChecked = transactionRollbackOnChecked;
    }

    public int getBackgroundExecutorSchedulePoolSize() {
        return this.backgroundExecutorSchedulePoolSize;
    }

    public void setBackgroundExecutorSchedulePoolSize(int backgroundExecutorSchedulePoolSize) {
        this.backgroundExecutorSchedulePoolSize = backgroundExecutorSchedulePoolSize;
    }

    public int getBackgroundExecutorShutdownSecs() {
        return this.backgroundExecutorShutdownSecs;
    }

    public void setBackgroundExecutorShutdownSecs(int backgroundExecutorShutdownSecs) {
        this.backgroundExecutorShutdownSecs = backgroundExecutorShutdownSecs;
    }

    public int getCacheMaxSize() {
        return this.cacheMaxSize;
    }

    public void setCacheMaxSize(int cacheMaxSize) {
        this.cacheMaxSize = cacheMaxSize;
    }

    public int getCacheMaxIdleTime() {
        return this.cacheMaxIdleTime;
    }

    public void setCacheMaxIdleTime(int cacheMaxIdleTime) {
        this.cacheMaxIdleTime = cacheMaxIdleTime;
    }

    public int getCacheMaxTimeToLive() {
        return this.cacheMaxTimeToLive;
    }

    public void setCacheMaxTimeToLive(int cacheMaxTimeToLive) {
        this.cacheMaxTimeToLive = cacheMaxTimeToLive;
    }

    public int getQueryCacheMaxSize() {
        return this.queryCacheMaxSize;
    }

    public void setQueryCacheMaxSize(int queryCacheMaxSize) {
        this.queryCacheMaxSize = queryCacheMaxSize;
    }

    public int getQueryCacheMaxIdleTime() {
        return this.queryCacheMaxIdleTime;
    }

    public void setQueryCacheMaxIdleTime(int queryCacheMaxIdleTime) {
        this.queryCacheMaxIdleTime = queryCacheMaxIdleTime;
    }

    public int getQueryCacheMaxTimeToLive() {
        return this.queryCacheMaxTimeToLive;
    }

    public void setQueryCacheMaxTimeToLive(int queryCacheMaxTimeToLive) {
        this.queryCacheMaxTimeToLive = queryCacheMaxTimeToLive;
    }

    public NamingConvention getNamingConvention() {
        return this.namingConvention;
    }

    public void setNamingConvention(NamingConvention namingConvention) {
        this.namingConvention = namingConvention;
    }

    public DocStoreConfig getDocStoreConfig() {
        return this.docStoreConfig;
    }

    public void setDocStoreConfig(DocStoreConfig docStoreConfig) {
        this.docStoreConfig = docStoreConfig;
    }

    public DbConstraintNaming getConstraintNaming() {
        return this.constraintNaming;
    }

    public void setConstraintNaming(DbConstraintNaming constraintNaming) {
        this.constraintNaming = constraintNaming;
    }

    public AutoTuneConfig getAutoTuneConfig() {
        return this.autoTuneConfig;
    }

    public void setAutoTuneConfig(AutoTuneConfig autoTuneConfig) {
        this.autoTuneConfig = autoTuneConfig;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataSourceConfig getDataSourceConfig() {
        return this.dataSourceConfig;
    }

    public void setDataSourceConfig(DataSourceConfig dataSourceConfig) {
        this.dataSourceConfig = dataSourceConfig;
    }

    public String getDataSourceJndiName() {
        return this.dataSourceJndiName;
    }

    public void setDataSourceJndiName(String dataSourceJndiName) {
        this.dataSourceJndiName = dataSourceJndiName;
    }

    public boolean isAutoCommitMode() {
        return this.autoCommitMode;
    }

    public void setAutoCommitMode(boolean autoCommitMode) {
        this.autoCommitMode = autoCommitMode;
    }

    public boolean isExplicitTransactionBeginMode() {
        return this.explicitTransactionBeginMode;
    }

    public void setExplicitTransactionBeginMode(boolean explicitTransactionBeginMode) {
        this.explicitTransactionBeginMode = explicitTransactionBeginMode;
    }

    public String getDatabaseBooleanTrue() {
        return this.databaseBooleanTrue;
    }

    public void setDatabaseBooleanTrue(String databaseTrue) {
        this.databaseBooleanTrue = databaseTrue;
    }

    public String getDatabaseBooleanFalse() {
        return this.databaseBooleanFalse;
    }

    public void setDatabaseBooleanFalse(String databaseFalse) {
        this.databaseBooleanFalse = databaseFalse;
    }

    public int getDatabaseSequenceBatchSize() {
        return this.databaseSequenceBatchSize;
    }

    public void setDatabaseSequenceBatch(int databaseSequenceBatchSize) {
        this.databaseSequenceBatchSize = databaseSequenceBatchSize;
    }

    public String getDatabasePlatformName() {
        return this.databasePlatformName;
    }

    public void setDatabasePlatformName(String databasePlatformName) {
        this.databasePlatformName = databasePlatformName;
    }

    public DatabasePlatform getDatabasePlatform() {
        return this.databasePlatform;
    }

    public void setDatabasePlatform(DatabasePlatform databasePlatform) {
        this.databasePlatform = databasePlatform;
    }

    public EncryptKeyManager getEncryptKeyManager() {
        return this.encryptKeyManager;
    }

    public void setEncryptKeyManager(EncryptKeyManager encryptKeyManager) {
        this.encryptKeyManager = encryptKeyManager;
    }

    public EncryptDeployManager getEncryptDeployManager() {
        return this.encryptDeployManager;
    }

    public void setEncryptDeployManager(EncryptDeployManager encryptDeployManager) {
        this.encryptDeployManager = encryptDeployManager;
    }

    public Encryptor getEncryptor() {
        return this.encryptor;
    }

    public void setEncryptor(Encryptor encryptor) {
        this.encryptor = encryptor;
    }

    public DbEncrypt getDbEncrypt() {
        return this.dbEncrypt;
    }

    public void setDbEncrypt(DbEncrypt dbEncrypt) {
        this.dbEncrypt = dbEncrypt;
    }

    public DbUuid getDbUuid() {
        return this.dbUuid;
    }

    public void setDbUuid(DbUuid dbUuid) {
        this.dbUuid = dbUuid;
    }

    public boolean isLocalTimeWithNanos() {
        return this.localTimeWithNanos;
    }

    public void setLocalTimeWithNanos(boolean localTimeWithNanos) {
        this.localTimeWithNanos = localTimeWithNanos;
    }

    public boolean isDurationWithNanos() {
        return this.durationWithNanos;
    }

    public void setDurationWithNanos(boolean durationWithNanos) {
        this.durationWithNanos = durationWithNanos;
    }

    public void setDdlGenerate(boolean ddlGenerate) {
        this.ddlGenerate = ddlGenerate;
    }

    public void setDdlRun(boolean ddlRun) {
        this.ddlRun = ddlRun;
    }

    public boolean isDdlCreateOnly() {
        return this.ddlCreateOnly;
    }

    public void setDdlCreateOnly(boolean ddlCreateOnly) {
        this.ddlCreateOnly = ddlCreateOnly;
    }

    public String getDdlSeedSql() {
        return this.ddlSeedSql;
    }

    public void setDdlSeedSql(String ddlSeedSql) {
        this.ddlSeedSql = ddlSeedSql;
    }

    public String getDdlInitSql() {
        return this.ddlInitSql;
    }

    public void setDdlInitSql(String ddlInitSql) {
        this.ddlInitSql = ddlInitSql;
    }

    public boolean isDdlGenerate() {
        return this.ddlGenerate;
    }

    public boolean isDdlRun() {
        return this.ddlRun;
    }

    public boolean isDisableClasspathSearch() {
        return this.disableClasspathSearch;
    }

    public void setDisableClasspathSearch(boolean disableClasspathSearch) {
        this.disableClasspathSearch = disableClasspathSearch;
    }

    public String getJodaLocalTimeMode() {
        return this.jodaLocalTimeMode;
    }

    public void setJodaLocalTimeMode(String jodaLocalTimeMode) {
        this.jodaLocalTimeMode = jodaLocalTimeMode;
    }

    public void addClass(Class<?> cls) {
        if (this.classes == null) {
            this.classes = new ArrayList();
        }
        this.classes.add(cls);
    }

    public void addPackage(String packageName) {
        if (this.packages == null) {
            this.packages = new ArrayList<String>();
        }
        this.packages.add(packageName);
    }

    public List<String> getPackages() {
        return this.packages;
    }

    public void setPackages(List<String> packages) {
        this.packages = packages;
    }

    public void setClasses(List<Class<?>> classes) {
        this.classes = classes;
    }

    public List<Class<?>> getClasses() {
        return this.classes;
    }

    public boolean isSkipCacheAfterWrite() {
        return this.skipCacheAfterWrite;
    }

    public void setSkipCacheAfterWrite(boolean skipCacheAfterWrite) {
        this.skipCacheAfterWrite = skipCacheAfterWrite;
    }

    public boolean isUpdateChangesOnly() {
        return this.updateChangesOnly;
    }

    public void setUpdateChangesOnly(boolean updateChangesOnly) {
        this.updateChangesOnly = updateChangesOnly;
    }

    public boolean isUpdateAllPropertiesInBatch() {
        return this.updateAllPropertiesInBatch;
    }

    public void setUpdateAllPropertiesInBatch(boolean updateAllPropertiesInBatch) {
        this.updateAllPropertiesInBatch = updateAllPropertiesInBatch;
    }

    public boolean isUpdatesDeleteMissingChildren() {
        return this.updatesDeleteMissingChildren;
    }

    public void setUpdatesDeleteMissingChildren(boolean updatesDeleteMissingChildren) {
        this.updatesDeleteMissingChildren = updatesDeleteMissingChildren;
    }

    public boolean isCollectQueryStatsByNode() {
        return this.collectQueryStatsByNode;
    }

    public void setCollectQueryStatsByNode(boolean collectQueryStatsByNode) {
        this.collectQueryStatsByNode = collectQueryStatsByNode;
    }

    public boolean isCollectQueryOrigins() {
        return this.collectQueryOrigins;
    }

    public void setCollectQueryOrigins(boolean collectQueryOrigins) {
        this.collectQueryOrigins = collectQueryOrigins;
    }

    public String getResourceDirectory() {
        return this.resourceDirectory;
    }

    public void setResourceDirectory(String resourceDirectory) {
        this.resourceDirectory = resourceDirectory;
    }

    public void add(BeanQueryAdapter beanQueryAdapter) {
        this.queryAdapters.add(beanQueryAdapter);
    }

    public List<BeanQueryAdapter> getQueryAdapters() {
        return this.queryAdapters;
    }

    public void setQueryAdapters(List<BeanQueryAdapter> queryAdapters) {
        this.queryAdapters = queryAdapters;
    }

    public List<IdGenerator> getIdGenerators() {
        return this.idGenerators;
    }

    public void setIdGenerators(List<IdGenerator> idGenerators) {
        this.idGenerators = idGenerators;
    }

    public void add(IdGenerator idGenerator) {
        this.idGenerators.add(idGenerator);
    }

    public void add(BeanPersistController beanPersistController) {
        this.persistControllers.add(beanPersistController);
    }

    public void add(BeanPostLoad postLoad) {
        this.postLoaders.add(postLoad);
    }

    public List<BeanFindController> getFindControllers() {
        return this.findControllers;
    }

    public void setFindControllers(List<BeanFindController> findControllers) {
        this.findControllers = findControllers;
    }

    public List<BeanPostLoad> getPostLoaders() {
        return this.postLoaders;
    }

    public void setPostLoaders(List<BeanPostLoad> postLoaders) {
        this.postLoaders = postLoaders;
    }

    public List<BeanPersistController> getPersistControllers() {
        return this.persistControllers;
    }

    public void setPersistControllers(List<BeanPersistController> persistControllers) {
        this.persistControllers = persistControllers;
    }

    public void add(TransactionEventListener listener) {
        this.transactionEventListeners.add(listener);
    }

    public List<TransactionEventListener> getTransactionEventListeners() {
        return this.transactionEventListeners;
    }

    public void setTransactionEventListeners(List<TransactionEventListener> transactionEventListeners) {
        this.transactionEventListeners = transactionEventListeners;
    }

    public void add(BeanPersistListener beanPersistListener) {
        this.persistListeners.add(beanPersistListener);
    }

    public List<BeanPersistListener> getPersistListeners() {
        return this.persistListeners;
    }

    public void add(BulkTableEventListener bulkTableEventListener) {
        this.bulkTableEventListeners.add(bulkTableEventListener);
    }

    public List<BulkTableEventListener> getBulkTableEventListeners() {
        return this.bulkTableEventListeners;
    }

    public void addServerConfigStartup(ServerConfigStartup configStartupListener) {
        this.configStartupListeners.add(configStartupListener);
    }

    public List<ServerConfigStartup> getServerConfigStartupListeners() {
        return this.configStartupListeners;
    }

    public void setPersistListeners(List<BeanPersistListener> persistListeners) {
        this.persistListeners = persistListeners;
    }

    public PersistenceContextScope getPersistenceContextScope() {
        return this.persistenceContextScope == null ? PersistenceContextScope.TRANSACTION : this.persistenceContextScope;
    }

    public void setPersistenceContextScope(PersistenceContextScope persistenceContextScope) {
        this.persistenceContextScope = persistenceContextScope;
    }

    public ClassLoadConfig getClassLoadConfig() {
        return this.classLoadConfig;
    }

    public void setClassLoadConfig(ClassLoadConfig classLoadConfig) {
        this.classLoadConfig = classLoadConfig;
    }

    public <T> ServiceLoader<T> serviceLoad(Class<T> spiService) {
        return ServiceLoader.load(spiService, this.classLoadConfig.getClassLoader());
    }

    public <T> T service(Class<T> spiService) {
        ServiceLoader<T> load = this.serviceLoad(spiService);
        Iterator<T> serviceInstances = load.iterator();
        return serviceInstances.hasNext() ? (T)serviceInstances.next() : null;
    }

    public void loadFromProperties() {
        this.loadFromProperties(PropertyMap.defaultProperties());
    }

    public void loadFromProperties(Properties properties) {
        this.properties = properties;
        PropertiesWrapper p = new PropertiesWrapper("ebean", this.name, properties);
        this.loadSettings(p);
    }

    public void loadTestProperties() {
        Properties properties = PropertyMap.testProperties();
        if (!properties.isEmpty()) {
            PropertiesWrapper p = new PropertiesWrapper("ebean", this.name, properties);
            this.loadSettings(p);
        }
    }

    public Properties getProperties() {
        return this.properties;
    }

    protected <T> T createInstance(PropertiesWrapper properties, Class<T> pluginType, String key, T instance) {
        if (instance != null) {
            return instance;
        }
        String classname = properties.get(key, null);
        return this.createInstance(pluginType, classname);
    }

    protected <T> T createInstance(Class<T> pluginType, String classname) {
        return (T)(classname == null ? null : this.classLoadConfig.newInstance(classname));
    }

    protected void loadDataSourceSettings(PropertiesWrapper p) {
        this.dataSourceConfig.loadSettings(p.properties, this.name);
    }

    protected void loadDocStoreSettings(PropertiesWrapper p) {
        this.docStoreConfig.loadSettings(p);
    }

    protected void loadAutoTuneSettings(PropertiesWrapper p) {
        this.autoTuneConfig.loadSettings(p);
    }

    protected void loadSettings(PropertiesWrapper p) {
        this.migrationConfig.loadSettings(p, this.name);
        this.namingConvention = this.createNamingConvention(p, this.namingConvention);
        if (this.namingConvention != null) {
            this.namingConvention.loadFromProperties(p);
        }
        if (this.autoTuneConfig == null) {
            this.autoTuneConfig = new AutoTuneConfig();
        }
        this.loadAutoTuneSettings(p);
        if (this.dataSourceConfig == null) {
            this.dataSourceConfig = new DataSourceConfig();
        }
        this.loadDataSourceSettings(p);
        if (this.docStoreConfig == null) {
            this.docStoreConfig = new DocStoreConfig();
        }
        this.loadDocStoreSettings(p);
        this.disableL2Cache = p.getBoolean("disableL2Cache", this.disableL2Cache);
        this.explicitTransactionBeginMode = p.getBoolean("explicitTransactionBeginMode", this.explicitTransactionBeginMode);
        this.autoCommitMode = p.getBoolean("autoCommitMode", this.autoCommitMode);
        this.useJtaTransactionManager = p.getBoolean("useJtaTransactionManager", this.useJtaTransactionManager);
        this.backgroundExecutorSchedulePoolSize = p.getInt("backgroundExecutorSchedulePoolSize", this.backgroundExecutorSchedulePoolSize);
        this.backgroundExecutorShutdownSecs = p.getInt("backgroundExecutorShutdownSecs", this.backgroundExecutorShutdownSecs);
        this.disableClasspathSearch = p.getBoolean("disableClasspathSearch", this.disableClasspathSearch);
        this.currentUserProvider = this.createInstance(p, CurrentUserProvider.class, "currentUserProvider", this.currentUserProvider);
        this.databasePlatform = this.createInstance(p, DatabasePlatform.class, "databasePlatform", this.databasePlatform);
        this.encryptKeyManager = this.createInstance(p, EncryptKeyManager.class, "encryptKeyManager", this.encryptKeyManager);
        this.encryptDeployManager = this.createInstance(p, EncryptDeployManager.class, "encryptDeployManager", this.encryptDeployManager);
        this.encryptor = this.createInstance(p, Encryptor.class, "encryptor", this.encryptor);
        this.dbEncrypt = this.createInstance(p, DbEncrypt.class, "dbEncrypt", this.dbEncrypt);
        this.serverCachePlugin = this.createInstance(p, ServerCachePlugin.class, "serverCachePlugin", this.serverCachePlugin);
        this.serverCacheManager = this.createInstance(p, ServerCacheManager.class, "serverCacheManager", this.serverCacheManager);
        if (this.packages != null) {
            String packagesProp = p.get("search.packages", p.get("packages", null));
            this.packages = this.getSearchJarsPackages(packagesProp);
        }
        this.collectQueryStatsByNode = p.getBoolean("collectQueryStatsByNode", this.collectQueryStatsByNode);
        this.collectQueryOrigins = p.getBoolean("collectQueryOrigins", this.collectQueryOrigins);
        this.skipCacheAfterWrite = p.getBoolean("skipCacheAfterWrite", this.skipCacheAfterWrite);
        this.updateAllPropertiesInBatch = p.getBoolean("updateAllPropertiesInBatch", this.updateAllPropertiesInBatch);
        this.updateChangesOnly = p.getBoolean("updateChangesOnly", this.updateChangesOnly);
        boolean defaultDeleteMissingChildren = p.getBoolean("defaultDeleteMissingChildren", this.updatesDeleteMissingChildren);
        this.updatesDeleteMissingChildren = p.getBoolean("updatesDeleteMissingChildren", defaultDeleteMissingChildren);
        if (p.get("batch.mode") != null || p.get("persistBatching") != null) {
            throw new IllegalArgumentException("Property 'batch.mode' or 'persistBatching' is being set but no longer used. Please change to use 'persistBatchMode'");
        }
        this.persistBatch = p.getEnum(PersistBatch.class, "persistBatch", this.persistBatch);
        this.persistBatchOnCascade = p.getEnum(PersistBatch.class, "persistBatchOnCascade", this.persistBatchOnCascade);
        int batchSize = p.getInt("batch.size", this.persistBatchSize);
        this.persistBatchSize = p.getInt("persistBatchSize", batchSize);
        this.persistenceContextScope = PersistenceContextScope.valueOf(p.get("persistenceContextScope", "TRANSACTION"));
        this.changeLogIncludeInserts = p.getBoolean("changeLogIncludeInserts", this.changeLogIncludeInserts);
        this.expressionEqualsWithNullAsNoop = p.getBoolean("expressionEqualsWithNullAsNoop", this.expressionEqualsWithNullAsNoop);
        this.expressionNativeIlike = p.getBoolean("expressionNativeIlike", this.expressionNativeIlike);
        this.dataTimeZone = p.get("dataTimeZone", this.dataTimeZone);
        this.asOfViewSuffix = p.get("asOfViewSuffix", this.asOfViewSuffix);
        this.asOfSysPeriod = p.get("asOfSysPeriod", this.asOfSysPeriod);
        this.historyTableSuffix = p.get("historyTableSuffix", this.historyTableSuffix);
        this.dataSourceJndiName = p.get("dataSourceJndiName", this.dataSourceJndiName);
        this.jdbcFetchSizeFindEach = p.getInt("jdbcFetchSizeFindEach", this.jdbcFetchSizeFindEach);
        this.jdbcFetchSizeFindList = p.getInt("jdbcFetchSizeFindList", this.jdbcFetchSizeFindList);
        this.databaseSequenceBatchSize = p.getInt("databaseSequenceBatchSize", this.databaseSequenceBatchSize);
        this.databaseBooleanTrue = p.get("databaseBooleanTrue", this.databaseBooleanTrue);
        this.databaseBooleanFalse = p.get("databaseBooleanFalse", this.databaseBooleanFalse);
        this.databasePlatformName = p.get("databasePlatformName", this.databasePlatformName);
        this.dbUuid = p.getEnum(DbUuid.class, "dbuuid", this.dbUuid);
        if (p.getBoolean("uuidStoreAsBinary", false)) {
            this.dbUuid = DbUuid.BINARY;
        }
        this.localTimeWithNanos = p.getBoolean("localTimeWithNanos", this.localTimeWithNanos);
        this.jodaLocalTimeMode = p.get("jodaLocalTimeMode", this.jodaLocalTimeMode);
        this.lazyLoadBatchSize = p.getInt("lazyLoadBatchSize", this.lazyLoadBatchSize);
        this.queryBatchSize = p.getInt("queryBatchSize", this.queryBatchSize);
        this.jsonInclude = p.getEnum(JsonConfig.Include.class, "jsonInclude", this.jsonInclude);
        String jsonDateTimeFormat = p.get("jsonDateTime", null);
        this.jsonDateTime = jsonDateTimeFormat != null ? JsonConfig.DateTime.valueOf(jsonDateTimeFormat) : JsonConfig.DateTime.MILLIS;
        this.ddlGenerate = p.getBoolean("ddl.generate", this.ddlGenerate);
        this.ddlRun = p.getBoolean("ddl.run", this.ddlRun);
        this.ddlCreateOnly = p.getBoolean("ddl.createOnly", this.ddlCreateOnly);
        this.ddlInitSql = p.get("ddl.initSql", this.ddlInitSql);
        this.ddlSeedSql = p.get("ddl.seedSql", this.ddlSeedSql);
        this.classes = this.getClasses(p);
    }

    private NamingConvention createNamingConvention(PropertiesWrapper properties, NamingConvention namingConvention) {
        NamingConvention nc = this.createInstance(properties, NamingConvention.class, "namingconvention", null);
        return nc != null ? nc : namingConvention;
    }

    private List<Class<?>> getClasses(PropertiesWrapper properties) {
        String classNames = properties.get("classes", null);
        if (classNames == null) {
            return this.classes;
        }
        ArrayList classes = new ArrayList();
        String[] split = classNames.split("[ ,;]");
        for (int i = 0; i < split.length; ++i) {
            String cn = split[i].trim();
            if (cn.isEmpty() || "class".equalsIgnoreCase(cn)) continue;
            try {
                classes.add(Class.forName(cn));
                continue;
            }
            catch (ClassNotFoundException e) {
                String msg = "Error registering class [" + cn + "] from [" + classNames + "]";
                throw new RuntimeException(msg, e);
            }
        }
        return classes;
    }

    private List<String> getSearchJarsPackages(String searchPackages) {
        ArrayList<String> hitList = new ArrayList<String>();
        if (searchPackages != null) {
            String[] entries = searchPackages.split("[ ,;]");
            for (int i = 0; i < entries.length; ++i) {
                hitList.add(entries[i].trim());
            }
        }
        return hitList;
    }

    public PersistBatch appliedPersistBatchOnCascade() {
        if (this.persistBatchOnCascade == PersistBatch.INHERIT) {
            return this.databasePlatform.getPersistBatchOnCascade();
        }
        return this.persistBatchOnCascade;
    }

    public Object getObjectMapper() {
        return this.objectMapper;
    }

    public void setObjectMapper(Object objectMapper) {
        this.objectMapper = objectMapper;
    }

    public boolean isExpressionEqualsWithNullAsNoop() {
        return this.expressionEqualsWithNullAsNoop;
    }

    public void setExpressionEqualsWithNullAsNoop(boolean expressionEqualsWithNullAsNoop) {
        this.expressionEqualsWithNullAsNoop = expressionEqualsWithNullAsNoop;
    }

    public boolean isExpressionNativeIlike() {
        return this.expressionNativeIlike;
    }

    public void setExpressionNativeIlike(boolean expressionNativeIlike) {
        this.expressionNativeIlike = expressionNativeIlike;
    }

    public boolean isDisableL2Cache() {
        return this.disableL2Cache;
    }

    public void setDisableL2Cache(boolean disableL2Cache) {
        this.disableL2Cache = disableL2Cache;
    }

    public static enum DbUuid {
        AUTO_VARCHAR(true, false),
        AUTO_BINARY(true, true),
        VARCHAR(false, false),
        BINARY(false, true);

        boolean nativeType;
        boolean binary;

        private DbUuid(boolean nativeType, boolean binary) {
            this.nativeType = nativeType;
            this.binary = binary;
        }

        public boolean useNativeType() {
            return this.nativeType;
        }

        public boolean useBinary() {
            return this.binary;
        }
    }
}

