/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.common;

import com.avaje.ebean.bean.BeanCollection;
import com.avaje.ebean.bean.BeanCollectionLoader;
import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebean.common.AbstractBeanCollection;
import com.avaje.ebean.common.ModifyCollection;
import com.avaje.ebean.common.ModifySet;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public final class BeanMap<K, E>
extends AbstractBeanCollection<E>
implements Map<K, E> {
    private static final long serialVersionUID = 1L;
    private Map<K, E> map;

    public BeanMap(Map<K, E> map) {
        this.map = map;
    }

    public BeanMap() {
        this(new LinkedHashMap());
    }

    public BeanMap(BeanCollectionLoader ebeanServer, EntityBean ownerBean, String propertyName) {
        super(ebeanServer, ownerBean, propertyName);
    }

    @Override
    public void reset(EntityBean ownerBean, String propertyName) {
        this.ownerBean = ownerBean;
        this.propertyName = propertyName;
        this.map = null;
    }

    @Override
    public boolean isSkipSave() {
        return this.map == null || this.map.isEmpty() && !this.holdsModifications();
    }

    @Override
    public void loadFrom(BeanCollection<?> other) {
        BeanMap otherMap = (BeanMap)other;
        this.internalPutNull();
        this.map.putAll(otherMap.getActualMap());
    }

    public void internalPutNull() {
        if (this.map == null) {
            this.map = new LinkedHashMap<K, E>();
        }
    }

    public void internalPut(Object key, Object bean) {
        if (this.map == null) {
            this.map = new LinkedHashMap<K, E>();
        }
        if (key != null) {
            this.map.put(key, bean);
        }
    }

    public void internalPutWithCheck(Object key, Object bean) {
        if (this.map == null || !this.map.containsKey(key)) {
            this.internalPut(key, bean);
        }
    }

    @Override
    public void internalAddWithCheck(Object bean) {
        throw new RuntimeException("Not allowed for map");
    }

    @Override
    public void internalAdd(Object bean) {
        throw new RuntimeException("Not allowed for map");
    }

    @Override
    public boolean isPopulated() {
        return this.map != null;
    }

    @Override
    public boolean isReference() {
        return this.map == null;
    }

    @Override
    public boolean checkEmptyLazyLoad() {
        if (this.map == null) {
            this.map = new LinkedHashMap<K, E>();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initClear() {
        BeanMap beanMap = this;
        synchronized (beanMap) {
            if (this.map == null) {
                if (this.modifyListening) {
                    this.lazyLoadCollection(true);
                } else {
                    this.map = new LinkedHashMap<K, E>();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        BeanMap beanMap = this;
        synchronized (beanMap) {
            if (this.map == null) {
                this.lazyLoadCollection(false);
            }
        }
    }

    public void setActualMap(Map<?, ?> map) {
        this.map = map;
    }

    public Map<K, E> getActualMap() {
        return this.map;
    }

    @Override
    public Collection<E> getActualDetails() {
        return this.map.values();
    }

    @Override
    public Collection<?> getActualEntries() {
        return this.map.entrySet();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(50);
        sb.append("BeanMap ");
        if (this.isReadOnly()) {
            sb.append("readOnly ");
        }
        if (this.map == null) {
            sb.append("deferred ");
        } else {
            sb.append("size[").append(this.map.size()).append("]");
            sb.append(" map").append(this.map);
        }
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        this.init();
        return this.map.equals(obj);
    }

    @Override
    public int hashCode() {
        this.init();
        return this.map.hashCode();
    }

    @Override
    public void clear() {
        this.checkReadOnly();
        this.initClear();
        if (this.modifyRemoveListening) {
            for (E bean : this.map.values()) {
                this.modifyRemoval(bean);
            }
        }
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        this.init();
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        this.init();
        return this.map.containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, E>> entrySet() {
        this.init();
        if (this.isReadOnly()) {
            return Collections.unmodifiableSet(this.map.entrySet());
        }
        if (this.modifyListening) {
            Set<Map.Entry<K, E>> s = this.map.entrySet();
            return new ModifySet<Map.Entry<K, E>>(this, s);
        }
        return this.map.entrySet();
    }

    @Override
    public E get(Object key) {
        this.init();
        return this.map.get(key);
    }

    @Override
    public boolean isEmpty() {
        this.init();
        return this.map.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        this.init();
        if (this.isReadOnly()) {
            return Collections.unmodifiableSet(this.map.keySet());
        }
        return this.map.keySet();
    }

    @Override
    public E put(K key, E value) {
        E oldBean;
        this.checkReadOnly();
        this.init();
        if (this.modifyListening && value != (oldBean = this.map.put(key, value))) {
            this.modifyAddition(value);
            this.modifyRemoval(oldBean);
        }
        return this.map.put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends E> puts) {
        this.checkReadOnly();
        this.init();
        if (this.modifyListening) {
            for (Map.Entry<K, E> entry : puts.entrySet()) {
                E oldBean = this.map.put(entry.getKey(), entry.getValue());
                if (entry.getValue() == oldBean) continue;
                this.modifyAddition(entry.getValue());
                this.modifyRemoval(oldBean);
            }
        }
        this.map.putAll(puts);
    }

    @Override
    public void addBean(E bean) {
        throw new IllegalStateException("Method not allowed on Map. Please use List instead.");
    }

    @Override
    public void removeBean(E bean) {
        throw new IllegalStateException("Method not allowed on Map. Please use List instead.");
    }

    @Override
    public E remove(Object key) {
        this.checkReadOnly();
        this.init();
        if (this.modifyRemoveListening) {
            E o = this.map.remove(key);
            this.modifyRemoval(o);
            return o;
        }
        return this.map.remove(key);
    }

    @Override
    public int size() {
        this.init();
        return this.map.size();
    }

    @Override
    public Collection<E> values() {
        this.init();
        if (this.isReadOnly()) {
            return Collections.unmodifiableCollection(this.map.values());
        }
        if (this.modifyListening) {
            Collection<E> c = this.map.values();
            return new ModifyCollection<E>(this, c);
        }
        return this.map.values();
    }
}

