/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean;

import com.avaje.ebean.Query;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class OrderBy<T>
implements Serializable {
    private static final long serialVersionUID = 9157089257745730539L;
    private transient Query<T> query;
    private final List<Property> list;

    public OrderBy() {
        this.list = new ArrayList<Property>(3);
    }

    private OrderBy(List<Property> list) {
        this.list = list;
    }

    public OrderBy(String orderByClause) {
        this(null, orderByClause);
    }

    public OrderBy(Query<T> query, String orderByClause) {
        this.query = query;
        this.list = new ArrayList<Property>(3);
        this.parse(orderByClause);
    }

    public void reverse() {
        for (int i = 0; i < this.list.size(); ++i) {
            this.list.get(i).reverse();
        }
    }

    public Query<T> asc(String propertyName) {
        this.list.add(new Property(propertyName, true));
        return this.query;
    }

    public Query<T> desc(String propertyName) {
        this.list.add(new Property(propertyName, false));
        return this.query;
    }

    public boolean containsProperty(String propertyName) {
        for (int i = 0; i < this.list.size(); ++i) {
            if (!propertyName.equals(this.list.get(i).getProperty())) continue;
            return true;
        }
        return false;
    }

    public OrderBy<T> copyWithTrim(String path) {
        ArrayList<Property> newList = new ArrayList<Property>(this.list.size());
        for (int i = 0; i < this.list.size(); ++i) {
            newList.add(this.list.get(i).copyWithTrim(path));
        }
        return new OrderBy<T>(newList);
    }

    public List<Property> getProperties() {
        return this.list;
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public Query<T> getQuery() {
        return this.query;
    }

    public void setQuery(Query<T> query) {
        this.query = query;
    }

    public OrderBy<T> copy() {
        OrderBy<T> copy = new OrderBy<T>();
        for (int i = 0; i < this.list.size(); ++i) {
            copy.add(this.list.get(i).copy());
        }
        return copy;
    }

    public void add(String rawExpression) {
        this.parse(rawExpression);
    }

    public void add(Property p) {
        this.list.add(p);
    }

    public String toString() {
        return this.list.toString();
    }

    public String toStringFormat() {
        if (this.list.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.list.size(); ++i) {
            Property property = this.list.get(i);
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(property.toStringFormat());
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OrderBy)) {
            return false;
        }
        OrderBy e = (OrderBy)obj;
        return e.list.equals(this.list);
    }

    public int hashCode() {
        return this.list.hashCode();
    }

    public OrderBy<T> clear() {
        this.list.clear();
        return this;
    }

    private void parse(String orderByClause) {
        if (orderByClause == null) {
            return;
        }
        String[] chunks = orderByClause.split(",");
        for (int i = 0; i < chunks.length; ++i) {
            String[] pairs = chunks[i].split(" ");
            Property p = this.parseProperty(pairs);
            if (p == null) continue;
            this.list.add(p);
        }
    }

    private Property parseProperty(String[] pairs) {
        boolean asc;
        if (pairs.length == 0) {
            return null;
        }
        ArrayList<String> wordList = new ArrayList<String>(pairs.length);
        for (int i = 0; i < pairs.length; ++i) {
            if (this.isEmptyString(pairs[i])) continue;
            wordList.add(pairs[i]);
        }
        if (wordList.isEmpty()) {
            return null;
        }
        if (wordList.size() == 1) {
            return new Property((String)wordList.get(0), true);
        }
        if (wordList.size() == 2) {
            asc = this.isAscending((String)wordList.get(1));
            return new Property((String)wordList.get(0), asc);
        }
        if (wordList.size() == 4) {
            asc = this.isAscending((String)wordList.get(1));
            return new Property((String)wordList.get(0), asc, (String)wordList.get(2), (String)wordList.get(3));
        }
        String m = "Expecting a 1, 2 or 4 words in [" + Arrays.toString(pairs) + "] but got " + wordList;
        throw new RuntimeException(m);
    }

    private boolean isAscending(String s) {
        if ((s = s.toLowerCase()).startsWith("asc")) {
            return true;
        }
        if (s.startsWith("desc")) {
            return false;
        }
        String m = "Expecting [" + s + "] to be asc or desc?";
        throw new RuntimeException(m);
    }

    private boolean isEmptyString(String s) {
        return s == null || s.isEmpty();
    }

    public static final class Property
    implements Serializable {
        private static final long serialVersionUID = 1546009780322478077L;
        private String property;
        private boolean ascending;
        private String nulls;
        private String highLow;

        public Property(String property, boolean ascending) {
            this.property = property;
            this.ascending = ascending;
        }

        public Property(String property, boolean ascending, String nulls, String highLow) {
            this.property = property;
            this.ascending = ascending;
            this.nulls = nulls;
            this.highLow = highLow;
        }

        public Property copyWithTrim(String path) {
            return new Property(this.property.substring(path.length() + 1), this.ascending, this.nulls, this.highLow);
        }

        public int hashCode() {
            int hc = this.property.hashCode();
            hc = hc * 31 + (this.ascending ? 0 : 1);
            hc = hc * 31 + (this.nulls == null ? 0 : this.nulls.hashCode());
            hc = hc * 31 + (this.highLow == null ? 0 : this.highLow.hashCode());
            return hc;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Property)) {
                return false;
            }
            Property e = (Property)obj;
            if (this.ascending != e.ascending) {
                return false;
            }
            if (!this.property.equals(e.property)) {
                return false;
            }
            if (this.nulls != null ? !this.nulls.equals(e.nulls) : e.nulls != null) {
                return false;
            }
            return this.highLow != null ? this.highLow.equals(e.highLow) : e.highLow == null;
        }

        public String toString() {
            return this.toStringFormat();
        }

        public String toStringFormat() {
            if (this.nulls == null) {
                if (this.ascending) {
                    return this.property;
                }
                return this.property + " desc";
            }
            StringBuilder sb = new StringBuilder();
            sb.append(this.property);
            if (!this.ascending) {
                sb.append(" ").append("desc");
            }
            sb.append(" ").append(this.nulls).append(" ").append(this.highLow);
            return sb.toString();
        }

        public void reverse() {
            this.ascending = !this.ascending;
        }

        public void trim(String pathPrefix) {
            this.property = this.property.substring(pathPrefix.length() + 1);
        }

        public Property copy() {
            return new Property(this.property, this.ascending, this.nulls, this.highLow);
        }

        public String getProperty() {
            return this.property;
        }

        public void setProperty(String property) {
            this.property = property;
        }

        public boolean isAscending() {
            return this.ascending;
        }

        public void setAscending(boolean ascending) {
            this.ascending = ascending;
        }
    }
}

