/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean;

import com.avaje.ebean.Ebean;
import com.avaje.ebean.EbeanServer;
import com.avaje.ebean.Query;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class Finder<I, T> {
    private final Class<T> type;
    private final String serverName;

    public Finder(Class<T> type) {
        this.type = type;
        this.serverName = null;
    }

    public Finder(Class<T> type, String serverName) {
        this.type = type;
        this.serverName = serverName;
    }

    public EbeanServer db() {
        return Ebean.getServer(this.serverName);
    }

    public EbeanServer db(String server) {
        return Ebean.getServer(server);
    }

    public T ref(I id) {
        return this.db().getReference(this.type, id);
    }

    @Nullable
    public T byId(I id) {
        return this.db().find(this.type, id);
    }

    public void deleteById(I id) {
        this.db().delete(this.type, id);
    }

    public List<T> all() {
        return this.query().findList();
    }

    public Query<T> query() {
        return this.db().find(this.type);
    }
}

