/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean;

import com.avaje.ebean.RawSql;
import java.util.ArrayList;
import javax.persistence.PersistenceException;

final class DRawSqlColumnsParser {
    private final int end;
    private final String sqlSelect;
    private int pos;
    private int indexPos;

    public static RawSql.ColumnMapping parse(String sqlSelect) {
        return new DRawSqlColumnsParser(sqlSelect).parse();
    }

    private DRawSqlColumnsParser(String sqlSelect) {
        this.sqlSelect = sqlSelect;
        this.end = sqlSelect.length();
    }

    private RawSql.ColumnMapping parse() {
        ArrayList<RawSql.ColumnMapping.Column> columns = new ArrayList<RawSql.ColumnMapping.Column>();
        while (this.pos <= this.end) {
            RawSql.ColumnMapping.Column c = this.nextColumnInfo();
            columns.add(c);
        }
        return new RawSql.ColumnMapping(columns);
    }

    private RawSql.ColumnMapping.Column nextColumnInfo() {
        int i;
        int start = this.pos;
        this.nextComma();
        String colInfo = this.sqlSelect.substring(start, this.pos++);
        colInfo = colInfo.trim();
        String[] split = colInfo.split("\\s(?=[^\\)]*(?:\\(|$))");
        if (split.length > 1) {
            ArrayList<String> tmp = new ArrayList<String>(split.length);
            for (i = 0; i < split.length; ++i) {
                if (split[i].trim().isEmpty()) continue;
                tmp.add(split[i].trim());
            }
            split = tmp.toArray(new String[tmp.size()]);
        }
        if (split.length == 0) {
            throw new PersistenceException("Huh? Not expecting length=0 when parsing column " + colInfo);
        }
        if (split.length == 1) {
            return new RawSql.ColumnMapping.Column(this.indexPos++, split[0], null);
        }
        if (split.length == 2) {
            return new RawSql.ColumnMapping.Column(this.indexPos++, split[0], split[1]);
        }
        if (!split[split.length - 2].equalsIgnoreCase("as")) {
            throw new PersistenceException("Expecting AS keyword as second to last word when parsing column " + colInfo);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(split[0]);
        for (i = 1; i < split.length - 2; ++i) {
            sb.append(" ").append(split[i]);
        }
        return new RawSql.ColumnMapping.Column(this.indexPos++, sb.toString(), split[split.length - 1]);
    }

    private void nextComma() {
        boolean inQuote = false;
        int inbrackets = 0;
        while (this.pos < this.end) {
            char c = this.sqlSelect.charAt(this.pos);
            if (c == '\'') {
                inQuote = !inQuote;
            } else if (c == '(') {
                ++inbrackets;
            } else if (c == ')') {
                --inbrackets;
            } else if (!inQuote && inbrackets == 0 && c == ',') {
                return;
            }
            ++this.pos;
        }
    }
}

