/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.type;

import com.avaje.ebean.text.TextException;
import com.avaje.ebean.text.json.EJson;
import com.avaje.ebeaninternal.server.type.DataBind;
import com.avaje.ebeaninternal.server.type.DataReader;
import com.avaje.ebeaninternal.server.type.ModifyAwareMap;
import com.avaje.ebeaninternal.server.type.ModifyAwareOwner;
import com.avaje.ebeaninternal.server.type.ScalarHelp;
import com.avaje.ebeaninternal.server.type.ScalarTypeBase;
import com.avaje.ebeanservice.docstore.api.mapping.DocPropertyType;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;

public class ScalarTypePostgresHstore
extends ScalarTypeBase<Map> {
    public ScalarTypePostgresHstore() {
        super(Map.class, false, 5000);
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public boolean isDirty(Object value) {
        return !(value instanceof ModifyAwareOwner) || ((ModifyAwareOwner)value).isMarkedDirty();
    }

    @Override
    public Map read(DataReader dataReader) throws SQLException {
        Object value = dataReader.getObject();
        if (value == null) {
            return null;
        }
        if (!(value instanceof Map)) {
            throw new RuntimeException("Expecting Hstore to return as Map but got type " + value.getClass());
        }
        return new ModifyAwareMap((Map)value);
    }

    @Override
    public void bind(DataBind b, Map value) throws SQLException {
        b.setObject(value);
    }

    @Override
    public Object toJdbcType(Object value) {
        return value;
    }

    @Override
    public Map toBeanType(Object value) {
        return (Map)value;
    }

    @Override
    public String formatValue(Map v) {
        try {
            return EJson.write(v);
        }
        catch (IOException e) {
            throw new TextException(e);
        }
    }

    @Override
    public Map parse(String value) {
        try {
            return EJson.parseObject(value);
        }
        catch (IOException e) {
            throw new TextException(e);
        }
    }

    @Override
    public Map convertFromMillis(long dateTime) {
        throw new RuntimeException("Should never be called");
    }

    @Override
    public boolean isDateTimeCapable() {
        return false;
    }

    @Override
    public Map readData(DataInput dataInput) throws IOException {
        if (!dataInput.readBoolean()) {
            return null;
        }
        return this.parse(dataInput.readUTF());
    }

    @Override
    public void writeData(DataOutput dataOutput, Map map) throws IOException {
        if (map == null) {
            dataOutput.writeBoolean(false);
        } else {
            ScalarHelp.writeUTF(dataOutput, this.format(map));
        }
    }

    @Override
    public void jsonWrite(JsonGenerator writer, Map value) throws IOException {
        EJson.write((Object)value, writer);
    }

    @Override
    public Map jsonRead(JsonParser parser) throws IOException {
        return EJson.parseObject(parser, parser.getCurrentToken());
    }

    @Override
    public DocPropertyType getDocType() {
        return DocPropertyType.OBJECT;
    }
}

