/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.type;

import com.avaje.ebean.text.TextException;
import com.avaje.ebeaninternal.server.type.DataBind;
import com.avaje.ebeaninternal.server.type.DataReader;
import com.avaje.ebeaninternal.server.type.ScalarHelp;
import com.avaje.ebeaninternal.server.type.ScalarTypeBase;
import com.avaje.ebeaninternal.server.type.ScalarTypeEnum;
import com.avaje.ebeanservice.docstore.api.mapping.DocPropertyType;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;
import java.util.EnumSet;

public class ScalarTypeEnumStandard {

    public static abstract class EnumBase
    extends ScalarTypeBase {
        protected final Class enumType;

        public EnumBase(Class<?> type, boolean jdbcNative, int jdbcType) {
            super(type, jdbcNative, jdbcType);
            this.enumType = type;
        }

        @Override
        public String format(Object value) {
            return ((Enum)value).name();
        }

        @Override
        public String formatValue(Object value) {
            return ((Enum)value).name();
        }

        @Override
        public Object parse(String value) {
            return Enum.valueOf(this.enumType, value);
        }

        @Override
        public Object convertFromMillis(long systemTimeMillis) {
            throw new TextException("Not Supported");
        }

        @Override
        public boolean isDateTimeCapable() {
            return false;
        }

        @Override
        public Object jsonRead(JsonParser parser) throws IOException {
            return this.parse(parser.getValueAsString());
        }

        @Override
        public void jsonWrite(JsonGenerator writer, Object value) throws IOException {
            writer.writeString(this.formatValue(value));
        }

        @Override
        public DocPropertyType getDocType() {
            return DocPropertyType.ENUM;
        }

        @Override
        public Object readData(DataInput dataInput) throws IOException {
            if (!dataInput.readBoolean()) {
                return null;
            }
            return this.parse(dataInput.readUTF());
        }

        @Override
        public void writeData(DataOutput dataOutput, Object value) throws IOException {
            if (value == null) {
                dataOutput.writeBoolean(false);
            } else {
                ScalarHelp.writeUTF(dataOutput, this.format(value));
            }
        }
    }

    public static class OrdinalEnum
    extends EnumBase
    implements ScalarTypeEnum {
        private final Object[] enumArray;

        public OrdinalEnum(Class enumType) {
            super((Class<?>)enumType, false, 4);
            this.enumArray = EnumSet.allOf(enumType).toArray();
        }

        @Override
        public String getConstraintInValues() {
            StringBuilder sb = new StringBuilder();
            sb.append("(");
            for (int i = 0; i < this.enumArray.length; ++i) {
                Enum e = (Enum)this.enumArray[i];
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(e.ordinal());
            }
            sb.append(")");
            return sb.toString();
        }

        @Override
        public void bind(DataBind b, Object value) throws SQLException {
            if (value == null) {
                b.setNull(4);
            } else {
                b.setInt(((Enum)value).ordinal());
            }
        }

        @Override
        public Object read(DataReader dataReader) throws SQLException {
            Integer ordinal = dataReader.getInt();
            if (ordinal == null) {
                return null;
            }
            if (ordinal < 0 || ordinal >= this.enumArray.length) {
                String m = "Unexpected ordinal [" + ordinal + "] out of range [" + this.enumArray.length + "]";
                throw new IllegalStateException(m);
            }
            return this.enumArray[ordinal];
        }

        @Override
        public Object toJdbcType(Object beanValue) {
            if (beanValue == null) {
                return null;
            }
            return ((Enum)beanValue).ordinal();
        }

        @Override
        public Object toBeanType(Object dbValue) {
            if (dbValue == null || dbValue instanceof Enum) {
                return dbValue;
            }
            int ordinal = (Integer)dbValue;
            if (ordinal < 0 || ordinal >= this.enumArray.length) {
                String m = "Unexpected ordinal [" + ordinal + "] out of range [" + this.enumArray.length + "]";
                throw new IllegalStateException(m);
            }
            return this.enumArray[ordinal];
        }
    }

    public static class StringEnum
    extends EnumBase
    implements ScalarTypeEnum {
        private final int length;

        public StringEnum(Class enumType) {
            super((Class<?>)enumType, false, 12);
            this.length = this.maxValueLength(enumType);
        }

        @Override
        public String getConstraintInValues() {
            StringBuilder sb = new StringBuilder();
            sb.append("(");
            T[] ea = this.enumType.getEnumConstants();
            for (int i = 0; i < ea.length; ++i) {
                Enum e = (Enum)ea[i];
                if (i > 0) {
                    sb.append(",");
                }
                sb.append("'").append(e.name()).append("'");
            }
            sb.append(")");
            return sb.toString();
        }

        private int maxValueLength(Class<?> enumType) {
            int maxLen = 0;
            ?[] ea = enumType.getEnumConstants();
            for (int i = 0; i < ea.length; ++i) {
                Enum e = (Enum)ea[i];
                maxLen = Math.max(maxLen, e.name().length());
            }
            return maxLen;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public void bind(DataBind b, Object value) throws SQLException {
            if (value == null) {
                b.setNull(12);
            } else {
                b.setString(this.format(value));
            }
        }

        @Override
        public Object read(DataReader dataReader) throws SQLException {
            String string = dataReader.getString();
            if (string == null) {
                return null;
            }
            return this.parse(string);
        }

        @Override
        public Object toJdbcType(Object beanValue) {
            if (beanValue == null) {
                return null;
            }
            return this.format(beanValue);
        }

        @Override
        public Object toBeanType(Object dbValue) {
            if (dbValue == null || dbValue instanceof Enum) {
                return dbValue;
            }
            return Enum.valueOf(this.enumType, (String)dbValue);
        }
    }
}

