/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.type;

import com.avaje.ebeaninternal.server.type.DataBind;
import com.avaje.ebeaninternal.server.type.DataReader;
import com.avaje.ebeaninternal.server.type.ScalarTypeBase;
import com.avaje.ebeanservice.docstore.api.mapping.DocPropertyType;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.Date;
import java.sql.SQLException;

public abstract class ScalarTypeBaseDate<T>
extends ScalarTypeBase<T> {
    public ScalarTypeBaseDate(Class<T> type, boolean jdbcNative, int jdbcType) {
        super(type, jdbcNative, jdbcType);
    }

    public abstract long convertToMillis(T var1);

    public abstract Date convertToDate(T var1);

    public abstract T convertFromDate(Date var1);

    @Override
    public void bind(DataBind b, T value) throws SQLException {
        if (value == null) {
            b.setNull(91);
        } else {
            b.setDate(this.convertToDate(value));
        }
    }

    @Override
    public T read(DataReader dataReader) throws SQLException {
        Date ts = dataReader.getDate();
        return ts == null ? null : (T)this.convertFromDate(ts);
    }

    @Override
    public String formatValue(T t) {
        Date date = this.convertToDate(t);
        return date.toString();
    }

    @Override
    public T parse(String value) {
        Date date = Date.valueOf(value);
        return this.convertFromDate(date);
    }

    @Override
    public T convertFromMillis(long systemTimeMillis) {
        Date ts = new Date(systemTimeMillis);
        return this.convertFromDate(ts);
    }

    @Override
    public boolean isDateTimeCapable() {
        return true;
    }

    @Override
    public T jsonRead(JsonParser parser) throws IOException {
        if (JsonToken.VALUE_NUMBER_INT == parser.getCurrentToken()) {
            return this.convertFromMillis(parser.getLongValue());
        }
        return this.convertFromDate(Date.valueOf(parser.getText()));
    }

    @Override
    public void jsonWrite(JsonGenerator writer, T value) throws IOException {
        writer.writeNumber(this.convertToMillis(value));
    }

    @Override
    public DocPropertyType getDocType() {
        return DocPropertyType.DATE;
    }

    @Override
    public T readData(DataInput dataInput) throws IOException {
        if (!dataInput.readBoolean()) {
            return null;
        }
        long val = dataInput.readLong();
        Date date = new Date(val);
        return this.convertFromDate(date);
    }

    @Override
    public void writeData(DataOutput dataOutput, T value) throws IOException {
        if (value == null) {
            dataOutput.writeBoolean(false);
        } else {
            dataOutput.writeBoolean(true);
            Date date = this.convertToDate(value);
            dataOutput.writeLong(date.getTime());
        }
    }
}

