/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.type;

import com.avaje.ebean.config.CompoundType;
import com.avaje.ebean.config.CompoundTypeProperty;
import com.avaje.ebeaninternal.server.text.json.WriteJson;
import com.avaje.ebeaninternal.server.type.CtCompoundTypeScalarList;
import com.avaje.ebeaninternal.server.type.DataBind;
import com.avaje.ebeaninternal.server.type.DataReader;
import com.avaje.ebeaninternal.server.type.ScalarDataReader;
import com.avaje.ebeaninternal.server.type.ScalarType;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;

public final class CtCompoundType<V>
implements ScalarDataReader<V> {
    private final Class<V> cvoClass;
    private final CompoundType<V> cvoType;
    private final ScalarDataReader<Object>[] propReaders;
    private final CompoundTypeProperty<V, ?>[] properties;

    public CtCompoundType(Class<V> cvoClass, CompoundType<V> cvoType, ScalarDataReader<Object>[] propReaders) {
        this.cvoClass = cvoClass;
        this.cvoType = cvoType;
        this.properties = cvoType.getProperties();
        this.propReaders = propReaders;
    }

    public String toString() {
        return this.cvoClass.toString();
    }

    public Class<V> getCompoundTypeClass() {
        return this.cvoClass;
    }

    public V create(Object[] propertyValues) {
        return this.cvoType.create(propertyValues);
    }

    public V create(Map<String, Object> valueMap) {
        if (valueMap.size() != this.properties.length) {
            return null;
        }
        Object[] propertyValues = new Object[this.properties.length];
        for (int i = 0; i < this.properties.length; ++i) {
            propertyValues[i] = valueMap.get(this.properties[i].getName());
            if (propertyValues[i] != null) continue;
            String m = "Null value for " + this.properties[i].getName() + " in map " + valueMap;
            throw new RuntimeException(m);
        }
        return this.create(propertyValues);
    }

    @Override
    public V read(DataReader source) throws SQLException {
        boolean nullValue = false;
        Object[] values = new Object[this.propReaders.length];
        for (int i = 0; i < this.propReaders.length; ++i) {
            Object o;
            values[i] = o = this.propReaders[i].read(source);
            if (o != null) continue;
            nullValue = true;
        }
        if (nullValue) {
            return null;
        }
        return this.create(values);
    }

    @Override
    public void loadIgnore(DataReader dataReader) {
        for (int i = 0; i < this.propReaders.length; ++i) {
            this.propReaders[i].loadIgnore(dataReader);
        }
    }

    @Override
    public void bind(DataBind b, V value) throws SQLException {
        CompoundTypeProperty<V, ?>[] props = this.cvoType.getProperties();
        for (int i = 0; i < props.length; ++i) {
            Object o = props[i].getValue(value);
            this.propReaders[i].bind(b, o);
        }
    }

    @Override
    public void accumulateScalarTypes(String parent, CtCompoundTypeScalarList list) {
        CompoundTypeProperty<V, ?>[] props = this.cvoType.getProperties();
        for (int i = 0; i < this.propReaders.length; ++i) {
            String propName = this.getFullPropName(parent, props[i].getName());
            list.addCompoundProperty(propName, this, props[i]);
            this.propReaders[i].accumulateScalarTypes(propName, list);
        }
    }

    private String getFullPropName(String parent, String propName) {
        if (parent == null) {
            return propName;
        }
        return parent + "." + propName;
    }

    public Object jsonConvert(Map<String, Object> map) {
        return this.readJsonElementObject(map);
    }

    private Object readJsonElementObject(Map<String, Object> jsonObject) {
        boolean nullValue = false;
        Object[] values = new Object[this.propReaders.length];
        for (int i = 0; i < this.propReaders.length; ++i) {
            String propName = this.properties[i].getName();
            Object jsonElement = jsonObject.get(propName);
            values[i] = this.propReaders[i] instanceof CtCompoundType ? ((CtCompoundType)this.propReaders[i]).readJsonElementObject((Map)jsonElement) : ((ScalarType)this.propReaders[i]).parse(jsonElement.toString());
            if (values[i] != null) continue;
            nullValue = true;
        }
        if (nullValue) {
            return null;
        }
        return this.create(values);
    }

    public void jsonWrite(WriteJson ctx, Object valueObject, String propertyName) throws IOException {
        ctx.beginAssocOne(propertyName, valueObject);
        this.jsonWriteProps(ctx, valueObject);
        ctx.endAssocOne();
    }

    private void jsonWriteProps(WriteJson ctx, Object valueObject) throws IOException {
        ctx.gen().writeStartObject();
        for (int i = 0; i < this.properties.length; ++i) {
            String propName = this.properties[i].getName();
            Object value = this.properties[i].getValue(valueObject);
            if (this.propReaders[i] instanceof CtCompoundType) {
                ctx.writeFieldName(propName);
                ((CtCompoundType)this.propReaders[i]).jsonWrite(ctx, value, propName);
                continue;
            }
            ctx.writeFieldName(propName);
            ((ScalarType)this.propReaders[i]).jsonWrite(ctx.gen(), value);
        }
        ctx.gen().writeEndObject();
    }
}

