/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.transaction;

import com.avaje.ebean.annotation.DocStoreMode;
import com.avaje.ebeaninternal.api.SpiTransaction;
import com.avaje.ebeaninternal.api.TransactionEvent;
import com.avaje.ebeaninternal.api.TransactionEventTable;
import com.avaje.ebeaninternal.server.cluster.ClusterManager;
import com.avaje.ebeaninternal.server.core.PersistRequestBean;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptorManager;
import com.avaje.ebeaninternal.server.transaction.BeanPersistIdMap;
import com.avaje.ebeaninternal.server.transaction.BeanPersistIds;
import com.avaje.ebeaninternal.server.transaction.BulkEventListenerMap;
import com.avaje.ebeaninternal.server.transaction.DeleteByIdMap;
import com.avaje.ebeaninternal.server.transaction.RemoteTransactionEvent;
import com.avaje.ebeaninternal.server.transaction.TransactionManager;
import com.avaje.ebeanservice.docstore.api.DocStoreUpdates;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PostCommitProcessing {
    private static final Logger logger = LoggerFactory.getLogger(PostCommitProcessing.class);
    private final ClusterManager clusterManager;
    private final TransactionEvent event;
    private final String serverName;
    private final TransactionManager manager;
    private final List<PersistRequestBean<?>> persistBeanRequests;
    private final BeanPersistIdMap beanPersistIdMap;
    private final RemoteTransactionEvent remoteTransactionEvent;
    private final DeleteByIdMap deleteByIdMap;
    private final DocStoreMode txnDocStoreMode;
    private final int txnDocStoreBatchSize;

    public PostCommitProcessing(ClusterManager clusterManager, TransactionManager manager, TransactionEvent event) {
        this.clusterManager = clusterManager;
        this.manager = manager;
        this.serverName = manager.getServerName();
        this.txnDocStoreMode = DocStoreMode.IGNORE;
        this.txnDocStoreBatchSize = 0;
        this.event = event;
        this.deleteByIdMap = event.getDeleteByIdMap();
        this.persistBeanRequests = event.getPersistRequestBeans();
        this.beanPersistIdMap = this.createBeanPersistIdMap();
        this.remoteTransactionEvent = this.createRemoteTransactionEvent();
    }

    public PostCommitProcessing(ClusterManager clusterManager, TransactionManager manager, SpiTransaction transaction) {
        this.clusterManager = clusterManager;
        this.manager = manager;
        this.serverName = manager.getServerName();
        this.txnDocStoreMode = transaction.getDocStoreMode();
        this.txnDocStoreBatchSize = transaction.getDocStoreBatchSize();
        this.event = transaction.getEvent();
        this.deleteByIdMap = this.event.getDeleteByIdMap();
        this.persistBeanRequests = this.event.getPersistRequestBeans();
        this.beanPersistIdMap = this.createBeanPersistIdMap();
        this.remoteTransactionEvent = this.createRemoteTransactionEvent();
    }

    void notifyLocalCache() {
        this.processTableEvents(this.event.getEventTables());
        this.event.notifyCache();
    }

    private void processTableEvents(TransactionEventTable tableEvents) {
        if (tableEvents != null && !tableEvents.isEmpty()) {
            BeanDescriptorManager dm = this.manager.getBeanDescriptorManager();
            for (TransactionEventTable.TableIUD tableIUD : tableEvents.values()) {
                dm.cacheNotify(tableIUD);
            }
        }
    }

    private void processDocStoreUpdates() {
        if (this.isDocStoreUpdate()) {
            DocStoreUpdates docStoreUpdates = new DocStoreUpdates();
            this.event.addDocStoreUpdates(docStoreUpdates);
            if (this.deleteByIdMap != null) {
                this.deleteByIdMap.addDocStoreUpdates(docStoreUpdates, this.txnDocStoreMode);
            }
            if (!docStoreUpdates.isEmpty()) {
                this.manager.processDocStoreUpdates(docStoreUpdates, this.txnDocStoreBatchSize);
            }
        }
    }

    private boolean isDocStoreUpdate() {
        return this.manager.isDocStoreActive() && (this.txnDocStoreMode == null || this.txnDocStoreMode != DocStoreMode.IGNORE);
    }

    private void notifyCluster() {
        if (this.remoteTransactionEvent != null && !this.remoteTransactionEvent.isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Cluster Send: {}", (Object)this.remoteTransactionEvent);
            }
            this.clusterManager.broadcast(this.remoteTransactionEvent);
        }
    }

    Runnable backgroundNotify() {
        return new Runnable(){

            @Override
            public void run() {
                PostCommitProcessing.this.localPersistListenersNotify();
                PostCommitProcessing.this.notifyCluster();
                PostCommitProcessing.this.processDocStoreUpdates();
            }
        };
    }

    private void localPersistListenersNotify() {
        TransactionEventTable eventTables;
        if (this.persistBeanRequests != null) {
            for (int i = 0; i < this.persistBeanRequests.size(); ++i) {
                this.persistBeanRequests.get(i).notifyLocalPersistListener();
            }
        }
        if ((eventTables = this.event.getEventTables()) != null && !eventTables.isEmpty()) {
            BulkEventListenerMap map = this.manager.getBulkEventListenerMap();
            for (TransactionEventTable.TableIUD tableIUD : eventTables.values()) {
                map.process(tableIUD);
            }
        }
    }

    private BeanPersistIdMap createBeanPersistIdMap() {
        if (this.persistBeanRequests == null) {
            return null;
        }
        BeanPersistIdMap m = new BeanPersistIdMap();
        for (int i = 0; i < this.persistBeanRequests.size(); ++i) {
            this.persistBeanRequests.get(i).addToPersistMap(m);
        }
        return m;
    }

    private RemoteTransactionEvent createRemoteTransactionEvent() {
        TransactionEventTable eventTables;
        if (!this.clusterManager.isClustering()) {
            return null;
        }
        RemoteTransactionEvent remoteTransactionEvent = new RemoteTransactionEvent(this.serverName);
        if (this.beanPersistIdMap != null) {
            for (BeanPersistIds beanPersist : this.beanPersistIdMap.values()) {
                remoteTransactionEvent.addBeanPersistIds(beanPersist);
            }
        }
        if (this.deleteByIdMap != null) {
            remoteTransactionEvent.setDeleteByIdMap(this.deleteByIdMap);
        }
        if ((eventTables = this.event.getEventTables()) != null && !eventTables.isEmpty()) {
            for (TransactionEventTable.TableIUD tableIUD : eventTables.values()) {
                remoteTransactionEvent.addTableIUD(tableIUD);
            }
        }
        return remoteTransactionEvent;
    }
}

