/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.transaction;

import com.avaje.ebean.TransactionCallback;
import com.avaje.ebean.annotation.DocStoreMode;
import com.avaje.ebean.bean.PersistenceContext;
import com.avaje.ebean.config.PersistBatch;
import com.avaje.ebean.config.dbplatform.DatabasePlatform;
import com.avaje.ebean.event.changelog.BeanChange;
import com.avaje.ebean.event.changelog.ChangeSet;
import com.avaje.ebeaninternal.api.DerivedRelationshipData;
import com.avaje.ebeaninternal.api.SpiTransaction;
import com.avaje.ebeaninternal.api.TransactionEvent;
import com.avaje.ebeaninternal.server.core.PersistRequest;
import com.avaje.ebeaninternal.server.core.PersistRequestBean;
import com.avaje.ebeaninternal.server.lib.util.Str;
import com.avaje.ebeaninternal.server.persist.BatchControl;
import com.avaje.ebeaninternal.server.transaction.DefaultPersistenceContext;
import com.avaje.ebeaninternal.server.transaction.TChangeLogHolder;
import com.avaje.ebeaninternal.server.transaction.TransactionManager;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.PersistenceException;
import javax.persistence.RollbackException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcTransaction
implements SpiTransaction {
    private static final Logger logger = LoggerFactory.getLogger(JdbcTransaction.class);
    private static final Object PLACEHOLDER = new Object();
    private static final String illegalStateMessage = "Transaction is Inactive";
    protected final TransactionManager manager;
    protected final String id;
    protected final boolean explicit;
    protected final DatabasePlatform.OnQueryOnly onQueryOnly;
    protected boolean active;
    protected Connection connection;
    protected BatchControl batchControl;
    protected TransactionEvent event;
    protected PersistenceContext persistenceContext;
    protected boolean persistCascade = true;
    protected boolean queryOnly = true;
    protected boolean localReadOnly;
    protected Boolean updateAllLoadedProperties;
    protected PersistBatch oldBatchMode;
    protected PersistBatch batchMode;
    protected PersistBatch batchOnCascadeMode;
    protected int batchSize = -1;
    protected boolean batchFlushOnQuery = true;
    protected Boolean batchGetGeneratedKeys;
    protected Boolean batchFlushOnMixed;
    protected String logPrefix;
    protected int depth;
    protected boolean autoCommit;
    protected IdentityHashMap<Object, Object> persistingBeans;
    protected HashSet<Integer> deletingBeansHash;
    protected HashMap<String, String> m2mIntersectionSave;
    protected HashMap<Integer, List<DerivedRelationshipData>> derivedRelMap;
    protected Map<String, Object> userObjects;
    protected List<TransactionCallback> callbackList;
    protected boolean batchOnCascadeSet;
    protected TChangeLogHolder changeLogHolder;
    protected DocStoreMode docStoreMode;
    protected int docStoreBatchSize;

    public JdbcTransaction(String id, boolean explicit, Connection connection, TransactionManager manager) {
        try {
            this.active = true;
            this.id = id;
            this.logPrefix = JdbcTransaction.deriveLogPrefix(id);
            this.explicit = explicit;
            this.manager = manager;
            this.connection = connection;
            this.batchMode = manager == null ? PersistBatch.NONE : manager.getPersistBatch();
            this.batchOnCascadeMode = manager == null ? PersistBatch.NONE : manager.getPersistBatchOnCascade();
            this.onQueryOnly = manager == null ? DatabasePlatform.OnQueryOnly.ROLLBACK : manager.getOnQueryOnly();
            this.persistenceContext = new DefaultPersistenceContext();
            this.checkAutoCommit(connection);
        }
        catch (Exception e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    protected void checkAutoCommit(Connection connection) throws SQLException {
        if (connection != null) {
            this.autoCommit = connection.getAutoCommit();
            if (this.autoCommit) {
                connection.setAutoCommit(false);
            }
        }
    }

    private static String deriveLogPrefix(String id) {
        StringBuilder sb = new StringBuilder();
        sb.append("txn[");
        if (id != null) {
            sb.append(id);
        }
        sb.append("] ");
        return sb.toString();
    }

    @Override
    public String getLogPrefix() {
        return this.logPrefix;
    }

    public String toString() {
        return this.logPrefix;
    }

    @Override
    public void addBeanChange(BeanChange beanChange) {
        if (this.changeLogHolder == null) {
            this.changeLogHolder = new TChangeLogHolder(this, 100);
        }
        this.changeLogHolder.addBeanChange(beanChange);
    }

    @Override
    public void sendChangeLog(ChangeSet changesRequest) {
        this.manager.sendChangeLog(changesRequest);
    }

    @Override
    public void register(TransactionCallback callback) {
        if (this.callbackList == null) {
            this.callbackList = new ArrayList<TransactionCallback>(4);
        }
        this.callbackList.add(callback);
    }

    protected void firePreRollback() {
        if (this.callbackList != null) {
            for (TransactionCallback callback : this.callbackList) {
                try {
                    callback.preRollback();
                }
                catch (Exception e) {
                    logger.error("Error executing preRollback callback", (Throwable)e);
                }
            }
        }
    }

    protected void firePostRollback() {
        if (this.callbackList != null) {
            for (TransactionCallback callback : this.callbackList) {
                try {
                    callback.postRollback();
                }
                catch (Exception e) {
                    logger.error("Error executing postRollback callback", (Throwable)e);
                }
            }
        }
        if (this.changeLogHolder != null) {
            this.changeLogHolder.postRollback();
        }
    }

    protected void firePreCommit() {
        if (this.callbackList != null) {
            for (TransactionCallback callback : this.callbackList) {
                try {
                    callback.preCommit();
                }
                catch (Exception e) {
                    logger.error("Error executing preCommit callback", (Throwable)e);
                }
            }
        }
    }

    protected void firePostCommit() {
        if (this.callbackList != null) {
            for (TransactionCallback callback : this.callbackList) {
                try {
                    callback.postCommit();
                }
                catch (Exception e) {
                    logger.error("Error executing postCommit callback", (Throwable)e);
                }
            }
        }
        if (this.changeLogHolder != null) {
            this.changeLogHolder.postCommit();
        }
    }

    @Override
    public int getDocStoreBatchSize() {
        return this.docStoreBatchSize;
    }

    @Override
    public void setDocStoreBatchSize(int docStoreBatchSize) {
        this.docStoreBatchSize = docStoreBatchSize;
    }

    @Override
    public DocStoreMode getDocStoreMode() {
        return this.docStoreMode;
    }

    @Override
    public void setDocStoreMode(DocStoreMode docStoreMode) {
        this.docStoreMode = docStoreMode;
    }

    @Override
    public List<DerivedRelationshipData> getDerivedRelationship(Object bean) {
        if (this.derivedRelMap == null) {
            return null;
        }
        return this.derivedRelMap.get(System.identityHashCode(bean));
    }

    @Override
    public void registerDerivedRelationship(DerivedRelationshipData derivedRelationship) {
        Integer key;
        List<DerivedRelationshipData> list;
        if (this.derivedRelMap == null) {
            this.derivedRelMap = new HashMap();
        }
        if ((list = this.derivedRelMap.get(key = Integer.valueOf(System.identityHashCode(derivedRelationship.getAssocBean())))) == null) {
            list = new ArrayList<DerivedRelationshipData>();
            this.derivedRelMap.put(key, list);
        }
        list.add(derivedRelationship);
    }

    @Override
    public void registerDeleteBean(Integer persistingBean) {
        if (this.deletingBeansHash == null) {
            this.deletingBeansHash = new HashSet();
        }
        this.deletingBeansHash.add(persistingBean);
    }

    @Override
    public void unregisterDeleteBean(Integer persistedBean) {
        if (this.deletingBeansHash != null) {
            this.deletingBeansHash.remove(persistedBean);
        }
    }

    @Override
    public boolean isRegisteredDeleteBean(Integer persistingBean) {
        return this.deletingBeansHash != null && this.deletingBeansHash.contains(persistingBean);
    }

    @Override
    public void unregisterBean(Object bean) {
        this.persistingBeans.remove(bean);
    }

    @Override
    public boolean isRegisteredBean(Object bean) {
        if (this.persistingBeans == null) {
            this.persistingBeans = new IdentityHashMap();
        }
        return this.persistingBeans.put(bean, PLACEHOLDER) != null;
    }

    @Override
    public boolean isSaveAssocManyIntersection(String intersectionTable, String beanName) {
        if (this.m2mIntersectionSave == null) {
            this.m2mIntersectionSave = new HashMap();
            this.m2mIntersectionSave.put(intersectionTable, beanName);
            return true;
        }
        String existingBean = this.m2mIntersectionSave.get(intersectionTable);
        if (existingBean == null) {
            this.m2mIntersectionSave.put(intersectionTable, beanName);
            return true;
        }
        return existingBean.equals(beanName);
    }

    @Override
    public void depth(int diff) {
        this.depth += diff;
    }

    @Override
    public int depth() {
        return this.depth;
    }

    @Override
    public void markNotQueryOnly() {
        this.queryOnly = false;
    }

    @Override
    public boolean isReadOnly() {
        if (!this.isActive()) {
            throw new IllegalStateException(illegalStateMessage);
        }
        try {
            return this.connection.isReadOnly();
        }
        catch (SQLException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        if (!this.isActive()) {
            throw new IllegalStateException(illegalStateMessage);
        }
        try {
            this.localReadOnly = readOnly;
            this.connection.setReadOnly(readOnly);
        }
        catch (SQLException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    @Override
    public void setUpdateAllLoadedProperties(boolean updateAllLoadedProperties) {
        this.updateAllLoadedProperties = updateAllLoadedProperties;
    }

    @Override
    public Boolean isUpdateAllLoadedProperties() {
        return this.updateAllLoadedProperties;
    }

    @Override
    public void setBatchMode(boolean batchMode) {
        if (!this.isActive()) {
            throw new IllegalStateException(illegalStateMessage);
        }
        this.batchMode = batchMode ? PersistBatch.ALL : PersistBatch.NONE;
    }

    @Override
    public void setBatch(PersistBatch batchMode) {
        if (!this.isActive()) {
            throw new IllegalStateException(illegalStateMessage);
        }
        this.batchMode = batchMode;
    }

    @Override
    public PersistBatch getBatch() {
        return this.batchMode;
    }

    @Override
    public void setBatchOnCascade(PersistBatch batchOnCascadeMode) {
        if (!this.isActive()) {
            throw new IllegalStateException(illegalStateMessage);
        }
        this.batchOnCascadeMode = batchOnCascadeMode;
    }

    @Override
    public PersistBatch getBatchOnCascade() {
        return this.batchOnCascadeMode;
    }

    @Override
    public void setBatchGetGeneratedKeys(boolean getGeneratedKeys) {
        this.batchGetGeneratedKeys = getGeneratedKeys;
        if (this.batchControl != null) {
            this.batchControl.setGetGeneratedKeys(getGeneratedKeys);
        }
    }

    @Override
    public void setBatchFlushOnMixed(boolean batchFlushOnMixed) {
        this.batchFlushOnMixed = batchFlushOnMixed;
        if (this.batchControl != null) {
            this.batchControl.setBatchFlushOnMixed(batchFlushOnMixed);
        }
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
        if (this.batchControl != null) {
            this.batchControl.setBatchSize(batchSize);
        }
    }

    @Override
    public boolean isBatchFlushOnQuery() {
        return this.batchFlushOnQuery;
    }

    @Override
    public void setBatchFlushOnQuery(boolean batchFlushOnQuery) {
        this.batchFlushOnQuery = batchFlushOnQuery;
    }

    @Override
    public boolean isBatchThisRequest(PersistRequest.Type type) {
        if (!this.batchOnCascadeSet && !this.explicit && this.depth <= 0) {
            return false;
        }
        return this.isBatch(this.batchMode, type);
    }

    private boolean isBatchOnCascade(PersistRequest.Type type) {
        return this.isBatch(this.batchOnCascadeMode, type);
    }

    private boolean isBatch(PersistBatch batch, PersistRequest.Type type) {
        switch (batch) {
            case ALL: {
                return true;
            }
            case INSERT: {
                return type == PersistRequest.Type.INSERT;
            }
        }
        return false;
    }

    @Override
    public void checkBatchEscalationOnCollection() {
        if (this.batchMode == PersistBatch.NONE && this.batchOnCascadeMode != PersistBatch.NONE) {
            this.batchMode = this.batchOnCascadeMode;
            this.batchOnCascadeSet = true;
        }
    }

    @Override
    public void flushBatchOnCollection() {
        if (this.batchOnCascadeSet) {
            if (this.batchControl != null) {
                if (logger.isTraceEnabled()) {
                    logger.trace("... flushBatchOnCollection");
                }
                this.batchControl.flushReset();
            }
            this.batchMode = PersistBatch.NONE;
        }
    }

    @Override
    public void flushBatchOnCascade() {
        if (this.batchControl != null) {
            if (logger.isTraceEnabled()) {
                logger.trace("... flushBatchOnCascade");
            }
            this.batchControl.flushReset();
        }
        this.batchMode = this.oldBatchMode;
    }

    @Override
    public boolean checkBatchEscalationOnCascade(PersistRequestBean<?> request) {
        if (this.isBatch(this.batchMode, request.getType())) {
            return false;
        }
        if (this.isBatchOnCascade(request.getType())) {
            this.oldBatchMode = this.batchMode;
            this.batchMode = PersistBatch.ALL;
            if (this.batchControl != null) {
                this.batchControl.flushReset();
            }
            request.setSkipBatchForTopLevel();
            return true;
        }
        if (this.batchControl != null && !this.batchControl.isEmpty()) {
            if (logger.isTraceEnabled()) {
                logger.trace("... flush from batchOnCascade ");
            }
            this.batchControl.flushReset();
        }
        return false;
    }

    @Override
    public BatchControl getBatchControl() {
        return this.batchControl;
    }

    @Override
    public void setBatchControl(BatchControl batchControl) {
        this.queryOnly = false;
        this.batchControl = batchControl;
        if (this.batchGetGeneratedKeys != null) {
            batchControl.setGetGeneratedKeys(this.batchGetGeneratedKeys);
        }
        if (this.batchSize != -1) {
            batchControl.setBatchSize(this.batchSize);
        }
        if (this.batchFlushOnMixed != null) {
            batchControl.setBatchFlushOnMixed(this.batchFlushOnMixed);
        }
    }

    @Override
    public void flushBatch() {
        if (!this.isActive()) {
            throw new IllegalStateException(illegalStateMessage);
        }
        if (this.batchControl != null) {
            this.batchControl.flush();
        }
    }

    @Override
    public PersistenceContext getPersistenceContext() {
        return this.persistenceContext;
    }

    @Override
    public void setPersistenceContext(PersistenceContext context) {
        if (!this.isActive()) {
            throw new IllegalStateException(illegalStateMessage);
        }
        this.persistenceContext = context;
    }

    @Override
    public TransactionEvent getEvent() {
        this.queryOnly = false;
        if (this.event == null) {
            this.event = new TransactionEvent();
        }
        return this.event;
    }

    @Override
    public boolean isExplicit() {
        return this.explicit;
    }

    @Override
    public boolean isLogSql() {
        return TransactionManager.SQL_LOGGER.isDebugEnabled();
    }

    @Override
    public boolean isLogSummary() {
        return TransactionManager.SUM_LOGGER.isDebugEnabled();
    }

    @Override
    public void logSql(String msg) {
        TransactionManager.SQL_LOGGER.debug(Str.add(this.logPrefix, msg));
    }

    @Override
    public void logSummary(String msg) {
        TransactionManager.SUM_LOGGER.debug(Str.add(this.logPrefix, msg));
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Connection getInternalConnection() {
        if (!this.isActive()) {
            throw new IllegalStateException(illegalStateMessage);
        }
        return this.connection;
    }

    @Override
    public Connection getConnection() {
        this.queryOnly = false;
        return this.getInternalConnection();
    }

    protected void deactivate() {
        try {
            if (this.localReadOnly) {
                this.connection.setReadOnly(false);
            }
        }
        catch (SQLException e) {
            logger.error("Error setting to readOnly?", (Throwable)e);
        }
        try {
            if (this.autoCommit) {
                this.connection.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            logger.error("Error setting to readOnly?", (Throwable)e);
        }
        try {
            this.connection.close();
        }
        catch (Exception ex) {
            logger.error("Error closing connection", (Throwable)ex);
        }
        this.connection = null;
        this.active = false;
    }

    protected void notifyCommit() {
        if (this.manager != null) {
            if (this.queryOnly) {
                this.manager.notifyOfQueryOnly(this);
            } else {
                this.manager.notifyOfCommit(this);
            }
        }
    }

    protected void notifyQueryOnly() {
        if (this.manager != null) {
            this.manager.notifyOfQueryOnly(this);
        }
    }

    protected void connectionEndForQueryOnly() {
        try {
            switch (this.onQueryOnly) {
                case ROLLBACK: {
                    this.performRollback();
                    break;
                }
                case COMMIT: {
                    this.performCommit();
                    break;
                }
                case CLOSE: {
                    break;
                }
                default: {
                    this.performRollback();
                    break;
                }
            }
        }
        catch (SQLException e) {
            logger.error("Error when ending a query only transaction via " + (Object)((Object)this.onQueryOnly), (Throwable)e);
        }
    }

    protected void performRollback() throws SQLException {
        this.connection.rollback();
    }

    protected void performCommit() throws SQLException {
        this.connection.commit();
    }

    @Override
    public void commit() throws RollbackException {
        if (!this.isActive()) {
            throw new IllegalStateException(illegalStateMessage);
        }
        this.firePreCommit();
        try {
            if (this.queryOnly) {
                this.connectionEndForQueryOnly();
            } else {
                if (this.batchControl != null && !this.batchControl.isEmpty()) {
                    this.batchControl.flush();
                }
                this.performCommit();
            }
        }
        catch (Exception e) {
            throw new RollbackException((Throwable)e);
        }
        finally {
            this.firePostCommit();
            this.deactivate();
            this.notifyCommit();
        }
    }

    protected void notifyRollback(Throwable cause) {
        if (this.manager != null) {
            if (this.queryOnly) {
                this.manager.notifyOfQueryOnly(this);
            } else {
                this.manager.notifyOfRollback(this, cause);
            }
        }
    }

    @Override
    public void rollback() throws PersistenceException {
        this.rollback(null);
    }

    @Override
    public void rollback(Throwable cause) throws PersistenceException {
        if (!this.isActive()) {
            throw new IllegalStateException(illegalStateMessage);
        }
        this.firePreRollback();
        try {
            this.performRollback();
        }
        catch (Exception ex) {
            throw new PersistenceException((Throwable)ex);
        }
        finally {
            this.firePostRollback();
            this.deactivate();
            this.notifyRollback(cause);
        }
    }

    @Override
    public void end() throws PersistenceException {
        if (this.isActive()) {
            this.rollback();
        }
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public boolean isPersistCascade() {
        return this.persistCascade;
    }

    @Override
    public void setPersistCascade(boolean persistCascade) {
        this.persistCascade = persistCascade;
    }

    @Override
    public void addModification(String tableName, boolean inserts, boolean updates, boolean deletes) {
        this.getEvent().add(tableName, inserts, updates, deletes);
    }

    @Override
    public void putUserObject(String name, Object value) {
        if (this.userObjects == null) {
            this.userObjects = new HashMap<String, Object>();
        }
        this.userObjects.put(name, value);
    }

    @Override
    public Object getUserObject(String name) {
        if (this.userObjects == null) {
            return null;
        }
        return this.userObjects.get(name);
    }

    @Override
    public void close() throws IOException {
        try {
            this.end();
        }
        catch (PersistenceException ex) {
            throw new IOException(ex);
        }
    }
}

