/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.transaction;

import com.avaje.ebeaninternal.api.SpiTransaction;
import com.avaje.ebeaninternal.server.transaction.TransactionMap;

public final class DefaultTransactionThreadLocal {
    private static final ThreadLocal<TransactionMap> local = new ThreadLocal<TransactionMap>(){

        @Override
        protected synchronized TransactionMap initialValue() {
            return new TransactionMap();
        }
    };

    private DefaultTransactionThreadLocal() {
    }

    private static TransactionMap.State getState(String serverName) {
        return local.get().getStateWithCreate(serverName);
    }

    public static void set(String serverName, SpiTransaction trans) {
        DefaultTransactionThreadLocal.getState(serverName).set(trans);
    }

    public static void replace(String serverName, SpiTransaction trans) {
        DefaultTransactionThreadLocal.getState(serverName).replace(trans);
    }

    public static SpiTransaction get(String serverName) {
        SpiTransaction t;
        TransactionMap map = local.get();
        TransactionMap.State state = map.getState(serverName);
        SpiTransaction spiTransaction = t = state == null ? null : state.transaction;
        if (map.isEmpty()) {
            local.remove();
        }
        return t;
    }

    public static void commit(String serverName) {
        TransactionMap map = local.get();
        TransactionMap.State state = map.removeState(serverName);
        if (state == null) {
            throw new IllegalStateException("No current transaction for [" + serverName + "]");
        }
        state.commit();
        if (map.isEmpty()) {
            local.remove();
        }
    }

    public static void rollback(String serverName) {
        TransactionMap map = local.get();
        TransactionMap.State state = map.removeState(serverName);
        if (state == null) {
            throw new IllegalStateException("No current transaction for [" + serverName + "]");
        }
        state.rollback();
        if (map.isEmpty()) {
            local.remove();
        }
    }

    public static void end(String serverName) {
        TransactionMap map = local.get();
        TransactionMap.State state = map.removeState(serverName);
        if (state != null) {
            state.end();
        }
        if (map.isEmpty()) {
            local.remove();
        }
    }
}

