/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.readaudit;

import com.avaje.ebean.event.readaudit.ReadAuditLogger;
import com.avaje.ebean.event.readaudit.ReadAuditQueryPlan;
import com.avaje.ebean.event.readaudit.ReadEvent;
import com.avaje.ebean.text.json.EJson;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultReadAuditLogger
implements ReadAuditLogger {
    private static final Logger appLogger = LoggerFactory.getLogger(DefaultReadAuditLogger.class);
    private static final Logger queryLogger = LoggerFactory.getLogger((String)"org.avaje.ebean.ReadAuditQuery");
    private static final Logger auditLogger = LoggerFactory.getLogger((String)"org.avaje.ebean.ReadAudit");
    protected final JsonFactory jsonFactory = new JsonFactory();
    protected int defaultQueryBuffer = 500;
    protected int defaultReadBuffer = 150;

    @Override
    public void queryPlan(ReadAuditQueryPlan queryPlan) {
        try {
            String sql;
            String queryKey;
            StringWriter writer = new StringWriter(this.defaultQueryBuffer);
            JsonGenerator gen = this.jsonFactory.createGenerator((Writer)writer);
            gen.writeStartObject();
            String beanType = queryPlan.getBeanType();
            if (beanType != null) {
                gen.writeStringField("beanType", beanType);
            }
            if ((queryKey = queryPlan.getQueryKey()) != null) {
                gen.writeStringField("queryKey", queryKey);
            }
            if ((sql = queryPlan.getSql()) != null) {
                gen.writeStringField("sql", sql);
            }
            gen.writeEndObject();
            gen.flush();
            gen.close();
            queryLogger.info(writer.toString());
        }
        catch (IOException e) {
            appLogger.error("Error writing Read audit event", (Throwable)e);
        }
    }

    @Override
    public void auditBean(ReadEvent beanEvent) {
        this.writeEvent(beanEvent);
    }

    @Override
    public void auditMany(ReadEvent readMany) {
        this.writeEvent(readMany);
    }

    protected void writeEvent(ReadEvent event) {
        try {
            StringWriter writer = new StringWriter(this.defaultReadBuffer);
            JsonGenerator gen = this.jsonFactory.createGenerator((Writer)writer);
            this.writeDetails(gen, event);
            auditLogger.info(writer.toString());
        }
        catch (IOException e) {
            appLogger.error("Error writing Read audit event", (Throwable)e);
        }
    }

    protected void writeDetails(JsonGenerator gen, ReadEvent event) throws IOException {
        Map<String, String> userContext;
        String userIpAddress;
        String userId;
        gen.writeStartObject();
        String source = event.getSource();
        if (source != null) {
            gen.writeStringField("source", source);
        }
        if ((userId = event.getUserId()) != null) {
            gen.writeStringField("userId", userId);
        }
        if ((userIpAddress = event.getUserIpAddress()) != null) {
            gen.writeStringField("userIpAddress", userIpAddress);
        }
        if ((userContext = event.getUserContext()) != null && !userContext.isEmpty()) {
            gen.writeObjectFieldStart("userContext");
            for (Map.Entry<String, String> entry : userContext.entrySet()) {
                gen.writeStringField(entry.getKey(), entry.getValue());
            }
            gen.writeEndObject();
        }
        gen.writeNumberField("eventTime", event.getEventTime());
        gen.writeStringField("beanType", event.getBeanType());
        gen.writeStringField("queryKey", event.getQueryKey());
        gen.writeStringField("bindLog", event.getBindLog());
        Object id = event.getId();
        if (id != null) {
            gen.writeFieldName("id");
            EJson.write(id, gen);
        } else {
            gen.writeFieldName("ids");
            EJson.writeCollection(event.getIds(), gen);
        }
        gen.writeEndObject();
        gen.flush();
        gen.close();
    }
}

