/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.querydefn;

import com.avaje.ebean.FetchConfig;
import com.avaje.ebeaninternal.api.HashQueryPlanBuilder;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssoc;
import com.avaje.ebeaninternal.server.el.ElPropertyDeploy;
import com.avaje.ebeaninternal.server.el.ElPropertyValue;
import com.avaje.ebeaninternal.server.query.SplitName;
import com.avaje.ebeaninternal.server.querydefn.OrmQueryProperties;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.PersistenceException;

public class OrmQueryDetail
implements Serializable {
    private static final long serialVersionUID = -2510486880141461807L;
    private OrmQueryProperties baseProps = new OrmQueryProperties();
    private LinkedHashMap<String, OrmQueryProperties> fetchPaths = new LinkedHashMap();

    public OrmQueryDetail copy() {
        OrmQueryDetail copy = new OrmQueryDetail();
        copy.baseProps = this.baseProps.copy();
        for (Map.Entry<String, OrmQueryProperties> entry : this.fetchPaths.entrySet()) {
            copy.fetchPaths.put(entry.getKey(), entry.getValue().copy());
        }
        return copy;
    }

    public int queryPlanHash() {
        HashQueryPlanBuilder builder = new HashQueryPlanBuilder();
        this.queryPlanHash(builder);
        return builder.getPlanHash();
    }

    public void queryPlanHash(HashQueryPlanBuilder builder) {
        this.baseProps.queryPlanHash(builder);
        if (this.fetchPaths != null) {
            for (OrmQueryProperties p : this.fetchPaths.values()) {
                p.queryPlanHash(builder);
            }
        }
    }

    public boolean isSameByPlan(OrmQueryDetail otherDetail) {
        if (!this.isSameByPlan(this.baseProps, otherDetail.baseProps)) {
            return false;
        }
        if (this.fetchPaths == null) {
            return otherDetail.fetchPaths == null;
        }
        if (this.fetchPaths.size() != otherDetail.fetchPaths.size()) {
            return false;
        }
        Iterator<Map.Entry<String, OrmQueryProperties>> thisIt = this.fetchPaths.entrySet().iterator();
        Iterator<Map.Entry<String, OrmQueryProperties>> thatIt = otherDetail.fetchPaths.entrySet().iterator();
        while (thisIt.hasNext() && thatIt.hasNext()) {
            Map.Entry<String, OrmQueryProperties> thisEntry = thisIt.next();
            Map.Entry<String, OrmQueryProperties> thatEntry = thatIt.next();
            if (!thisEntry.getKey().equals(thatEntry.getKey())) {
                return false;
            }
            if (thisEntry.getValue().isSameByPlan(thatEntry.getValue())) continue;
            return false;
        }
        return true;
    }

    public boolean isAutoTuneEqual(OrmQueryDetail otherDetail) {
        if (!this.isSameByAutoTune(this.baseProps, otherDetail.baseProps)) {
            return false;
        }
        if (this.fetchPaths == null) {
            return otherDetail.fetchPaths == null;
        }
        if (this.fetchPaths.size() != otherDetail.fetchPaths.size()) {
            return false;
        }
        for (Map.Entry<String, OrmQueryProperties> entry : this.fetchPaths.entrySet()) {
            OrmQueryProperties chunk = otherDetail.getChunk(entry.getKey(), false);
            if (this.isSameByAutoTune(entry.getValue(), chunk)) continue;
            return false;
        }
        return true;
    }

    private boolean isSameByAutoTune(OrmQueryProperties p1, OrmQueryProperties p2) {
        return p1 == null ? p2 == null : p1.isSameByAutoTune(p2);
    }

    private boolean isSameByPlan(OrmQueryProperties p1, OrmQueryProperties p2) {
        return p1 == null ? p2 == null : p1.isSameByPlan(p2);
    }

    public String toString() {
        return this.asString();
    }

    public String asString() {
        StringBuilder sb = new StringBuilder();
        if (!this.baseProps.isEmpty()) {
            this.baseProps.append("select ", sb);
        }
        if (this.fetchPaths != null) {
            for (OrmQueryProperties join : this.fetchPaths.values()) {
                join.append(" fetch ", sb);
            }
        }
        return sb.toString();
    }

    public int hashCode() {
        throw new RuntimeException("should not use");
    }

    public void select(String columns) {
        this.baseProps = new OrmQueryProperties(null, columns, null);
    }

    public boolean containsProperty(String property) {
        return this.baseProps.isIncluded(property);
    }

    public void setBase(OrmQueryProperties baseProps) {
        this.baseProps = baseProps;
    }

    public List<OrmQueryProperties> removeSecondaryQueries() {
        return this.removeSecondaryQueries(false);
    }

    public List<OrmQueryProperties> removeSecondaryLazyQueries() {
        return this.removeSecondaryQueries(true);
    }

    private List<OrmQueryProperties> removeSecondaryQueries(boolean lazyQuery) {
        int i;
        ArrayList<String> matchingPaths = new ArrayList<String>(2);
        for (OrmQueryProperties chunk : this.fetchPaths.values()) {
            boolean match = lazyQuery ? chunk.isLazyFetch() : chunk.isQueryFetch();
            if (!match) continue;
            matchingPaths.add(chunk.getPath());
        }
        if (matchingPaths.size() == 0) {
            return null;
        }
        Collections.sort(matchingPaths);
        ArrayList<OrmQueryProperties> props = new ArrayList<OrmQueryProperties>();
        for (i = 0; i < matchingPaths.size(); ++i) {
            String path = (String)matchingPaths.get(i);
            OrmQueryProperties secQuery = (OrmQueryProperties)this.fetchPaths.remove(path);
            if (secQuery == null) continue;
            props.add(secQuery);
            Iterator<OrmQueryProperties> pass2It = this.fetchPaths.values().iterator();
            while (pass2It.hasNext()) {
                OrmQueryProperties pass2Prop = pass2It.next();
                if (!secQuery.isChild(pass2Prop)) continue;
                pass2It.remove();
                secQuery.add(pass2Prop);
            }
        }
        for (i = 0; i < props.size(); ++i) {
            String path = props.get(i).getPath();
            String[] split = SplitName.split(path);
            OrmQueryProperties chunk = this.getChunk(split[0], true);
            chunk.addSecondaryQueryJoin(split[1]);
        }
        return props;
    }

    public boolean tuneFetchProperties(OrmQueryDetail tunedDetail) {
        boolean tuned = false;
        OrmQueryProperties tunedRoot = tunedDetail.getChunk(null, false);
        if (tunedRoot != null) {
            tuned = true;
            this.baseProps = tunedRoot;
            for (OrmQueryProperties tunedChunk : tunedDetail.fetchPaths.values()) {
                this.fetch(tunedChunk.copy());
            }
        }
        return tuned;
    }

    protected void fetch(OrmQueryProperties chunk) {
        String path = chunk.getPath();
        if (path == null) {
            this.baseProps = chunk;
        } else {
            this.fetchPaths.put(path, chunk);
        }
    }

    public void clear() {
        this.fetchPaths.clear();
    }

    public void fetch(String path, String partialProps, FetchConfig fetchConfig) {
        this.fetch(new OrmQueryProperties(path, partialProps, fetchConfig));
    }

    public void fetch(String path, LinkedHashSet<String> properties) {
        this.fetch(new OrmQueryProperties(path, properties));
    }

    public void sortFetchPaths(BeanDescriptor<?> d) {
        if (!this.fetchPaths.isEmpty()) {
            LinkedHashMap<String, OrmQueryProperties> sorted = new LinkedHashMap<String, OrmQueryProperties>();
            for (OrmQueryProperties p : this.fetchPaths.values()) {
                this.sortFetchPaths(d, p, sorted);
            }
            this.fetchPaths = sorted;
        }
    }

    private void sortFetchPaths(BeanDescriptor<?> d, OrmQueryProperties p, LinkedHashMap<String, OrmQueryProperties> sorted) {
        String path = p.getPath();
        if (!sorted.containsKey(path)) {
            String parentPath = p.getParentPath();
            if (parentPath == null || sorted.containsKey(parentPath)) {
                sorted.put(path, p);
            } else {
                OrmQueryProperties parentProp = this.fetchPaths.get(parentPath);
                if (parentProp == null) {
                    ElPropertyValue el = d.getElGetValue(parentPath);
                    if (el == null) {
                        throw new PersistenceException("Path [" + parentPath + "] not valid from " + d.getFullName());
                    }
                    BeanPropertyAssoc assocOne = (BeanPropertyAssoc)el.getBeanProperty();
                    parentProp = new OrmQueryProperties(parentPath, assocOne.getTargetIdProperty());
                }
                this.sortFetchPaths(d, parentProp, sorted);
                sorted.put(path, p);
            }
        }
    }

    public void markQueryJoins(BeanDescriptor<?> beanDescriptor, String lazyLoadManyPath, boolean allowOne) {
        String manyFetchProperty = null;
        boolean fetchJoinFirstMany = allowOne;
        this.sortFetchPaths(beanDescriptor);
        for (String fetchPath : this.fetchPaths.keySet()) {
            OrmQueryProperties chunk;
            ElPropertyDeploy elProp = beanDescriptor.getElPropertyDeploy(fetchPath);
            if (elProp == null || !elProp.containsManySince(manyFetchProperty) || !this.isQueryJoinCandidate(lazyLoadManyPath, chunk = this.fetchPaths.get(fetchPath))) continue;
            if (fetchJoinFirstMany) {
                fetchJoinFirstMany = false;
                manyFetchProperty = fetchPath;
                continue;
            }
            chunk.markForQueryJoin();
        }
    }

    private boolean isQueryJoinCandidate(String lazyLoadManyPath, OrmQueryProperties chunk) {
        return chunk.isFetchJoin() && !this.isLazyLoadManyRoot(lazyLoadManyPath, chunk) && !this.hasParentSecJoin(lazyLoadManyPath, chunk);
    }

    private boolean isLazyLoadManyRoot(String lazyLoadManyPath, OrmQueryProperties chunk) {
        return lazyLoadManyPath != null && lazyLoadManyPath.equals(chunk.getPath());
    }

    private boolean hasParentSecJoin(String lazyLoadManyPath, OrmQueryProperties chunk) {
        OrmQueryProperties parent = this.getParent(chunk);
        if (parent == null) {
            return false;
        }
        if (lazyLoadManyPath != null && lazyLoadManyPath.equals(parent.getPath())) {
            return false;
        }
        return !parent.isFetchJoin() || this.hasParentSecJoin(lazyLoadManyPath, parent);
    }

    private OrmQueryProperties getParent(OrmQueryProperties chunk) {
        String parentPath = chunk.getParentPath();
        return parentPath == null ? null : this.fetchPaths.get(parentPath);
    }

    public void setDefaultSelectClause(BeanDescriptor<?> desc) {
        if (desc.hasDefaultSelectClause() && !this.hasSelectClause()) {
            this.baseProps = new OrmQueryProperties(null, desc.getDefaultSelectClause());
        }
        for (OrmQueryProperties joinProps : this.fetchPaths.values()) {
            BeanDescriptor<?> assocDesc;
            if (joinProps.hasSelectClause() || !(assocDesc = desc.getBeanDescriptor(joinProps.getPath())).hasDefaultSelectClause()) continue;
            this.fetch(joinProps.getPath(), assocDesc.getDefaultSelectClause(), joinProps.getFetchConfig());
        }
    }

    public boolean hasSelectClause() {
        return this.baseProps.hasSelectClause();
    }

    public boolean isEmpty() {
        return this.fetchPaths.isEmpty() && this.baseProps.allProperties();
    }

    public boolean isJoinsEmpty() {
        return this.fetchPaths.isEmpty();
    }

    public void includeBeanJoin(String parentPath, String propertyName) {
        OrmQueryProperties parentChunk = this.getChunk(parentPath, true);
        parentChunk.includeBeanJoin(propertyName);
    }

    public OrmQueryProperties getChunk(String path, boolean create) {
        if (path == null) {
            return this.baseProps;
        }
        OrmQueryProperties props = this.fetchPaths.get(path);
        if (create && props == null) {
            props = new OrmQueryProperties(path);
            this.fetch(props);
            return props;
        }
        return props;
    }

    public boolean includesPath(String path) {
        OrmQueryProperties chunk = this.fetchPaths.get(path);
        return chunk != null && !chunk.isCache();
    }

    public Set<String> getFetchPaths() {
        return this.fetchPaths.keySet();
    }

    public Set<Map.Entry<String, OrmQueryProperties>> entries() {
        return this.fetchPaths.entrySet();
    }
}

