/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.query;

import com.avaje.ebean.EbeanServer;
import com.avaje.ebean.PagedList;
import com.avaje.ebeaninternal.api.Monitor;
import com.avaje.ebeaninternal.api.SpiQuery;
import java.util.List;
import java.util.concurrent.Future;
import javax.persistence.PersistenceException;

public class LimitOffsetPagedList<T>
implements PagedList<T> {
    private final transient EbeanServer server;
    private final SpiQuery<T> query;
    private final int firstRow;
    private final int maxRows;
    private final int pageIndex;
    private final Monitor monitor = new Monitor();
    private int foregroundTotalRowCount = -1;
    private Future<Integer> futureRowCount;
    private List<T> list;

    public LimitOffsetPagedList(EbeanServer server, SpiQuery<T> query, int pageIndex, int pageSize) {
        this.server = server;
        this.query = query;
        this.maxRows = pageSize;
        this.firstRow = pageIndex * pageSize;
        this.pageIndex = pageIndex;
        query.setFirstRow(this.firstRow);
        query.setMaxRows(pageSize);
    }

    public LimitOffsetPagedList(EbeanServer server, SpiQuery<T> query) {
        this.server = server;
        this.query = query;
        this.maxRows = query.getMaxRows();
        this.firstRow = query.getFirstRow();
        this.pageIndex = 0;
    }

    @Override
    public void loadRowCount() {
        this.getFutureRowCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Integer> getFutureRowCount() {
        Monitor monitor = this.monitor;
        synchronized (monitor) {
            if (this.futureRowCount == null) {
                this.futureRowCount = this.server.findFutureRowCount(this.query, null);
            }
            return this.futureRowCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<T> getList() {
        Monitor monitor = this.monitor;
        synchronized (monitor) {
            if (this.list == null) {
                this.list = this.server.findList(this.query, null);
            }
            return this.list;
        }
    }

    @Override
    public int getTotalPageCount() {
        int rowCount = this.getTotalRowCount();
        if (rowCount == 0) {
            return 0;
        }
        return (rowCount - 1) / this.maxRows + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTotalRowCount() {
        Monitor monitor = this.monitor;
        synchronized (monitor) {
            if (this.futureRowCount != null) {
                try {
                    return this.futureRowCount.get();
                }
                catch (Exception e) {
                    throw new PersistenceException((Throwable)e);
                }
            }
            if (this.foregroundTotalRowCount > -1) {
                return this.foregroundTotalRowCount;
            }
            this.foregroundTotalRowCount = this.server.findRowCount(this.query, null);
            return this.foregroundTotalRowCount;
        }
    }

    @Override
    public boolean hasNext() {
        return this.firstRow + this.maxRows < this.getTotalRowCount();
    }

    @Override
    public boolean hasPrev() {
        return this.firstRow > 0;
    }

    @Override
    public int getPageIndex() {
        return this.pageIndex;
    }

    @Override
    public int getPageSize() {
        return this.maxRows;
    }

    @Override
    public String getDisplayXtoYofZ(String to, String of) {
        int first = this.firstRow + 1;
        int last = this.firstRow + this.getList().size();
        int total = this.getTotalRowCount();
        return first + to + last + of + total;
    }
}

