/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.query;

import com.avaje.ebean.RawSql;
import com.avaje.ebeaninternal.api.BindParams;
import com.avaje.ebeaninternal.api.SpiExpressionList;
import com.avaje.ebeaninternal.api.SpiQuery;
import com.avaje.ebeaninternal.server.core.OrmQueryRequest;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import com.avaje.ebeaninternal.server.deploy.DeployParser;
import com.avaje.ebeaninternal.server.expression.DefaultExpressionRequest;
import com.avaje.ebeaninternal.server.persist.Binder;
import com.avaje.ebeaninternal.server.query.CQueryBuilder;
import com.avaje.ebeaninternal.server.query.CQueryOrderBy;
import com.avaje.ebeaninternal.server.query.SqlTreeAlias;
import com.avaje.ebeaninternal.server.querydefn.OrmQueryProperties;
import com.avaje.ebeaninternal.server.type.DataBind;
import com.avaje.ebeaninternal.server.util.BindParamsParser;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CQueryPredicates {
    private static final Logger logger = LoggerFactory.getLogger(CQueryPredicates.class);
    private final Binder binder;
    private final OrmQueryRequest<?> request;
    private final SpiQuery<?> query;
    private final Object idValue;
    private final BindParams bindParams;
    private BindParams.OrderedList havingNamedParams;
    private DefaultExpressionRequest filterMany;
    private String filterManyExprSql;
    private DefaultExpressionRequest where;
    private String whereExprSql;
    private String whereRawSql;
    private DefaultExpressionRequest having;
    private String havingExprSql;
    private String havingRawSql;
    private String dbHaving;
    private String dbWhere;
    private String dbFilterMany;
    private String dbOrderBy;
    private Set<String> predicateIncludes;
    private Set<String> orderByIncludes;

    public CQueryPredicates(Binder binder, OrmQueryRequest<?> request) {
        this.binder = binder;
        this.request = request;
        this.query = request.getQuery();
        this.bindParams = this.query.getBindParams();
        this.idValue = this.query.getId();
    }

    public String bind(DataBind dataBind) throws SQLException {
        int i;
        Timestamp asOf;
        List<String> historyTableAlias;
        if (this.query.isVersionsBetween() && this.binder.isBindAsOfWithFromClause()) {
            Timestamp start = this.query.getVersionStart();
            Timestamp end = this.query.getVersionEnd();
            dataBind.append("between ").append(start).append(" and ").append(end);
            this.binder.bindObject(dataBind, start);
            this.binder.bindObject(dataBind, end);
            dataBind.append(", ");
        }
        if ((historyTableAlias = this.query.getAsOfTableAlias()) != null && this.binder.isBindAsOfWithFromClause()) {
            asOf = this.query.getAsOf();
            dataBind.append("asOf ").append(asOf);
            for (i = 0; i < historyTableAlias.size() * this.binder.getAsOfBindCount(); ++i) {
                this.binder.bindObject(dataBind, asOf);
            }
            dataBind.append(", ");
        }
        if (this.idValue != null) {
            this.request.getBeanDescriptor().bindId(dataBind, this.idValue);
            dataBind.append(this.idValue);
        }
        if (this.bindParams != null) {
            this.binder.bind(this.bindParams, dataBind, dataBind.log());
        }
        if (this.where != null) {
            this.where.bind(dataBind);
        }
        if (this.filterMany != null) {
            this.filterMany.bind(dataBind);
        }
        if (historyTableAlias != null && !this.binder.isBindAsOfWithFromClause()) {
            asOf = this.query.getAsOf();
            dataBind.append(" asOf ").append(asOf);
            for (i = 0; i < historyTableAlias.size() * this.binder.getAsOfBindCount(); ++i) {
                this.binder.bindObject(dataBind, asOf);
            }
        }
        if (this.havingNamedParams != null) {
            this.binder.bind(this.havingNamedParams.list(), dataBind, dataBind.log());
        }
        if (this.having != null) {
            this.having.bind(dataBind);
        }
        return dataBind.log().toString();
    }

    private void buildBindHavingRawSql(boolean buildSql, boolean parseRaw, DeployParser deployParser) {
        if (buildSql || this.bindParams != null) {
            this.havingRawSql = this.query.getAdditionalHaving();
            if (parseRaw) {
                this.havingRawSql = deployParser.parse(this.havingRawSql);
            }
            if (this.havingRawSql != null && this.bindParams != null) {
                this.havingNamedParams = BindParamsParser.parseNamedParams(this.bindParams, this.havingRawSql);
                this.havingRawSql = this.havingNamedParams.getPreparedSql();
            }
        }
    }

    private void buildBindWhereRawSql(boolean buildSql, boolean parseRaw, DeployParser parser) {
        if (buildSql || this.bindParams != null) {
            boolean hasRaw;
            this.whereRawSql = this.buildWhereRawSql();
            boolean bl = hasRaw = !"".equals(this.whereRawSql);
            if (hasRaw && parseRaw) {
                parser.setEncrypted(true);
                this.whereRawSql = parser.parse(this.whereRawSql);
                parser.setEncrypted(false);
            }
            if (this.bindParams != null) {
                if (hasRaw) {
                    this.whereRawSql = BindParamsParser.parse(this.bindParams, this.whereRawSql, this.request.getBeanDescriptor());
                } else if (this.query.isRawSql() && !buildSql) {
                    String s;
                    RawSql.Sql sql = this.query.getRawSql().getSql();
                    String string = s = sql.isParsed() ? sql.getPreWhere() : sql.getUnparsedSql();
                    if (this.bindParams.requiresNamedParamsPrepare()) {
                        BindParamsParser.parse(this.bindParams, s);
                    }
                }
            }
        }
    }

    private String buildWhereRawSql() {
        String additionalWhere;
        String whereRaw = this.query.getRawWhereClause();
        if (whereRaw == null) {
            whereRaw = "";
        }
        if ((additionalWhere = this.query.getAdditionalWhere()) != null) {
            whereRaw = whereRaw + additionalWhere;
        }
        return whereRaw;
    }

    public void prepare(boolean buildSql) {
        DeployParser deployParser = this.request.createDeployParser();
        this.prepare(buildSql, true, deployParser);
    }

    public void prepareRawSql(DeployParser deployParser) {
        this.prepare(true, false, deployParser);
    }

    private void prepare(boolean buildSql, boolean parseRaw, DeployParser deployParser) {
        SpiExpressionList<?> havingExpr;
        OrmQueryProperties chunk;
        SpiExpressionList<?> filterManyExpr;
        BeanPropertyAssocMany<?> manyProperty;
        this.buildBindWhereRawSql(buildSql, parseRaw, deployParser);
        this.buildBindHavingRawSql(buildSql, parseRaw, deployParser);
        SpiExpressionList<?> whereExp = this.query.getWhereExpressions();
        if (whereExp != null) {
            this.where = new DefaultExpressionRequest(this.request, deployParser, this.binder, whereExp);
            if (buildSql) {
                this.whereExprSql = this.where.buildSql();
            }
        }
        if ((manyProperty = this.request.getManyProperty()) != null && (filterManyExpr = (chunk = this.query.getDetail().getChunk(manyProperty.getName(), false)).getFilterMany()) != null) {
            this.filterMany = new DefaultExpressionRequest(this.request, deployParser, this.binder, filterManyExpr);
            if (buildSql) {
                this.filterManyExprSql = this.filterMany.buildSql();
            }
        }
        if ((havingExpr = this.query.getHavingExpressions()) != null) {
            this.having = new DefaultExpressionRequest(this.request, deployParser, this.binder, havingExpr);
            if (buildSql) {
                this.havingExprSql = this.having.buildSql();
            }
        }
        if (buildSql) {
            this.parsePropertiesToDbColumns(deployParser);
        }
    }

    private void parsePropertiesToDbColumns(DeployParser deployParser) {
        String logicalOrderBy = this.deriveOrderByWithMany(this.request.getManyProperty());
        if (logicalOrderBy != null) {
            this.dbOrderBy = deployParser.parse(logicalOrderBy);
        }
        this.orderByIncludes = new HashSet<String>(deployParser.getIncludes());
        this.dbWhere = this.deriveWhere(deployParser);
        this.dbFilterMany = this.deriveFilterMany(deployParser);
        this.dbHaving = this.deriveHaving(deployParser);
        this.predicateIncludes = deployParser.getIncludes();
    }

    private String deriveFilterMany(DeployParser deployParser) {
        if (this.isEmpty(this.filterManyExprSql)) {
            return null;
        }
        return deployParser.parse(this.filterManyExprSql);
    }

    private String deriveWhere(DeployParser deployParser) {
        return this.parse(this.whereRawSql, this.whereExprSql, deployParser);
    }

    public void parseTableAlias(SqlTreeAlias alias) {
        if (this.dbWhere != null) {
            this.dbWhere = alias.parseWhere(this.dbWhere);
        }
        if (this.dbFilterMany != null) {
            this.dbFilterMany = alias.parse(this.dbFilterMany);
        }
        if (this.dbHaving != null) {
            this.dbHaving = alias.parseWhere(this.dbHaving);
        }
        if (this.dbOrderBy != null) {
            this.dbOrderBy = alias.parse(this.dbOrderBy);
        }
    }

    private boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    private String parse(String raw, String expr, DeployParser deployParser) {
        StringBuilder sb = new StringBuilder();
        if (!this.isEmpty(raw)) {
            sb.append(raw);
        }
        if (!this.isEmpty(expr)) {
            if (sb.length() > 0) {
                sb.append(" and ");
            }
            sb.append(deployParser.parse(expr));
        }
        return sb.toString();
    }

    private String deriveHaving(DeployParser deployParser) {
        return this.parse(this.havingRawSql, this.havingExprSql, deployParser);
    }

    private String parseOrderBy() {
        return CQueryOrderBy.parse(this.request.getBeanDescriptor(), this.query);
    }

    private String deriveOrderByWithMany(BeanPropertyAssocMany<?> manyProp) {
        String manyOrderBy;
        if (manyProp == null) {
            return this.parseOrderBy();
        }
        String orderBy = this.parseOrderBy();
        BeanDescriptor<?> desc = this.request.getBeanDescriptor();
        String orderById = desc.getDefaultOrderBy();
        if (orderBy == null) {
            orderBy = orderById;
        }
        if ((manyOrderBy = manyProp.getFetchOrderBy()) != null) {
            orderBy = orderBy + ", " + CQueryBuilder.prefixOrderByFields(manyProp.getName(), manyOrderBy);
        }
        if (this.request.isFindById()) {
            return orderBy;
        }
        if (orderBy.startsWith(orderById)) {
            return orderBy;
        }
        int manyPos = orderBy.indexOf(manyProp.getName());
        int idPos = orderBy.indexOf(" " + orderById);
        if (manyPos == -1) {
            if (idPos == -1) {
                return orderBy + ", " + orderById;
            }
            return orderBy;
        }
        if (idPos <= -1 || idPos >= manyPos) {
            if (idPos > manyPos) {
                String msg = "A Query on [" + desc + "] includes a join to a 'many' association [" + manyProp.getName();
                msg = msg + "] with an incorrect orderBy [" + orderBy + "]. The id property [" + orderById + "]";
                msg = msg + " must come before the many property [" + manyProp.getName() + "] in the orderBy.";
                msg = msg + " Ebean has automatically modified the orderBy clause to do this.";
                logger.warn(msg);
            }
            orderBy = orderBy.substring(0, manyPos) + orderById + ", " + orderBy.substring(manyPos);
        }
        return orderBy;
    }

    public List<Object> getWhereExprBindValues() {
        return this.where.getBindValues();
    }

    public String getDbHaving() {
        return this.dbHaving;
    }

    public String getDbWhere() {
        return this.dbWhere;
    }

    public String getDbFilterMany() {
        return this.dbFilterMany;
    }

    public String getDbOrderBy() {
        return this.dbOrderBy;
    }

    public Set<String> getPredicateIncludes() {
        return this.predicateIncludes;
    }

    public Set<String> getOrderByIncludes() {
        return this.orderByIncludes;
    }

    public String getLogWhereSql() {
        String logPred;
        if (this.dbWhere == null && this.dbFilterMany == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (this.dbWhere != null) {
            sb.append(this.dbWhere);
        }
        if (this.dbFilterMany != null) {
            if (sb.length() > 0) {
                sb.append(" and ");
            }
            sb.append(this.dbFilterMany);
        }
        if ((logPred = sb.toString()).length() > 400) {
            logPred = logPred.substring(0, 400) + " ...";
        }
        return logPred;
    }
}

