/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.query;

import com.avaje.ebean.RawSql;
import com.avaje.ebean.config.dbplatform.SqlLimitResponse;
import com.avaje.ebeaninternal.server.core.OrmQueryRequest;
import com.avaje.ebeaninternal.server.deploy.InheritInfo;
import com.avaje.ebeaninternal.server.query.CQueryPlan;
import com.avaje.ebeaninternal.server.query.SqlTree;
import com.avaje.ebeaninternal.server.type.DataReader;
import com.avaje.ebeaninternal.server.type.RsetDataReaderIndexed;
import java.sql.ResultSet;
import java.util.List;

public class CQueryPlanRawSql
extends CQueryPlan {
    private final int[] rsetIndexPositions;

    public CQueryPlanRawSql(OrmQueryRequest<?> request, SqlLimitResponse sqlRes, SqlTree sqlTree, String logWhereSql) {
        super(request, sqlRes, sqlTree, true, logWhereSql);
        this.rsetIndexPositions = this.createIndexPositions(request, sqlTree);
    }

    @Override
    public DataReader createDataReader(ResultSet rset) {
        return new RsetDataReaderIndexed(rset, this.rsetIndexPositions, this.isRowNumberIncluded());
    }

    private int[] createIndexPositions(OrmQueryRequest<?> request, SqlTree sqlTree) {
        int i;
        List<String> chain = sqlTree.buildRawSqlSelectChain();
        RawSql.ColumnMapping columnMapping = request.getQuery().getRawSql().getColumnMapping();
        InheritInfo inheritInfo = request.getBeanDescriptor().getInheritInfo();
        boolean addDiscriminator = inheritInfo != null;
        int offset = addDiscriminator ? 1 : 0;
        int[] indexPositions = new int[chain.size() + offset];
        if (addDiscriminator) {
            indexPositions[0] = 1;
        }
        for (i = 0; i < chain.size(); ++i) {
            int indexPos;
            String expr = chain.get(i);
            indexPositions[i + offset] = indexPos = 1 + columnMapping.getIndexPosition(expr);
        }
        for (i = 0; i < indexPositions.length; ++i) {
            if (indexPositions[i] != 0 || i >= indexPositions.length) continue;
            indexPositions[i] = indexPositions[i + 1] - 1;
        }
        return indexPositions;
    }
}

