/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.query;

import com.avaje.ebean.Query;
import com.avaje.ebean.QueryIterator;
import com.avaje.ebean.ValuePair;
import com.avaje.ebean.Version;
import com.avaje.ebean.bean.BeanCollection;
import com.avaje.ebean.bean.BeanCollectionTouched;
import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebean.bean.ObjectGraphNode;
import com.avaje.ebean.config.dbplatform.DatabasePlatform;
import com.avaje.ebeaninternal.api.BeanIdList;
import com.avaje.ebeaninternal.api.SpiQuery;
import com.avaje.ebeaninternal.api.SpiTransaction;
import com.avaje.ebeaninternal.server.core.DiffHelp;
import com.avaje.ebeaninternal.server.core.OrmQueryRequest;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.lib.util.Str;
import com.avaje.ebeaninternal.server.persist.Binder;
import com.avaje.ebeaninternal.server.query.CQuery;
import com.avaje.ebeaninternal.server.query.CQueryBuilder;
import com.avaje.ebeaninternal.server.query.CQueryDelete;
import com.avaje.ebeaninternal.server.query.CQueryDraftSupport;
import com.avaje.ebeaninternal.server.query.CQueryFetchIds;
import com.avaje.ebeaninternal.server.query.CQueryHistorySupport;
import com.avaje.ebeaninternal.server.query.CQueryRowCount;
import com.avaje.ebeaninternal.server.transaction.TransactionManager;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CQueryEngine {
    private static final Logger logger = LoggerFactory.getLogger(CQueryEngine.class);
    private static final int defaultSecondaryQueryBatchSize = 100;
    private static final String T0 = "t0";
    private final boolean forwardOnlyHintOnFindIterate;
    private final CQueryBuilder queryBuilder;
    private final CQueryHistorySupport historySupport;

    public CQueryEngine(DatabasePlatform dbPlatform, Binder binder, Map<String, String> asOfTableMapping, String asOfSysPeriod, Map<String, String> draftTableMap) {
        this.forwardOnlyHintOnFindIterate = dbPlatform.isForwardOnlyHintOnFindIterate();
        this.historySupport = new CQueryHistorySupport(dbPlatform.getHistorySupport(), asOfTableMapping, asOfSysPeriod);
        this.queryBuilder = new CQueryBuilder(dbPlatform, binder, this.historySupport, new CQueryDraftSupport(draftTableMap));
    }

    public <T> CQuery<T> buildQuery(OrmQueryRequest<T> request) {
        return this.queryBuilder.buildQuery(request);
    }

    public <T> int delete(OrmQueryRequest<T> request) {
        CQueryDelete query = this.queryBuilder.buildDeleteQuery(request);
        try {
            int rows = query.delete();
            if (request.isLogSql()) {
                String logSql = query.getGeneratedSql();
                if (TransactionManager.SQL_LOGGER.isTraceEnabled()) {
                    logSql = Str.add(logSql, "; --bind(", query.getBindLog(), ") rows:", String.valueOf(rows));
                }
                request.logSql(logSql);
            }
            return rows;
        }
        catch (SQLException e) {
            throw CQuery.createPersistenceException(e, (SpiTransaction)request.getTransaction(), query.getBindLog(), query.getGeneratedSql());
        }
    }

    public <T> BeanIdList findIds(OrmQueryRequest<T> request) {
        CQueryFetchIds rcQuery = this.queryBuilder.buildFetchIdsQuery(request);
        try {
            BeanIdList list = rcQuery.findIds();
            if (request.isLogSql()) {
                String logSql = rcQuery.getGeneratedSql();
                if (TransactionManager.SQL_LOGGER.isTraceEnabled()) {
                    logSql = Str.add(logSql, "; --bind(", rcQuery.getBindLog(), ")");
                }
                request.logSql(logSql);
            }
            if (request.isLogSummary()) {
                request.getTransaction().logSummary(rcQuery.getSummary());
            }
            if (request.getQuery().isFutureFetch()) {
                logger.debug("Future findIds completed!");
                request.getTransaction().end();
            }
            return list;
        }
        catch (SQLException e) {
            throw CQuery.createPersistenceException(e, (SpiTransaction)request.getTransaction(), rcQuery.getBindLog(), rcQuery.getGeneratedSql());
        }
    }

    public <T> int findRowCount(OrmQueryRequest<T> request) {
        CQueryRowCount rcQuery = this.queryBuilder.buildRowCountQuery(request);
        try {
            int rowCount = rcQuery.findRowCount();
            if (request.isLogSql()) {
                String logSql = rcQuery.getGeneratedSql();
                if (TransactionManager.SQL_LOGGER.isTraceEnabled()) {
                    logSql = Str.add(logSql, "; --bind(", rcQuery.getBindLog(), ")");
                }
                request.logSql(logSql);
            }
            if (request.isLogSummary()) {
                request.getTransaction().logSummary(rcQuery.getSummary());
            }
            if (request.getQuery().isFutureFetch()) {
                logger.debug("Future findRowCount completed!");
                request.getTransaction().end();
            }
            return rowCount;
        }
        catch (SQLException e) {
            throw CQuery.createPersistenceException(e, (SpiTransaction)request.getTransaction(), rcQuery.getBindLog(), rcQuery.getGeneratedSql());
        }
    }

    public <T> QueryIterator<T> findIterate(OrmQueryRequest<T> request) {
        CQuery<T> cquery = this.queryBuilder.buildQuery(request);
        request.setCancelableQuery(cquery);
        try {
            int queryBatch;
            int iterateBufferSize;
            if (!cquery.prepareBindExecuteQueryForwardOnly(this.forwardOnlyHintOnFindIterate)) {
                logger.trace("Future fetch already cancelled");
                return null;
            }
            if (request.isLogSql()) {
                this.logSql(cquery);
            }
            if ((iterateBufferSize = request.getSecondaryQueriesMinBatchSize(100)) < 1 && (queryBatch = request.getQuery().getLazyLoadBatchSize()) > 0) {
                iterateBufferSize = queryBatch;
            }
            QueryIterator<T> readIterate = cquery.readIterate(iterateBufferSize, request);
            if (request.isLogSummary()) {
                this.logFindManySummary(cquery);
            }
            if (request.isAuditReads()) {
                cquery.auditFindIterate();
            }
            return readIterate;
        }
        catch (SQLException e) {
            throw cquery.createPersistenceException(e);
        }
    }

    public <T> List<Version<T>> findVersions(OrmQueryRequest<T> request) {
        Query query = request.getQuery();
        if (query.isVersionsBetween() && !this.historySupport.isBindAtFromClause()) {
            query.where().gt(this.getSysPeriodLower((SpiQuery<T>)query), query.getVersionStart());
            query.where().lt(this.getSysPeriodLower((SpiQuery<T>)query), query.getVersionEnd());
        }
        query.orderBy().asc(request.getBeanDescriptor().getIdProperty().getName());
        query.orderBy().desc(this.getSysPeriodLower((SpiQuery<T>)query));
        CQuery<T> cquery = this.queryBuilder.buildQuery(request);
        try {
            cquery.prepareBindExecuteQuery();
            if (request.isLogSql()) {
                this.logSql(cquery);
            }
            List<Version<T>> versions = cquery.readVersions();
            this.deriveVersionDiffs(versions, request);
            if (request.isLogSummary()) {
                this.logFindManySummary(cquery);
            }
            if (request.isAuditReads()) {
                cquery.auditFindMany();
            }
            List<Version<T>> list = versions;
            return list;
        }
        catch (SQLException e) {
            throw cquery.createPersistenceException(e);
        }
        finally {
            if (cquery != null) {
                cquery.close();
            }
        }
    }

    private <T> void deriveVersionDiffs(List<Version<T>> versions, OrmQueryRequest<T> request) {
        BeanDescriptor<T> descriptor = request.getBeanDescriptor();
        if (!versions.isEmpty()) {
            Version<T> current = versions.get(0);
            if (versions.size() > 1) {
                for (int i = 1; i < versions.size(); ++i) {
                    Version<T> next = versions.get(i);
                    this.deriveVersionDiff(current, next, descriptor);
                    current = next;
                }
            }
            current.setDiff(new LinkedHashMap<String, ValuePair>());
        }
    }

    private <T> void deriveVersionDiff(Version<T> current, Version<T> prior, BeanDescriptor<T> descriptor) {
        Map<String, ValuePair> diff = DiffHelp.diff(current.getBean(), prior.getBean(), descriptor);
        current.setDiff(diff);
    }

    private <T> String getSysPeriodLower(SpiQuery<T> query) {
        String rootTableAlias = query.getAlias();
        if (rootTableAlias == null) {
            rootTableAlias = T0;
        }
        return this.historySupport.getSysPeriodLower(rootTableAlias);
    }

    public <T> BeanCollection<T> findMany(OrmQueryRequest<T> request) {
        Query query = request.getQuery();
        if (query.getMaxRows() > 1 || query.getFirstRow() > 0) {
            request.getBeanDescriptor().appendOrderById((SpiQuery<T>)query);
        }
        CQuery<T> cquery = this.queryBuilder.buildQuery(request);
        request.setCancelableQuery(cquery);
        try {
            if (!cquery.prepareBindExecuteQuery()) {
                logger.trace("Future fetch already cancelled");
                BeanCollection<T> beanCollection = null;
                return beanCollection;
            }
            if (request.isLogSql()) {
                this.logSql(cquery);
            }
            BeanCollection<T> beanCollection = cquery.readCollection();
            BeanCollectionTouched collectionTouched = query.getBeanCollectionTouched();
            if (collectionTouched != null) {
                beanCollection.setBeanCollectionTouched(collectionTouched);
            }
            if (request.isLogSummary()) {
                this.logFindManySummary(cquery);
            }
            if (request.isAuditReads()) {
                cquery.auditFindMany();
            }
            request.executeSecondaryQueries(false);
            BeanCollection<T> beanCollection2 = beanCollection;
            return beanCollection2;
        }
        catch (SQLException e) {
            throw cquery.createPersistenceException(e);
        }
        finally {
            if (cquery != null) {
                cquery.close();
            }
            if (query.isFutureFetch()) {
                logger.debug("Future fetch completed!");
                request.getTransaction().end();
            }
        }
    }

    public <T> T find(OrmQueryRequest<T> request) {
        EntityBean bean = null;
        CQuery<T> cquery = this.queryBuilder.buildQuery(request);
        try {
            cquery.prepareBindExecuteQuery();
            if (request.isLogSql()) {
                this.logSql(cquery);
            }
            if (cquery.readBean()) {
                bean = cquery.next();
            }
            if (request.isLogSummary()) {
                this.logFindBeanSummary(cquery);
            }
            if (request.isAuditReads()) {
                cquery.auditFind(bean);
            }
            request.executeSecondaryQueries(false);
            EntityBean entityBean = bean;
            return (T)entityBean;
        }
        catch (SQLException e) {
            throw cquery.createPersistenceException(e);
        }
        finally {
            cquery.close();
        }
    }

    private void logSql(CQuery<?> query) {
        String sql = query.getGeneratedSql();
        if (TransactionManager.SQL_LOGGER.isTraceEnabled()) {
            sql = Str.add(sql, "; --bind(", query.getBindLog(), ")");
        }
        query.getTransaction().logSql(sql);
    }

    private void logFindBeanSummary(CQuery<?> q) {
        SpiQuery<?> query = q.getQueryRequest().getQuery();
        String loadMode = query.getLoadMode();
        String loadDesc = query.getLoadDescription();
        String lazyLoadProp = query.getLazyLoadProperty();
        ObjectGraphNode node = query.getParentNode();
        String originKey = node == null || node.getOriginQueryPoint() == null ? null : node.getOriginQueryPoint().getKey();
        StringBuilder msg = new StringBuilder(200);
        msg.append("FindBean ");
        if (loadMode != null) {
            msg.append("mode[").append(loadMode).append("] ");
        }
        msg.append("type[").append(q.getBeanName()).append("] ");
        if (query.isAutoTuned()) {
            msg.append("tuned[true] ");
        }
        if (query.isAsDraft()) {
            msg.append(" draft[true] ");
        }
        if (originKey != null) {
            msg.append("origin[").append(originKey).append("] ");
        }
        if (lazyLoadProp != null) {
            msg.append("lazyLoadProp[").append(lazyLoadProp).append("] ");
        }
        if (loadDesc != null) {
            msg.append("load[").append(loadDesc).append("] ");
        }
        msg.append("exeMicros[").append(q.getQueryExecutionTimeMicros());
        msg.append("] rows[").append(q.getLoadedRowDetail());
        msg.append("] bind[").append(q.getBindLog()).append("]");
        q.getTransaction().logSummary(msg.toString());
    }

    private void logFindManySummary(CQuery<?> q) {
        SpiQuery<?> query = q.getQueryRequest().getQuery();
        String loadMode = query.getLoadMode();
        String loadDesc = query.getLoadDescription();
        String lazyLoadProp = query.getLazyLoadProperty();
        ObjectGraphNode node = query.getParentNode();
        String originKey = node == null || node.getOriginQueryPoint() == null ? null : node.getOriginQueryPoint().getKey();
        StringBuilder msg = new StringBuilder(200);
        msg.append("FindMany ");
        if (loadMode != null) {
            msg.append("mode[").append(loadMode).append("] ");
        }
        msg.append("type[").append(q.getBeanName()).append("] ");
        if (query.isAutoTuned()) {
            msg.append("tuned[true] ");
        }
        if (query.isAsDraft()) {
            msg.append(" draft[true] ");
        }
        if (originKey != null) {
            msg.append("origin[").append(originKey).append("] ");
        }
        if (lazyLoadProp != null) {
            msg.append("lazyLoadProp[").append(lazyLoadProp).append("] ");
        }
        if (loadDesc != null) {
            msg.append("load[").append(loadDesc).append("] ");
        }
        msg.append("exeMicros[").append(q.getQueryExecutionTimeMicros());
        msg.append("] rows[").append(q.getLoadedRowDetail());
        msg.append("] name[").append(q.getName());
        msg.append("] predicates[").append(q.getLogWhereSql());
        msg.append("] bind[").append(q.getBindLog()).append("]");
        q.getTransaction().logSummary(msg.toString());
    }
}

