/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.persist.dml;

import com.avaje.ebean.config.dbplatform.DatabasePlatform;
import com.avaje.ebean.config.dbplatform.DbEncrypt;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssocOne;
import com.avaje.ebeaninternal.server.persist.dml.DeleteMeta;
import com.avaje.ebeaninternal.server.persist.dml.DmlMode;
import com.avaje.ebeaninternal.server.persist.dml.InsertMeta;
import com.avaje.ebeaninternal.server.persist.dml.UpdateMeta;
import com.avaje.ebeaninternal.server.persist.dmlbind.Bindable;
import com.avaje.ebeaninternal.server.persist.dmlbind.BindableId;
import com.avaje.ebeaninternal.server.persist.dmlbind.BindableList;
import com.avaje.ebeaninternal.server.persist.dmlbind.BindableUnidirectional;
import com.avaje.ebeaninternal.server.persist.dmlbind.FactoryAssocOnes;
import com.avaje.ebeaninternal.server.persist.dmlbind.FactoryBaseProperties;
import com.avaje.ebeaninternal.server.persist.dmlbind.FactoryEmbedded;
import com.avaje.ebeaninternal.server.persist.dmlbind.FactoryId;
import com.avaje.ebeaninternal.server.persist.dmlbind.FactoryVersion;
import java.util.ArrayList;

public class MetaFactory {
    private final FactoryBaseProperties baseFact;
    private final FactoryEmbedded embeddedFact;
    private final FactoryVersion versionFact = new FactoryVersion();
    private final FactoryAssocOnes assocOneFact = new FactoryAssocOnes();
    private final FactoryId idFact = new FactoryId();
    private static final boolean includeLobs = true;
    private final DatabasePlatform dbPlatform;
    private final boolean emptyStringAsNull;

    public MetaFactory(DatabasePlatform dbPlatform) {
        this.dbPlatform = dbPlatform;
        this.emptyStringAsNull = dbPlatform.isTreatEmptyStringsAsNull();
        DbEncrypt dbEncrypt = dbPlatform.getDbEncrypt();
        boolean bindEncryptDataFirst = dbEncrypt == null || dbEncrypt.isBindEncryptDataFirst();
        this.baseFact = new FactoryBaseProperties(bindEncryptDataFirst);
        this.embeddedFact = new FactoryEmbedded(bindEncryptDataFirst);
    }

    public UpdateMeta createUpdate(BeanDescriptor<?> desc) {
        ArrayList<Bindable> setList = new ArrayList<Bindable>();
        this.baseFact.create(setList, desc, DmlMode.UPDATE, true);
        this.embeddedFact.create(setList, desc, DmlMode.UPDATE, true);
        this.assocOneFact.create(setList, desc, DmlMode.UPDATE);
        BindableId id = this.idFact.createId(desc);
        Bindable ver = this.versionFact.create(desc);
        BindableList setBindable = new BindableList(setList);
        return new UpdateMeta(this.emptyStringAsNull, desc, setBindable, id, ver);
    }

    public DeleteMeta createDelete(BeanDescriptor<?> desc) {
        BindableId id = this.idFact.createId(desc);
        Bindable ver = this.versionFact.create(desc);
        return new DeleteMeta(this.emptyStringAsNull, desc, id, ver);
    }

    public InsertMeta createInsert(BeanDescriptor<?> desc) {
        BindableId id = this.idFact.createId(desc);
        ArrayList<Bindable> allList = new ArrayList<Bindable>();
        this.baseFact.create(allList, desc, DmlMode.INSERT, true);
        this.embeddedFact.create(allList, desc, DmlMode.INSERT, true);
        this.assocOneFact.create(allList, desc, DmlMode.INSERT);
        BindableList allBindable = new BindableList(allList);
        BeanPropertyAssocOne<?> unidirectional = desc.getUnidirectional();
        BindableUnidirectional shadowFkey = unidirectional == null ? null : new BindableUnidirectional(desc, unidirectional);
        return new InsertMeta(this.dbPlatform, desc, shadowFkey, id, allBindable);
    }
}

