/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.persist.dml;

import com.avaje.ebean.annotation.ConcurrencyMode;
import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebeaninternal.server.core.PersistRequestBean;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.persist.dml.DmlHandler;
import com.avaje.ebeaninternal.server.persist.dml.GenerateDmlRequest;
import com.avaje.ebeaninternal.server.persist.dmlbind.Bindable;
import com.avaje.ebeaninternal.server.persist.dmlbind.BindableId;
import java.sql.SQLException;

public final class DeleteMeta {
    private final String sqlVersion;
    private final String sqlNone;
    private final String sqlDraftVersion;
    private final String sqlDraftNone;
    private final BindableId id;
    private final Bindable version;
    private final String tableName;
    private final boolean emptyStringAsNull;

    public DeleteMeta(boolean emptyStringAsNull, BeanDescriptor<?> desc, BindableId id, Bindable version) {
        this.emptyStringAsNull = emptyStringAsNull;
        this.tableName = desc.getBaseTable();
        this.id = id;
        this.version = version;
        String tableName = desc.getBaseTable();
        this.sqlNone = this.genSql(ConcurrencyMode.NONE, tableName);
        this.sqlVersion = this.genSql(ConcurrencyMode.VERSION, tableName);
        if (desc.isDraftable()) {
            String draftTableName = desc.getDraftTable();
            this.sqlDraftNone = this.genSql(ConcurrencyMode.NONE, draftTableName);
            this.sqlDraftVersion = this.genSql(ConcurrencyMode.VERSION, draftTableName);
        } else {
            this.sqlDraftNone = this.sqlNone;
            this.sqlDraftVersion = this.sqlVersion;
        }
    }

    public boolean isEmptyStringAsNull() {
        return this.emptyStringAsNull;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void bind(PersistRequestBean<?> persist, DmlHandler bind) throws SQLException {
        EntityBean bean = persist.getEntityBean();
        this.id.dmlBind(bind, bean);
        switch (persist.getConcurrencyMode()) {
            case VERSION: {
                this.version.dmlBind(bind, bean);
                break;
            }
        }
    }

    public String getSql(PersistRequestBean<?> request) {
        if (this.id.isEmpty()) {
            throw new IllegalStateException("Can not deleteById on " + request.getFullName() + " as no @Id property");
        }
        boolean publish = request.isPublish();
        switch (request.determineConcurrencyMode()) {
            case NONE: {
                return publish ? this.sqlNone : this.sqlDraftNone;
            }
            case VERSION: {
                return publish ? this.sqlVersion : this.sqlDraftVersion;
            }
        }
        throw new RuntimeException("Invalid mode " + (Object)((Object)request.determineConcurrencyMode()));
    }

    private String genSql(ConcurrencyMode conMode, String table) {
        GenerateDmlRequest request = new GenerateDmlRequest();
        request.append("delete from ").append(table);
        request.append(" where ");
        request.setWhereIdMode();
        this.id.dmlAppend(request);
        if (ConcurrencyMode.VERSION.equals((Object)conMode)) {
            if (this.version == null) {
                return null;
            }
            this.version.dmlAppend(request);
        }
        return request.toString();
    }
}

