/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.persist;

import com.avaje.ebean.CallableSql;
import com.avaje.ebean.Query;
import com.avaje.ebean.SqlUpdate;
import com.avaje.ebean.Transaction;
import com.avaje.ebean.Update;
import com.avaje.ebean.bean.BeanCollection;
import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebean.bean.EntityBeanIntercept;
import com.avaje.ebean.bean.PersistenceContext;
import com.avaje.ebeaninternal.api.SpiEbeanServer;
import com.avaje.ebeaninternal.api.SpiTransaction;
import com.avaje.ebeaninternal.api.SpiUpdate;
import com.avaje.ebeaninternal.server.core.Message;
import com.avaje.ebeaninternal.server.core.PersistRequest;
import com.avaje.ebeaninternal.server.core.PersistRequestBean;
import com.avaje.ebeaninternal.server.core.PersistRequestCallableSql;
import com.avaje.ebeaninternal.server.core.PersistRequestOrmUpdate;
import com.avaje.ebeaninternal.server.core.PersistRequestUpdateSql;
import com.avaje.ebeaninternal.server.core.Persister;
import com.avaje.ebeaninternal.server.deploy.BeanCollectionUtil;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptorManager;
import com.avaje.ebeaninternal.server.deploy.BeanManager;
import com.avaje.ebeaninternal.server.deploy.BeanProperty;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssocOne;
import com.avaje.ebeaninternal.server.deploy.IntersectionRow;
import com.avaje.ebeaninternal.server.deploy.ManyType;
import com.avaje.ebeaninternal.server.persist.Binder;
import com.avaje.ebeaninternal.server.persist.DefaultPersistExecute;
import com.avaje.ebeaninternal.server.persist.DeleteUnloadedForeignKeys;
import com.avaje.ebeaninternal.server.persist.DmlUtil;
import com.avaje.ebeaninternal.server.persist.PersistExecute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultPersister
implements Persister {
    private static final Logger PUB = LoggerFactory.getLogger((String)"org.avaje.ebean.PUB");
    private static final Logger logger = LoggerFactory.getLogger(DefaultPersister.class);
    private final PersistExecute persistExecute;
    private final SpiEbeanServer server;
    private final BeanDescriptorManager beanDescriptorManager;
    private final boolean updatesDeleteMissingChildren;

    public DefaultPersister(SpiEbeanServer server, Binder binder, BeanDescriptorManager descMgr) {
        this.server = server;
        this.updatesDeleteMissingChildren = server.getServerConfig().isUpdatesDeleteMissingChildren();
        this.beanDescriptorManager = descMgr;
        this.persistExecute = new DefaultPersistExecute(binder, server.getServerConfig().getPersistBatchSize());
    }

    @Override
    public int executeCallable(CallableSql callSql, Transaction t) {
        return this.executeOrQueue(new PersistRequestCallableSql(this.server, callSql, (SpiTransaction)t, this.persistExecute));
    }

    @Override
    public int executeOrmUpdate(Update<?> update, Transaction t) {
        SpiUpdate ormUpdate = (SpiUpdate)update;
        BeanManager<?> mgr = this.beanDescriptorManager.getBeanManager(ormUpdate.getBeanType());
        if (mgr == null) {
            String msg = "No BeanManager found for type [" + ormUpdate.getBeanType() + "]. Is it an entity?";
            throw new PersistenceException(msg);
        }
        return this.executeOrQueue(new PersistRequestOrmUpdate(this.server, mgr, ormUpdate, (SpiTransaction)t, this.persistExecute));
    }

    private int executeOrQueue(PersistRequest request) {
        try {
            request.initTransIfRequired();
            int rc = request.executeOrQueue();
            request.commitTransIfRequired();
            return rc;
        }
        catch (RuntimeException e) {
            request.rollbackTransIfRequired();
            throw e;
        }
    }

    @Override
    public int executeSqlUpdate(SqlUpdate updSql, Transaction t) {
        return this.executeOrQueue(new PersistRequestUpdateSql(this.server, updSql, (SpiTransaction)t, this.persistExecute));
    }

    @Override
    public <T> List<T> draftRestore(Query<T> query, Transaction transaction) {
        Class<T> beanType = query.getBeanType();
        BeanDescriptor<T> desc = this.server.getBeanDescriptor(beanType);
        DraftHandler<T> draftHandler = new DraftHandler<T>(desc, transaction);
        List<T> liveBeans = draftHandler.fetchSourceBeans(query, false);
        PUB.debug("draftRestore [{}] count[{}]", (Object)desc.getName(), (Object)liveBeans.size());
        if (liveBeans.isEmpty()) {
            return Collections.emptyList();
        }
        draftHandler.fetchDestinationBeans(liveBeans, true);
        BeanManager<T> mgr = this.beanDescriptorManager.getBeanManager(beanType);
        for (T liveBean : liveBeans) {
            T draftBean = draftHandler.publishToDestinationBean(liveBean);
            draftHandler.resetDraft(draftBean);
            PUB.trace("draftRestore bean [{}] id[{}]", (Object)desc.getName(), draftHandler.getId());
            this.update(this.createRequest(draftBean, transaction, null, mgr, PersistRequest.Type.UPDATE, true, false));
        }
        PUB.debug("draftRestore - complete for [{}]", (Object)desc.getName());
        return draftHandler.getDrafts();
    }

    private <T> List<Object> getBeanIds(BeanDescriptor<T> desc, List<T> beans) {
        ArrayList<Object> idList = new ArrayList<Object>();
        for (T liveBean : beans) {
            idList.add(desc.getBeanId(liveBean));
        }
        return idList;
    }

    @Override
    public <T> List<T> publish(Query<T> query, Transaction transaction) {
        Class<T> beanType = query.getBeanType();
        BeanDescriptor<T> desc = this.server.getBeanDescriptor(beanType);
        DraftHandler<T> draftHandler = new DraftHandler<T>(desc, transaction);
        List<T> draftBeans = draftHandler.fetchSourceBeans(query, true);
        PUB.debug("publish [{}] count[{}]", (Object)desc.getName(), (Object)draftBeans.size());
        if (draftBeans.isEmpty()) {
            return Collections.emptyList();
        }
        draftHandler.fetchDestinationBeans(draftBeans, false);
        BeanManager<T> mgr = this.beanDescriptorManager.getBeanManager(beanType);
        ArrayList<T> livePublish = new ArrayList<T>(draftBeans.size());
        for (T draftBean : draftBeans) {
            T liveBean = draftHandler.publishToDestinationBean(draftBean);
            livePublish.add(liveBean);
            draftHandler.resetDraft(draftBean);
            PersistRequest.Type persistType = draftHandler.isInsert() ? PersistRequest.Type.INSERT : PersistRequest.Type.UPDATE;
            PUB.trace("publish bean [{}] id[{}] type[{}]", new Object[]{desc.getName(), draftHandler.getId(), persistType});
            PersistRequestBean<T> request = this.createRequest(liveBean, transaction, null, mgr, persistType, true, true);
            if (persistType == PersistRequest.Type.INSERT) {
                this.insert(request);
                continue;
            }
            this.update(request);
        }
        draftHandler.updateDrafts(transaction, mgr);
        PUB.debug("publish - complete for [{}]", (Object)desc.getName());
        return livePublish;
    }

    private void deleteRecurse(EntityBean detailBean, Transaction t, boolean softDelete) {
        PersistRequest.Type deleteType = softDelete ? PersistRequest.Type.SOFT_DELETE : PersistRequest.Type.DELETE_PERMANENT;
        this.deleteRequest(this.createRequest(detailBean, t, deleteType));
    }

    @Override
    public void update(EntityBean entityBean, Transaction t) {
        this.update(entityBean, t, this.updatesDeleteMissingChildren);
    }

    @Override
    public void update(EntityBean entityBean, Transaction t, boolean deleteMissingChildren) {
        PersistRequestBean<EntityBean> req = this.createRequest(entityBean, t, PersistRequest.Type.UPDATE);
        req.setDeleteMissingChildren(deleteMissingChildren);
        req.checkDraft();
        try {
            req.initTransIfRequiredWithBatchCascade();
            if (req.isReference()) {
                if (req.isPersistCascade()) {
                    this.saveAssocMany(false, req, false);
                }
                req.checkUpdatedManysOnly();
            } else {
                this.update(req);
            }
            req.commitTransIfRequired();
            req.flushBatchOnCascade();
        }
        catch (RuntimeException ex) {
            req.rollbackTransIfRequired();
            throw ex;
        }
    }

    @Override
    public void save(EntityBean bean, Transaction t) {
        if (bean._ebean_getIntercept().isLoaded()) {
            this.update(bean, t, false);
        } else {
            this.insert(bean, t);
        }
    }

    @Override
    public void insert(EntityBean bean, Transaction t) {
        PersistRequestBean<EntityBean> req = this.createRequest(bean, t, PersistRequest.Type.INSERT);
        try {
            req.initTransIfRequiredWithBatchCascade();
            this.insert(req);
            req.commitTransIfRequired();
            req.flushBatchOnCascade();
        }
        catch (RuntimeException ex) {
            req.rollbackTransIfRequired();
            throw ex;
        }
    }

    private void saveRecurse(EntityBean bean, Transaction t, Object parentBean, boolean insertMode, boolean publish) {
        PersistRequestBean<EntityBean> request = this.createRequestRecurse(bean, t, parentBean, insertMode, publish);
        if (request.isReference()) {
            if (request.isPersistCascade()) {
                this.saveAssocMany(false, request, insertMode);
            }
            request.checkUpdatedManysOnly();
        } else if (request.isInsert()) {
            this.insert(request);
        } else {
            this.update(request);
        }
    }

    private void insert(PersistRequestBean<?> request) {
        if (request.isRegisteredBean()) {
            return;
        }
        try {
            if (request.isPersistCascade()) {
                this.saveAssocOne(request, true);
            }
            this.setIdGenValue(request);
            request.executeOrQueue();
            if (request.isPersistCascade()) {
                this.saveAssocMany(true, request, true);
            }
        }
        finally {
            request.unRegisterBean();
        }
    }

    private void update(PersistRequestBean<?> request) {
        if (request.isRegisteredBean()) {
            return;
        }
        try {
            if (request.isPersistCascade()) {
                this.saveAssocOne(request, false);
            }
            if (request.isDirty()) {
                request.executeOrQueue();
            } else if (logger.isDebugEnabled()) {
                logger.debug(Message.msg("persist.update.skipped", request.getBean()));
            }
            if (request.isPersistCascade()) {
                this.saveAssocMany(false, request, false);
            }
            request.checkUpdatedManysOnly();
        }
        finally {
            request.unRegisterBean();
        }
    }

    @Override
    public boolean delete(EntityBean bean, Transaction t, boolean permanent) {
        PersistRequest.Type deleteType = permanent ? PersistRequest.Type.DELETE_PERMANENT : PersistRequest.Type.DELETE;
        PersistRequestBean<EntityBean> originalRequest = this.createRequest(bean, t, deleteType);
        if (originalRequest.isHardDeleteDraft()) {
            return this.deleteRequest(this.createPublishRequest(originalRequest.createReference(), t, PersistRequest.Type.DELETE_PERMANENT, true), originalRequest);
        }
        return this.deleteRequest(originalRequest);
    }

    private boolean deleteRequest(PersistRequestBean<?> req) {
        return this.deleteRequest(req, null);
    }

    private boolean deleteRequest(PersistRequestBean<?> req, PersistRequestBean<?> draftReq) {
        if (req.isRegisteredForDeleteBean()) {
            if (logger.isDebugEnabled()) {
                logger.debug("skipping delete on alreadyRegistered " + req.getBean());
            }
            return false;
        }
        try {
            req.initTransIfRequiredWithBatchCascade();
            boolean deleted = this.delete(req);
            if (draftReq != null) {
                draftReq.setTrans((SpiTransaction)req.getTransaction());
                deleted = this.delete(draftReq);
            }
            req.commitTransIfRequired();
            req.flushBatchOnCascade();
            return deleted;
        }
        catch (RuntimeException ex) {
            req.rollbackTransIfRequired();
            throw ex;
        }
    }

    private void deleteList(List<?> beanList, Transaction t, boolean softDelete) {
        for (int i = 0; i < beanList.size(); ++i) {
            this.deleteRecurse((EntityBean)beanList.get(i), t, softDelete);
        }
    }

    @Override
    public void deleteMany(Class<?> beanType, Collection<?> ids, Transaction transaction) {
        if (ids == null || ids.size() == 0) {
            return;
        }
        BeanDescriptor<?> descriptor = this.beanDescriptorManager.getBeanDescriptor(beanType);
        ArrayList<Object> idList = new ArrayList<Object>(ids.size());
        for (Object id : ids) {
            idList.add(descriptor.convertId(id));
        }
        this.delete(descriptor, null, idList, transaction, descriptor.isSoftDelete());
    }

    @Override
    public int delete(Class<?> beanType, Object id, Transaction transaction) {
        BeanDescriptor<?> descriptor = this.beanDescriptorManager.getBeanDescriptor(beanType);
        id = descriptor.convertId(id);
        return this.delete(descriptor, id, null, transaction, descriptor.isSoftDelete());
    }

    private int delete(BeanDescriptor<?> descriptor, Object id, List<Object> idList, Transaction transaction, boolean softDelete) {
        BeanPropertyAssocOne<?>[] propImportDelete;
        SpiTransaction t = (SpiTransaction)transaction;
        if (t.isPersistCascade() && (propImportDelete = descriptor.propertiesOneImportedDelete()).length > 0) {
            EntityBean bean;
            Query<?> q = this.deleteRequiresQuery(descriptor, propImportDelete, softDelete);
            if (idList != null) {
                q.where().idIn(idList);
                if (t.isLogSummary()) {
                    t.logSummary("-- DeleteById of " + descriptor.getName() + " ids[" + idList + "] requires fetch of foreign key values");
                }
                List<?> beanList = this.server.findList(q, (Transaction)t);
                this.deleteList(beanList, t, softDelete);
                return beanList.size();
            }
            q.where().idEq(id);
            if (t.isLogSummary()) {
                t.logSummary("-- DeleteById of " + descriptor.getName() + " id[" + id + "] requires fetch of foreign key values");
            }
            if ((bean = (EntityBean)this.server.findUnique(q, (Transaction)t)) == null) {
                return 0;
            }
            this.deleteRecurse(bean, t, softDelete);
            return 1;
        }
        if (t.isPersistCascade()) {
            BeanPropertyAssocOne<?>[] expOnes = descriptor.propertiesOneExportedDelete();
            for (int i = 0; i < expOnes.length; ++i) {
                BeanDescriptor targetDesc = expOnes[i].getTargetDescriptor();
                if (softDelete && !targetDesc.isSoftDelete()) continue;
                if (!softDelete && targetDesc.isDeleteByStatement()) {
                    SqlUpdate sqlDelete = expOnes[i].deleteByParentId(id, idList);
                    this.executeSqlUpdate(sqlDelete, t);
                    continue;
                }
                List<Object> childIds = expOnes[i].findIdsByParentId(id, idList, t);
                this.deleteChildrenById(t, targetDesc, childIds, softDelete);
            }
            BeanPropertyAssocMany<?>[] manys = descriptor.propertiesManyDelete();
            for (int i = 0; i < manys.length; ++i) {
                BeanDescriptor targetDesc = manys[i].getTargetDescriptor();
                if (softDelete && !targetDesc.isSoftDelete()) continue;
                if (!softDelete && targetDesc.isDeleteByStatement()) {
                    SqlUpdate sqlDelete = manys[i].deleteByParentId(id, idList);
                    this.executeSqlUpdate(sqlDelete, t);
                    continue;
                }
                List<Object> childIds = manys[i].findIdsByParentId(id, idList, t, null);
                if (childIds.isEmpty()) continue;
                this.delete(targetDesc, null, childIds, t, softDelete);
            }
        }
        if (!softDelete) {
            BeanPropertyAssocMany<?>[] manys = descriptor.propertiesManyToMany();
            for (int i = 0; i < manys.length; ++i) {
                SqlUpdate sqlDelete = manys[i].deleteByParentId(id, idList);
                if (t.isLogSummary()) {
                    t.logSummary("-- Deleting intersection table entries: " + manys[i].getFullBeanName());
                }
                this.executeSqlUpdate(sqlDelete, t);
            }
        }
        SqlUpdate deleteById = descriptor.deleteById(id, idList, softDelete);
        if (t.isLogSummary()) {
            if (idList != null) {
                t.logSummary("-- Deleting " + descriptor.getName() + " Ids: " + idList);
            } else {
                t.logSummary("-- Deleting " + descriptor.getName() + " Id: " + id);
            }
        }
        deleteById.setAutoTableMod(false);
        if (idList != null) {
            t.getEvent().addDeleteByIdList(descriptor, idList);
        } else {
            t.getEvent().addDeleteById(descriptor, id);
        }
        int rows = this.executeSqlUpdate(deleteById, t);
        PersistenceContext persistenceContext = t.getPersistenceContext();
        if (idList != null) {
            for (Object idValue : idList) {
                descriptor.contextDeleted(persistenceContext, idValue);
            }
        } else {
            descriptor.contextDeleted(persistenceContext, id);
        }
        return rows;
    }

    private Query<?> deleteRequiresQuery(BeanDescriptor<?> desc, BeanPropertyAssocOne<?>[] propImportDelete, boolean softDelete) {
        Query<?> q = this.server.createQuery(desc.getBeanType());
        StringBuilder sb = new StringBuilder(30);
        for (int i = 0; i < propImportDelete.length; ++i) {
            sb.append(propImportDelete[i].getName()).append(",");
        }
        q.setAutoTune(false);
        q.select(sb.toString());
        if (!softDelete) {
            q.setIncludeSoftDeletes();
        }
        return q;
    }

    private boolean delete(PersistRequestBean<?> request) {
        DeleteUnloadedForeignKeys unloadedForeignKeys = null;
        if (request.isPersistCascade()) {
            request.registerDeleteBean();
            this.deleteAssocMany(request);
            request.unregisterDeleteBean();
            unloadedForeignKeys = this.getDeleteUnloadedForeignKeys(request);
            if (unloadedForeignKeys != null) {
                unloadedForeignKeys.queryForeignKeys();
            }
        }
        int count = request.executeOrQueue();
        if (request.isPersistCascade()) {
            this.deleteAssocOne(request);
            if (unloadedForeignKeys != null) {
                unloadedForeignKeys.deleteCascade();
            }
        }
        return count != 0;
    }

    private void saveAssocMany(boolean insertedParent, PersistRequestBean<?> request, boolean insertMode) {
        EntityBean parentBean = request.getEntityBean();
        BeanDescriptor<?> desc = request.getBeanDescriptor();
        Transaction t = request.getTransaction();
        BeanPropertyAssocOne<?>[] expOnes = desc.propertiesOneExportedSave();
        for (int i = 0; i < expOnes.length; ++i) {
            EntityBean detailBean;
            BeanPropertyAssocOne<?> prop = expOnes[i];
            if (!request.isLoadedProperty(prop) || (detailBean = prop.getValueAsEntityBean(parentBean)) == null || prop.isSaveRecurseSkippable(detailBean)) continue;
            t.depth(1);
            prop.setParentBeanToChild(parentBean, detailBean);
            this.saveRecurse(detailBean, t, parentBean, insertMode, request.isPublish());
            t.depth(-1);
        }
        BeanPropertyAssocMany<?>[] manys = desc.propertiesManySave();
        for (int i = 0; i < manys.length; ++i) {
            if (!request.isLoadedProperty(manys[i]) || manys[i].isEmptyBeanCollection(parentBean, insertedParent)) continue;
            this.saveMany(new SaveManyPropRequest(insertedParent, manys[i], parentBean, request), insertMode);
            if (insertedParent) continue;
            request.addUpdatedManyProperty(manys[i]);
        }
    }

    private void saveMany(SaveManyPropRequest saveMany, boolean insertMode) {
        if (saveMany.getMany().isManyToMany()) {
            boolean saveIntersectionFromThisDirection = saveMany.isSaveIntersection();
            if (saveMany.isCascade()) {
                this.saveAssocManyDetails(saveMany, false, insertMode);
            }
            if (saveIntersectionFromThisDirection) {
                this.saveAssocManyIntersection(saveMany, saveMany.isDeleteMissingChildren());
            } else {
                saveMany.resetModifyState();
            }
        } else {
            if (saveMany.isModifyListenMode()) {
                this.removeAssocManyPrivateOwned(saveMany);
            }
            if (saveMany.isCascade()) {
                this.saveAssocManyDetails(saveMany, saveMany.isDeleteMissingChildren(), insertMode);
            }
        }
    }

    private void removeAssocManyPrivateOwned(SaveManyPropRequest saveMany) {
        Object details = saveMany.getValue();
        if (details instanceof BeanCollection) {
            BeanCollection c = (BeanCollection)details;
            Set modifyRemovals = c.getModifyRemovals();
            saveMany.modifyListenReset(c);
            if (modifyRemovals != null && !modifyRemovals.isEmpty()) {
                SpiTransaction t = saveMany.getTransaction();
                t.depth(1);
                for (Object removedBean : modifyRemovals) {
                    EntityBean eb;
                    if (!(removedBean instanceof EntityBean) || !(eb = (EntityBean)removedBean)._ebean_getIntercept().isLoaded()) continue;
                    this.deleteRequest(this.createPublishRequest(removedBean, t, PersistRequest.Type.DELETE, saveMany.isPublish()));
                }
                t.depth(-1);
            }
        }
    }

    private void saveAssocManyDetails(SaveManyPropRequest saveMany, boolean deleteMissingChildren, boolean insertMode) {
        BeanPropertyAssocMany prop = saveMany.getMany();
        Object details = saveMany.getValue();
        Collection<?> collection = BeanCollectionUtil.getActualEntries(details);
        if (collection == null) {
            return;
        }
        BeanDescriptor targetDescriptor = prop.getTargetDescriptor();
        if (saveMany.isInsertedParent()) {
            targetDescriptor.preAllocateIds(collection.size());
        }
        ArrayList<Object> detailIds = null;
        if (deleteMissingChildren) {
            detailIds = new ArrayList<Object>();
        }
        SpiTransaction t = saveMany.getTransaction();
        t.depth(1);
        boolean isMap = ManyType.MAP.equals((Object)prop.getManyType());
        EntityBean parentBean = saveMany.getParentBean();
        Object mapKeyValue = null;
        boolean saveSkippable = prop.isSaveRecurseSkippable();
        for (Object detailBean : collection) {
            boolean skipSavingThisBean;
            if (isMap) {
                Map.Entry entry = (Map.Entry)detailBean;
                mapKeyValue = entry.getKey();
                detailBean = entry.getValue();
            }
            if (!(detailBean instanceof EntityBean)) continue;
            EntityBean detail = (EntityBean)detailBean;
            EntityBeanIntercept ebi = detail._ebean_getIntercept();
            if (prop.isManyToMany()) {
                skipSavingThisBean = targetDescriptor.isReference(ebi);
            } else if (targetDescriptor.isReference(ebi)) {
                skipSavingThisBean = true;
            } else if (ebi.isNewOrDirty()) {
                skipSavingThisBean = false;
                prop.setJoinValuesToChild(parentBean, detail, mapKeyValue);
            } else {
                skipSavingThisBean = saveSkippable;
            }
            if (skipSavingThisBean) continue;
            this.saveRecurse(detail, t, parentBean, insertMode, saveMany.isPublish());
        }
        if (detailIds != null) {
            t.flushBatch();
            for (Object detailBean : collection) {
                Object id;
                if (isMap) {
                    detailBean = ((Map.Entry)detailBean).getValue();
                }
                if (!(detailBean instanceof EntityBean) || DmlUtil.isNullOrZero(id = targetDescriptor.getId((EntityBean)detailBean))) continue;
                detailIds.add(id);
            }
            this.deleteManyDetails(t, prop.getBeanDescriptor(), parentBean, prop, detailIds, false);
        }
        t.depth(-1);
    }

    @Override
    public int deleteManyToManyAssociations(EntityBean ownerBean, String propertyName, Transaction t) {
        BeanDescriptor<?> descriptor = this.beanDescriptorManager.getBeanDescriptor(ownerBean.getClass());
        BeanPropertyAssocMany prop = (BeanPropertyAssocMany)descriptor.getBeanProperty(propertyName);
        return this.deleteAssocManyIntersection(ownerBean, prop, t, false);
    }

    @Override
    public void saveManyToManyAssociations(EntityBean ownerBean, String propertyName, Transaction t) {
        BeanDescriptor<?> descriptor = this.beanDescriptorManager.getBeanDescriptor(ownerBean.getClass());
        BeanPropertyAssocMany prop = (BeanPropertyAssocMany)descriptor.getBeanProperty(propertyName);
        this.saveAssocManyIntersection(new SaveManyPropRequest(prop, ownerBean, (SpiTransaction)t), false);
    }

    @Override
    public void saveAssociation(EntityBean parentBean, String propertyName, Transaction t) {
        BeanDescriptor<?> descriptor = this.beanDescriptorManager.getBeanDescriptor(parentBean.getClass());
        SpiTransaction trans = (SpiTransaction)t;
        BeanProperty prop = descriptor.getBeanProperty(propertyName);
        if (prop == null) {
            String msg = "Could not find property [" + propertyName + "] on bean " + parentBean.getClass();
            throw new PersistenceException(msg);
        }
        if (prop instanceof BeanPropertyAssocMany) {
            BeanPropertyAssocMany manyProp = (BeanPropertyAssocMany)prop;
            this.saveMany(new SaveManyPropRequest(manyProp, parentBean, (SpiTransaction)t), true);
        } else if (prop instanceof BeanPropertyAssocOne) {
            BeanPropertyAssocOne oneProp = (BeanPropertyAssocOne)prop;
            EntityBean assocBean = oneProp.getValueAsEntityBean(parentBean);
            int depth = oneProp.isOneToOneExported() ? 1 : -1;
            int revertDepth = -1 * depth;
            trans.depth(depth);
            this.saveRecurse(assocBean, t, parentBean, true, false);
            trans.depth(revertDepth);
        } else {
            String msg = "Expecting [" + prop.getFullBeanName() + "] to be a OneToMany, OneToOne, ManyToOne or ManyToMany property?";
            throw new PersistenceException(msg);
        }
    }

    private void saveAssocManyIntersection(SaveManyPropRequest saveManyPropRequest, boolean deleteMissingChildren) {
        IntersectionRow intRow;
        Set additions;
        boolean vanillaCollection;
        BeanPropertyAssocMany prop = saveManyPropRequest.getMany();
        Object value = prop.getValue(saveManyPropRequest.getParentBean());
        if (value == null) {
            return;
        }
        SpiTransaction t = saveManyPropRequest.getTransaction();
        boolean bl = vanillaCollection = !(value instanceof BeanCollection);
        if (vanillaCollection || deleteMissingChildren) {
            this.deleteAssocManyIntersection(saveManyPropRequest.getParentBean(), prop, t, saveManyPropRequest.isPublish());
        }
        Set deletions = null;
        if (saveManyPropRequest.isInsertedParent() || vanillaCollection || deleteMissingChildren) {
            if (value instanceof Map) {
                additions = ((Map)value).values();
            } else if (value instanceof Collection) {
                additions = (Set)value;
            } else {
                String msg = "Unhandled ManyToMany type " + value.getClass().getName() + " for " + prop.getFullBeanName();
                throw new PersistenceException(msg);
            }
            if (!vanillaCollection) {
                ((BeanCollection)value).modifyReset();
            }
        } else {
            BeanCollection manyValue = (BeanCollection)value;
            additions = manyValue.getModifyAdditions();
            deletions = manyValue.getModifyRemovals();
            manyValue.modifyReset();
        }
        t.depth(1);
        if (additions != null && !additions.isEmpty()) {
            t.flushBatch();
            for (Object other : additions) {
                EntityBean otherBean = (EntityBean)other;
                if (deletions != null && deletions.remove(otherBean)) {
                    String m = "Inserting and Deleting same object? " + otherBean;
                    if (t.isLogSummary()) {
                        t.logSummary(m);
                    }
                    logger.warn(m);
                    continue;
                }
                if (!prop.hasImportedId(otherBean)) {
                    String msg = "ManyToMany bean " + otherBean + " does not have an Id value.";
                    throw new PersistenceException(msg);
                }
                intRow = prop.buildManyToManyMapBean(saveManyPropRequest.getParentBean(), otherBean, saveManyPropRequest.isPublish());
                SqlUpdate sqlInsert = intRow.createInsert(this.server);
                this.executeSqlUpdate(sqlInsert, t);
            }
        }
        if (deletions != null && !deletions.isEmpty()) {
            t.flushBatch();
            for (Object other : deletions) {
                EntityBean otherDelete = (EntityBean)other;
                intRow = prop.buildManyToManyMapBean(saveManyPropRequest.getParentBean(), otherDelete, saveManyPropRequest.isPublish());
                SqlUpdate sqlDelete = intRow.createDelete(this.server, false);
                this.executeSqlUpdate(sqlDelete, t);
            }
        }
        t.depth(-1);
    }

    private int deleteAssocManyIntersection(EntityBean bean, BeanPropertyAssocMany<?> many, Transaction t, boolean publish) {
        IntersectionRow intRow = many.buildManyToManyDeleteChildren(bean, publish);
        SqlUpdate sqlDelete = intRow.createDeleteChildren(this.server);
        return this.executeSqlUpdate(sqlDelete, t);
    }

    private void deleteAssocMany(PersistRequestBean<?> request) {
        int i;
        Transaction t = request.getTransaction();
        t.depth(-1);
        BeanDescriptor<?> desc = request.getBeanDescriptor();
        EntityBean parentBean = request.getEntityBean();
        boolean softDelete = request.isSoftDelete();
        BeanPropertyAssocOne<?>[] expOnes = desc.propertiesOneExportedDelete();
        if (expOnes.length > 0) {
            DeleteUnloadedForeignKeys unloaded = null;
            for (i = 0; i < expOnes.length; ++i) {
                BeanPropertyAssocOne<?> prop = expOnes[i];
                if (softDelete && !prop.getTargetDescriptor().isSoftDelete()) continue;
                if (request.isLoadedProperty(prop)) {
                    Object detailBean = prop.getValue(parentBean);
                    if (detailBean == null) continue;
                    this.deleteRecurse((EntityBean)detailBean, t, softDelete);
                    continue;
                }
                if (unloaded == null) {
                    unloaded = new DeleteUnloadedForeignKeys(this.server, request);
                }
                unloaded.add(prop);
            }
            if (unloaded != null) {
                unloaded.queryForeignKeys();
                unloaded.deleteCascade();
            }
        }
        BeanPropertyAssocMany<?>[] manys = desc.propertiesManyDelete();
        for (i = 0; i < manys.length; ++i) {
            Set modifyRemovals;
            Object details;
            if (manys[i].isManyToMany()) {
                if (softDelete) continue;
                this.deleteAssocManyIntersection(parentBean, manys[i], t, request.isPublish());
                continue;
            }
            if (BeanCollection.ModifyListenMode.REMOVALS.equals((Object)manys[i].getModifyListenMode()) && (!softDelete || manys[i].getTargetDescriptor().isSoftDelete()) && (details = manys[i].getValue(parentBean)) instanceof BeanCollection && (modifyRemovals = ((BeanCollection)details).getModifyRemovals()) != null && !modifyRemovals.isEmpty()) {
                for (Object detail : modifyRemovals) {
                    EntityBean detailBean = (EntityBean)detail;
                    if (!manys[i].hasId(detailBean)) continue;
                    this.deleteRecurse(detailBean, t, softDelete);
                }
            }
            this.deleteManyDetails((SpiTransaction)t, desc, parentBean, manys[i], null, softDelete);
        }
        t.depth(1);
    }

    private void deleteManyDetails(SpiTransaction t, BeanDescriptor<?> desc, EntityBean parentBean, BeanPropertyAssocMany<?> many, ArrayList<Object> excludeDetailIds, boolean softDelete) {
        if (many.getCascadeInfo().isDelete()) {
            BeanDescriptor targetDesc = many.getTargetDescriptor();
            if (!softDelete || targetDesc.isSoftDelete()) {
                if (targetDesc.isDeleteRecurseSkippable() && !targetDesc.isBeanCaching()) {
                    IntersectionRow intRow = many.buildManyDeleteChildren(parentBean, excludeDetailIds);
                    SqlUpdate sqlDelete = intRow.createDelete(this.server, softDelete);
                    this.executeSqlUpdate(sqlDelete, t);
                } else {
                    Object parentId = desc.getId(parentBean);
                    List<Object> idsByParentId = many.findIdsByParentId(parentId, null, t, excludeDetailIds);
                    if (!idsByParentId.isEmpty()) {
                        this.deleteChildrenById(t, targetDesc, idsByParentId, softDelete);
                    }
                }
            }
        }
    }

    private void deleteChildrenById(SpiTransaction t, BeanDescriptor<?> targetDesc, List<Object> childIds, boolean softDelete) {
        if (targetDesc.propertiesManyToMany().length > 0) {
            ArrayList refList = new ArrayList(childIds.size());
            for (Object id : childIds) {
                refList.add(targetDesc.createReference(null, id));
            }
            this.deleteList(refList, t, softDelete);
        } else {
            this.delete(targetDesc, null, childIds, t, softDelete);
        }
    }

    private void saveAssocOne(PersistRequestBean<?> request, boolean insertMode) {
        BeanDescriptor<?> desc = request.getBeanDescriptor();
        BeanPropertyAssocOne<?>[] ones = desc.propertiesOneImportedSave();
        for (int i = 0; i < ones.length; ++i) {
            EntityBean detailBean;
            BeanPropertyAssocOne<?> prop = ones[i];
            if (!request.isLoadedProperty(prop) || (detailBean = prop.getValueAsEntityBean(request.getEntityBean())) == null || prop.isSaveRecurseSkippable(detailBean) || prop.isReference(detailBean) || request.isParent(detailBean)) continue;
            Transaction t = request.getTransaction();
            t.depth(-1);
            this.saveRecurse(detailBean, t, null, insertMode, request.isPublish());
            t.depth(1);
        }
    }

    private DeleteUnloadedForeignKeys getDeleteUnloadedForeignKeys(PersistRequestBean<?> request) {
        DeleteUnloadedForeignKeys fkeys = null;
        BeanPropertyAssocOne<?>[] ones = request.getBeanDescriptor().propertiesOneImportedDelete();
        for (int i = 0; i < ones.length; ++i) {
            if (request.isLoadedProperty(ones[i])) continue;
            if (fkeys == null) {
                fkeys = new DeleteUnloadedForeignKeys(this.server, request);
            }
            fkeys.add(ones[i]);
        }
        return fkeys;
    }

    private void deleteAssocOne(PersistRequestBean<?> request) {
        BeanPropertyAssocOne<?>[] ones = request.getBeanDescriptor().propertiesOneImportedDelete();
        for (int i = 0; i < ones.length; ++i) {
            EntityBean detail;
            Object detailBean;
            BeanPropertyAssocOne<?> prop = ones[i];
            if (!request.isLoadedProperty(prop) || (detailBean = prop.getValue(request.getEntityBean())) == null || !prop.hasId(detail = (EntityBean)detailBean)) continue;
            this.deleteRecurse(detail, request.getTransaction(), request.isSoftDelete());
        }
    }

    private void setIdGenValue(PersistRequestBean<?> request) {
        BeanDescriptor<?> desc = request.getBeanDescriptor();
        if (!desc.isUseIdGenerator()) {
            return;
        }
        BeanProperty idProp = desc.getIdProperty();
        if (idProp == null || idProp.isEmbedded()) {
            return;
        }
        EntityBean bean = request.getEntityBean();
        Object uid = idProp.getValue(bean);
        if (DmlUtil.isNullOrZero(uid)) {
            Object nextId = desc.nextId(request.getTransaction());
            desc.convertSetId(nextId, bean);
        }
    }

    private <T> PersistRequestBean<T> createRequest(T bean, Transaction t, PersistRequest.Type type) {
        return this.createRequestInternal(bean, t, type, false, false);
    }

    private <T> PersistRequestBean<T> createPublishRequest(T bean, Transaction t, PersistRequest.Type type, boolean publish) {
        return this.createRequestInternal(bean, t, type, false, publish);
    }

    private <T> PersistRequestBean<T> createRequestInternal(T bean, Transaction t, PersistRequest.Type type, boolean saveRecurse, boolean publish) {
        BeanManager<T> mgr = this.getBeanManager(bean);
        if (mgr == null) {
            throw new PersistenceException(this.errNotRegistered(bean.getClass()));
        }
        return this.createRequest(bean, t, null, mgr, type, saveRecurse, publish);
    }

    private <T> PersistRequestBean<T> createRequestRecurse(T bean, Transaction t, Object parentBean, boolean insertMode, boolean publish) {
        BeanManager<T> mgr = this.getBeanManager(bean);
        if (mgr == null) {
            throw new PersistenceException(this.errNotRegistered(bean.getClass()));
        }
        BeanDescriptor<T> desc = mgr.getBeanDescriptor();
        EntityBean entityBean = (EntityBean)bean;
        PersistRequest.Type type = publish ? (entityBean._ebean_getIntercept().isNew() ? PersistRequest.Type.INSERT : PersistRequest.Type.UPDATE) : (desc.isInsertMode(entityBean._ebean_getIntercept(), insertMode) ? PersistRequest.Type.INSERT : PersistRequest.Type.UPDATE);
        return this.createRequest(bean, t, parentBean, mgr, type, true, publish);
    }

    private <T> PersistRequestBean<T> createRequest(T bean, Transaction t, Object parentBean, BeanManager<?> mgr, PersistRequest.Type type, boolean saveRecurse, boolean publish) {
        if (type == PersistRequest.Type.DELETE_PERMANENT) {
            type = PersistRequest.Type.DELETE;
        } else if (type == PersistRequest.Type.DELETE && mgr.getBeanDescriptor().isSoftDelete()) {
            type = PersistRequest.Type.SOFT_DELETE;
        }
        return new PersistRequestBean<T>(this.server, bean, parentBean, mgr, (SpiTransaction)t, this.persistExecute, type, saveRecurse, publish);
    }

    private String errNotRegistered(Class<?> beanClass) {
        String msg = "The type [" + beanClass + "] is not a registered entity?";
        msg = msg + " If you don't explicitly list the entity classes to use Ebean will search for them in the classpath.";
        msg = msg + " If the entity is in a Jar check the ebean.search.jars property in ebean.properties file or check ServerConfig.addJar().";
        return msg;
    }

    private <T> BeanManager<T> getBeanManager(T bean) {
        return this.beanDescriptorManager.getBeanManager(bean.getClass());
    }

    private static class SaveManyPropRequest {
        private final boolean insertedParent;
        private final BeanPropertyAssocMany<?> many;
        private final EntityBean parentBean;
        private final SpiTransaction transaction;
        private final boolean cascade;
        private final boolean deleteMissingChildren;
        private final boolean publish;

        private SaveManyPropRequest(boolean insertedParent, BeanPropertyAssocMany<?> many, EntityBean parentBean, PersistRequestBean<?> request) {
            this.insertedParent = insertedParent;
            this.many = many;
            this.cascade = many.getCascadeInfo().isSave();
            this.parentBean = parentBean;
            this.transaction = request.getTransaction();
            this.deleteMissingChildren = request.isDeleteMissingChildren();
            this.publish = request.isPublish();
        }

        private SaveManyPropRequest(BeanPropertyAssocMany<?> many, EntityBean parentBean, SpiTransaction t) {
            this.insertedParent = false;
            this.many = many;
            this.parentBean = parentBean;
            this.transaction = t;
            this.cascade = true;
            this.deleteMissingChildren = false;
            this.publish = false;
        }

        public boolean isSaveIntersection() {
            return this.transaction.isSaveAssocManyIntersection(this.many.getIntersectionTableJoin().getTable(), this.many.getBeanDescriptor().getName());
        }

        private Object getValue() {
            return this.many.getValue(this.parentBean);
        }

        private boolean isModifyListenMode() {
            return BeanCollection.ModifyListenMode.REMOVALS.equals((Object)this.many.getModifyListenMode());
        }

        private boolean isDeleteMissingChildren() {
            return this.deleteMissingChildren;
        }

        private boolean isInsertedParent() {
            return this.insertedParent;
        }

        private BeanPropertyAssocMany<?> getMany() {
            return this.many;
        }

        private EntityBean getParentBean() {
            return this.parentBean;
        }

        private SpiTransaction getTransaction() {
            return this.transaction;
        }

        private boolean isCascade() {
            return this.cascade;
        }

        public void modifyListenReset(BeanCollection<?> c) {
            if (this.insertedParent) {
                c.setModifyListening(this.many.getModifyListenMode());
            }
            c.modifyReset();
        }

        public boolean isPublish() {
            return this.publish;
        }

        private void resetModifyState() {
            Object details = this.getValue();
            if (details instanceof BeanCollection) {
                this.modifyListenReset((BeanCollection)details);
            }
        }
    }

    class DraftHandler<T> {
        final BeanDescriptor<T> desc;
        final Transaction transaction;
        final BeanProperty draftDirty;
        final List<T> draftUpdates = new ArrayList<T>();
        Object id;
        boolean insert;
        Map<?, T> destBeans;

        DraftHandler(BeanDescriptor<T> desc, Transaction transaction) {
            this.desc = desc;
            this.transaction = transaction;
            this.draftDirty = desc.getDraftDirty();
        }

        List<T> getDrafts() {
            return this.draftUpdates;
        }

        void resetDraft(T draftBean) {
            if (this.desc.draftReset(draftBean)) {
                this.draftUpdates.add(draftBean);
            }
        }

        void updateDrafts(Transaction transaction, BeanManager<T> mgr) {
            if (!this.draftUpdates.isEmpty()) {
                PUB.debug("publish - update dirty status on [{}] drafts", (Object)this.draftUpdates.size());
                for (T draftUpdate : this.draftUpdates) {
                    DefaultPersister.this.update(DefaultPersister.this.createRequest(draftUpdate, transaction, null, mgr, PersistRequest.Type.UPDATE, false, false));
                }
            }
        }

        List<T> fetchSourceBeans(Query<T> query, boolean asDraft) {
            this.desc.draftQueryOptimise(query);
            if (asDraft) {
                query.asDraft();
            }
            return DefaultPersister.this.server.findList(query, this.transaction);
        }

        void fetchDestinationBeans(List<T> sourceBeans, boolean asDraft) {
            List ids = DefaultPersister.this.getBeanIds(this.desc, sourceBeans);
            Query<T> destQuery = DefaultPersister.this.server.find(this.desc.getBeanType()).where().idIn(ids).query();
            if (asDraft) {
                destQuery.asDraft();
            }
            this.desc.draftQueryOptimise(destQuery);
            this.destBeans = DefaultPersister.this.server.findMap(destQuery, this.transaction);
        }

        T publishToDestinationBean(T sourceBean) {
            this.id = this.desc.getBeanId(sourceBean);
            T destBean = this.destBeans.get(this.id);
            this.insert = destBean == null;
            return this.desc.publish(sourceBean, destBean);
        }

        boolean isInsert() {
            return this.insert;
        }

        Object getId() {
            return this.id;
        }
    }
}

