/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.deploy.generatedproperty;

import com.avaje.ebean.config.ClassLoadConfig;
import com.avaje.ebeaninternal.server.deploy.generatedproperty.GeneratedInsertDate;
import com.avaje.ebeaninternal.server.deploy.generatedproperty.GeneratedInsertJavaTime;
import com.avaje.ebeaninternal.server.deploy.generatedproperty.GeneratedInsertJodaTime;
import com.avaje.ebeaninternal.server.deploy.generatedproperty.GeneratedInsertLong;
import com.avaje.ebeaninternal.server.deploy.generatedproperty.GeneratedInsertTimestamp;
import com.avaje.ebeaninternal.server.deploy.generatedproperty.GeneratedProperty;
import com.avaje.ebeaninternal.server.deploy.meta.DeployBeanProperty;
import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.PersistenceException;
import org.joda.time.DateTime;
import org.joda.time.LocalDateTime;

public class InsertTimestampFactory {
    final GeneratedInsertLong longTime = new GeneratedInsertLong();
    final Map<Class<?>, GeneratedProperty> map = new HashMap();

    public InsertTimestampFactory(ClassLoadConfig classLoadConfig) {
        this.map.put(Timestamp.class, new GeneratedInsertTimestamp());
        this.map.put(Date.class, new GeneratedInsertDate());
        this.map.put(Long.class, this.longTime);
        this.map.put(Long.TYPE, this.longTime);
        if (classLoadConfig.isJavaTimePresent()) {
            this.map.put(java.time.LocalDateTime.class, new GeneratedInsertJavaTime.LocalDT());
            this.map.put(OffsetDateTime.class, new GeneratedInsertJavaTime.OffsetDT());
            this.map.put(ZonedDateTime.class, new GeneratedInsertJavaTime.ZonedDT());
        }
        if (classLoadConfig.isJodaTimePresent()) {
            this.map.put(LocalDateTime.class, new GeneratedInsertJodaTime.LocalDT());
            this.map.put(DateTime.class, new GeneratedInsertJodaTime.DateTimeDT());
        }
    }

    public void setInsertTimestamp(DeployBeanProperty property) {
        property.setGeneratedProperty(this.createInsertTimestamp(property));
    }

    public GeneratedProperty createInsertTimestamp(DeployBeanProperty property) {
        Class<?> propType = property.getPropertyType();
        GeneratedProperty generatedProperty = this.map.get(propType);
        if (generatedProperty != null) {
            return generatedProperty;
        }
        throw new PersistenceException("Generated Insert Timestamp not supported on " + propType.getName());
    }
}

