/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.deploy.generatedproperty;

import com.avaje.ebean.config.ClassLoadConfig;
import com.avaje.ebean.config.CurrentUserProvider;
import com.avaje.ebean.config.ServerConfig;
import com.avaje.ebeaninternal.server.deploy.generatedproperty.CounterFactory;
import com.avaje.ebeaninternal.server.deploy.generatedproperty.GeneratedWhoCreated;
import com.avaje.ebeaninternal.server.deploy.generatedproperty.GeneratedWhoModified;
import com.avaje.ebeaninternal.server.deploy.generatedproperty.InsertTimestampFactory;
import com.avaje.ebeaninternal.server.deploy.generatedproperty.UpdateTimestampFactory;
import com.avaje.ebeaninternal.server.deploy.meta.DeployBeanProperty;
import java.math.BigDecimal;
import java.util.HashSet;

public class GeneratedPropertyFactory {
    private final CounterFactory counterFactory = new CounterFactory();
    private final InsertTimestampFactory insertFactory;
    private final UpdateTimestampFactory updateFactory;
    private final HashSet<String> numberTypes = new HashSet();
    private final GeneratedWhoModified generatedWhoModified;
    private final GeneratedWhoCreated generatedWhoCreated;
    private final ClassLoadConfig classLoadConfig;

    public GeneratedPropertyFactory(ServerConfig serverConfig) {
        this.classLoadConfig = serverConfig.getClassLoadConfig();
        this.insertFactory = new InsertTimestampFactory(this.classLoadConfig);
        this.updateFactory = new UpdateTimestampFactory(this.classLoadConfig);
        CurrentUserProvider currentUserProvider = serverConfig.getCurrentUserProvider();
        if (currentUserProvider != null) {
            this.generatedWhoCreated = new GeneratedWhoCreated(currentUserProvider);
            this.generatedWhoModified = new GeneratedWhoModified(currentUserProvider);
        } else {
            this.generatedWhoCreated = null;
            this.generatedWhoModified = null;
        }
        this.numberTypes.add(Integer.class.getName());
        this.numberTypes.add(Integer.TYPE.getName());
        this.numberTypes.add(Long.class.getName());
        this.numberTypes.add(Long.TYPE.getName());
        this.numberTypes.add(Short.class.getName());
        this.numberTypes.add(Short.TYPE.getName());
        this.numberTypes.add(Double.class.getName());
        this.numberTypes.add(Double.TYPE.getName());
        this.numberTypes.add(BigDecimal.class.getName());
    }

    public ClassLoadConfig getClassLoadConfig() {
        return this.classLoadConfig;
    }

    private boolean isNumberType(String typeClassName) {
        return this.numberTypes.contains(typeClassName);
    }

    public void setVersion(DeployBeanProperty property) {
        if (this.isNumberType(property.getPropertyType().getName())) {
            this.setCounter(property);
        } else {
            this.setUpdateTimestamp(property);
        }
    }

    public void setCounter(DeployBeanProperty property) {
        this.counterFactory.setCounter(property);
    }

    public void setInsertTimestamp(DeployBeanProperty property) {
        this.insertFactory.setInsertTimestamp(property);
    }

    public void setUpdateTimestamp(DeployBeanProperty property) {
        this.updateFactory.setUpdateTimestamp(property);
    }

    public void setWhoCreated(DeployBeanProperty property) {
        if (this.generatedWhoCreated == null) {
            throw new IllegalStateException("No CurrentUserProvider has been set so @WhoCreated is not supported");
        }
        property.setGeneratedProperty(this.generatedWhoCreated);
    }

    public void setWhoModified(DeployBeanProperty property) {
        if (this.generatedWhoModified == null) {
            throw new IllegalStateException("No CurrentUserProvider has been set so @WhoModified is not supported");
        }
        property.setGeneratedProperty(this.generatedWhoModified);
    }
}

