/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.deploy;

import com.avaje.ebeaninternal.server.core.InternString;
import com.avaje.ebeaninternal.server.deploy.meta.DeployTableJoinColumn;

public class TableJoinColumn {
    private final String localDbColumn;
    private final String foreignDbColumn;
    private final boolean insertable;
    private final boolean updateable;
    private final int queryHash;

    public TableJoinColumn(DeployTableJoinColumn deploy) {
        this.localDbColumn = InternString.intern(deploy.getLocalDbColumn());
        this.foreignDbColumn = InternString.intern(deploy.getForeignDbColumn());
        this.insertable = deploy.isInsertable();
        this.updateable = deploy.isUpdateable();
        this.queryHash = this.hash();
    }

    int hash() {
        int result = this.localDbColumn != null ? this.localDbColumn.hashCode() : 0;
        result = 31 * result + (this.foreignDbColumn != null ? this.foreignDbColumn.hashCode() : 0);
        result = 31 * result + (this.insertable ? 1 : 0);
        result = 31 * result + (this.updateable ? 1 : 0);
        return result;
    }

    public int hashCode() {
        return this.queryHash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableJoinColumn that = (TableJoinColumn)o;
        if (this.insertable != that.insertable) {
            return false;
        }
        if (this.updateable != that.updateable) {
            return false;
        }
        if (!this.localDbColumn.equals(that.localDbColumn)) {
            return false;
        }
        return this.foreignDbColumn.equals(that.foreignDbColumn);
    }

    public String toString() {
        return this.localDbColumn + " = " + this.foreignDbColumn;
    }

    public int queryHash() {
        return this.queryHash;
    }

    public String getForeignDbColumn() {
        return this.foreignDbColumn;
    }

    public String getLocalDbColumn() {
        return this.localDbColumn;
    }

    public boolean isInsertable() {
        return this.insertable;
    }

    public boolean isUpdateable() {
        return this.updateable;
    }
}

