/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.deploy;

import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebeaninternal.server.core.InternString;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.BeanProperty;
import com.avaje.ebeaninternal.server.deploy.DbReadContext;
import com.avaje.ebeaninternal.server.deploy.InheritInfoVisitor;
import com.avaje.ebeaninternal.server.deploy.id.IdBinder;
import com.avaje.ebeaninternal.server.deploy.parse.DeployInheritInfo;
import com.avaje.ebeaninternal.server.query.SqlTreeProperties;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.persistence.PersistenceException;

public class InheritInfo {
    private final String discriminatorStringValue;
    private final Object discriminatorValue;
    private final String discriminatorColumn;
    private final int discriminatorType;
    private final int discriminatorLength;
    private final String where;
    private final Class<?> type;
    private final ArrayList<InheritInfo> children = new ArrayList();
    private final HashMap<String, InheritInfo> discMap;
    private final HashMap<String, InheritInfo> typeMap;
    private final InheritInfo parent;
    private final InheritInfo root;
    private BeanDescriptor<?> descriptor;

    public InheritInfo(InheritInfo r, InheritInfo parent, DeployInheritInfo deploy) {
        this.parent = parent;
        this.type = deploy.getType();
        this.discriminatorColumn = InternString.intern(deploy.getDiscriminatorColumn(parent));
        this.discriminatorValue = deploy.getDiscriminatorObjectValue();
        this.discriminatorStringValue = deploy.getDiscriminatorStringValue();
        this.discriminatorType = deploy.getDiscriminatorType(parent);
        this.discriminatorLength = deploy.getDiscriminatorLength(parent);
        this.where = InternString.intern(deploy.getWhere());
        if (r == null) {
            this.root = this;
            this.discMap = new HashMap();
            this.typeMap = new HashMap();
            this.registerWithRoot(this);
        } else {
            this.root = r;
            this.discMap = null;
            this.typeMap = null;
            this.root.registerWithRoot(this);
        }
    }

    public void visitChildren(InheritInfoVisitor visitor) {
        for (int i = 0; i < this.children.size(); ++i) {
            InheritInfo child = this.children.get(i);
            visitor.visit(child);
            child.visitChildren(visitor);
        }
    }

    public boolean isSaveRecurseSkippable() {
        return this.root.isNodeSaveRecurseSkippable();
    }

    private boolean isNodeSaveRecurseSkippable() {
        if (!this.descriptor.isSaveRecurseSkippable()) {
            return false;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            InheritInfo child = this.children.get(i);
            if (child.isNodeSaveRecurseSkippable()) continue;
            return false;
        }
        return true;
    }

    public boolean isDeleteRecurseSkippable() {
        return this.root.isNodeDeleteRecurseSkippable();
    }

    private boolean isNodeDeleteRecurseSkippable() {
        if (!this.descriptor.isDeleteRecurseSkippable()) {
            return false;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            InheritInfo child = this.children.get(i);
            if (child.isNodeDeleteRecurseSkippable()) continue;
            return false;
        }
        return true;
    }

    public void setDescriptor(BeanDescriptor<?> descriptor) {
        this.descriptor = descriptor;
    }

    public BeanDescriptor<?> getBeanDescriptor() {
        return this.descriptor;
    }

    public BeanProperty[] localProperties() {
        return this.descriptor.propertiesLocal();
    }

    public BeanProperty findSubTypeProperty(String propertyName) {
        int x = this.children.size();
        for (int i = 0; i < x; ++i) {
            InheritInfo childInfo = this.children.get(i);
            BeanProperty prop = childInfo.getBeanDescriptor().findBeanProperty(propertyName);
            if (prop == null) continue;
            return prop;
        }
        return null;
    }

    public void addChildrenProperties(SqlTreeProperties selectProps) {
        int x = this.children.size();
        for (int i = 0; i < x; ++i) {
            InheritInfo childInfo = this.children.get(i);
            selectProps.add(childInfo.descriptor.propertiesLocal());
            childInfo.addChildrenProperties(selectProps);
        }
    }

    public InheritInfo readType(DbReadContext ctx) throws SQLException {
        String discValue = ctx.getDataReader().getString();
        return this.readType(discValue);
    }

    public InheritInfo readType(String discValue) {
        if (discValue == null) {
            return null;
        }
        InheritInfo typeInfo = this.root.getType(discValue);
        if (typeInfo == null) {
            throw new PersistenceException("Inheritance type for discriminator value [" + discValue + "] was not found?");
        }
        return typeInfo;
    }

    public InheritInfo readType(Class<?> beanType) {
        InheritInfo typeInfo = this.root.getTypeByClass(beanType);
        if (typeInfo == null) {
            throw new PersistenceException("Inheritance type for bean type [" + beanType.getName() + "] was not found?");
        }
        return typeInfo;
    }

    public EntityBean createEntityBean() {
        return this.descriptor.createEntityBean();
    }

    public IdBinder getIdBinder() {
        return this.descriptor.getIdBinder();
    }

    public Class<?> getType() {
        return this.type;
    }

    public InheritInfo getRoot() {
        return this.root;
    }

    public InheritInfo getParent() {
        return this.parent;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public InheritInfo getType(String discValue) {
        return this.discMap.get(discValue);
    }

    private InheritInfo getTypeByClass(Class<?> beanType) {
        return this.typeMap.get(beanType.getName());
    }

    private void registerWithRoot(InheritInfo info) {
        if (info.getDiscriminatorStringValue() != null) {
            String stringDiscValue = info.getDiscriminatorStringValue();
            this.discMap.put(stringDiscValue, info);
        }
        this.typeMap.put(info.getType().getName(), info);
    }

    public void addChild(InheritInfo childInfo) {
        this.children.add(childInfo);
    }

    public String getWhere() {
        return this.where;
    }

    public String getDiscriminatorColumn() {
        return this.discriminatorColumn;
    }

    public int getDiscriminatorType() {
        return this.discriminatorType;
    }

    public int getDiscriminatorLength() {
        return this.discriminatorLength;
    }

    public String getDiscriminatorStringValue() {
        return this.discriminatorStringValue;
    }

    public Object getDiscriminatorValue() {
        return this.discriminatorValue;
    }

    public String toString() {
        return "InheritInfo[" + this.type.getName() + "] disc[" + this.discriminatorStringValue + "]";
    }
}

