/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.deploy;

import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebean.text.PathProperties;
import com.avaje.ebeaninternal.server.core.InternString;
import com.avaje.ebeaninternal.server.deploy.BeanCascadeInfo;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.BeanProperty;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssocOne;
import com.avaje.ebeaninternal.server.deploy.BeanTable;
import com.avaje.ebeaninternal.server.deploy.DbSqlContext;
import com.avaje.ebeaninternal.server.deploy.InheritInfo;
import com.avaje.ebeaninternal.server.deploy.TableJoin;
import com.avaje.ebeaninternal.server.deploy.TableJoinColumn;
import com.avaje.ebeaninternal.server.deploy.id.IdBinder;
import com.avaje.ebeaninternal.server.deploy.id.ImportedId;
import com.avaje.ebeaninternal.server.deploy.id.ImportedIdEmbedded;
import com.avaje.ebeaninternal.server.deploy.id.ImportedIdSimple;
import com.avaje.ebeaninternal.server.deploy.meta.DeployBeanPropertyAssoc;
import com.avaje.ebeaninternal.server.el.ElPropertyChainBuilder;
import com.avaje.ebeaninternal.server.el.ElPropertyValue;
import com.avaje.ebeaninternal.server.query.SplitName;
import com.avaje.ebeaninternal.server.query.SqlJoinType;
import com.avaje.ebeanservice.docstore.api.mapping.DocMappingBuilder;
import com.avaje.ebeanservice.docstore.api.mapping.DocPropertyMapping;
import com.avaje.ebeanservice.docstore.api.mapping.DocPropertyType;
import com.avaje.ebeanservice.docstore.api.support.DocStructure;
import java.util.ArrayList;
import javax.persistence.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BeanPropertyAssoc<T>
extends BeanProperty {
    private static final Logger logger = LoggerFactory.getLogger(BeanPropertyAssoc.class);
    BeanDescriptor<T> targetDescriptor;
    IdBinder targetIdBinder;
    InheritInfo targetInheritInfo;
    String targetIdProperty;
    final BeanCascadeInfo cascadeInfo;
    final TableJoin tableJoin;
    final Class<T> targetType;
    final BeanTable beanTable;
    final String mappedBy;
    final String docStoreDoc;
    final String extraWhere;
    boolean saveRecurseSkippable;

    public BeanPropertyAssoc(BeanDescriptor<?> descriptor, DeployBeanPropertyAssoc<T> deploy) {
        super(descriptor, deploy);
        this.extraWhere = InternString.intern(deploy.getExtraWhere());
        this.beanTable = deploy.getBeanTable();
        this.mappedBy = InternString.intern(deploy.getMappedBy());
        this.docStoreDoc = deploy.getDocStoreDoc();
        this.tableJoin = new TableJoin(deploy.getTableJoin());
        this.targetType = deploy.getTargetType();
        this.cascadeInfo = deploy.getCascadeInfo();
    }

    @Override
    public void initialise() {
        this.targetDescriptor = this.descriptor.getBeanDescriptor(this.targetType);
        if (!this.isTransient) {
            this.targetIdBinder = this.targetDescriptor.getIdBinder();
            this.targetInheritInfo = this.targetDescriptor.getInheritInfo();
            this.saveRecurseSkippable = this.targetDescriptor.isSaveRecurseSkippable();
            if (!this.targetIdBinder.isComplexId()) {
                this.targetIdProperty = this.targetIdBinder.getIdProperty();
            }
        }
    }

    protected ElPropertyValue createElPropertyValue(String propName, String remainder, ElPropertyChainBuilder chain, boolean propertyDeploy) {
        BeanDescriptor<T> embDesc = this.getTargetDescriptor();
        if (chain == null) {
            chain = new ElPropertyChainBuilder(this.isEmbedded(), propName);
        }
        chain.add(this);
        if (this.containsMany()) {
            chain.setContainsMany();
        }
        return embDesc.buildElGetValue(remainder, chain, propertyDeploy);
    }

    public SqlJoinType addJoin(SqlJoinType joinType, String prefix, DbSqlContext ctx) {
        return this.tableJoin.addJoin(joinType, prefix, ctx);
    }

    public SqlJoinType addJoin(SqlJoinType joinType, String a1, String a2, DbSqlContext ctx) {
        return this.tableJoin.addJoin(joinType, a1, a2, ctx);
    }

    @Override
    public boolean isScalar() {
        return false;
    }

    public String getMappedBy() {
        return this.mappedBy;
    }

    public String getTargetIdProperty() {
        return this.targetIdProperty;
    }

    public BeanDescriptor<T> getTargetDescriptor() {
        return this.targetDescriptor;
    }

    public boolean isSaveRecurseSkippable(Object bean) {
        return this.saveRecurseSkippable && bean instanceof EntityBean && !((EntityBean)bean)._ebean_getIntercept().isNewOrDirty();
    }

    public boolean isSaveRecurseSkippable() {
        return this.saveRecurseSkippable;
    }

    public boolean hasId(EntityBean bean) {
        Object value;
        BeanDescriptor<T> targetDesc = this.getTargetDescriptor();
        BeanProperty idProp = targetDesc.getIdProperty();
        return idProp == null || (value = idProp.getValue(bean)) != null;
    }

    public Class<?> getTargetType() {
        return this.targetType;
    }

    public String getExtraWhere() {
        return this.extraWhere;
    }

    public String getDocStoreDoc() {
        return this.docStoreDoc;
    }

    @Override
    public void docStoreInclude(boolean includeByDefault, DocStructure docStructure) {
        String embeddedDoc = this.getDocStoreDoc();
        if (embeddedDoc == null) {
            if (includeByDefault) {
                this.docStoreIncludeByDefault(docStructure.doc());
            }
        } else {
            if (embeddedDoc.isEmpty()) {
                embeddedDoc = "*";
            }
            PathProperties embDoc = PathProperties.parse(embeddedDoc);
            docStructure.addNested(this.name, embDoc);
        }
    }

    protected void docStoreIncludeByDefault(PathProperties pathProps) {
        pathProps.addToPath(null, this.name);
    }

    @Override
    public void docStoreMapping(DocMappingBuilder mapping, String prefix) {
        if (mapping.includesPath(prefix, this.name)) {
            String fullName = SplitName.add(prefix, this.name);
            DocPropertyType type = this.isMany() ? DocPropertyType.LIST : DocPropertyType.OBJECT;
            DocPropertyMapping nested = new DocPropertyMapping(this.name, type);
            mapping.push(nested);
            this.targetDescriptor.docStoreMapping(mapping, fullName);
            mapping.pop();
            if (!nested.getChildren().isEmpty()) {
                mapping.add(nested);
            }
        }
    }

    public boolean isUpdateable() {
        return this.tableJoin.columns().length <= 0 || this.tableJoin.columns()[0].isUpdateable();
    }

    public boolean isInsertable() {
        return this.tableJoin.columns().length <= 0 || this.tableJoin.columns()[0].isInsertable();
    }

    public TableJoin getTableJoin() {
        return this.tableJoin;
    }

    public BeanCascadeInfo getCascadeInfo() {
        return this.cascadeInfo;
    }

    protected ImportedId createImportedId(BeanPropertyAssoc<?> owner, BeanDescriptor<?> target, TableJoin join) {
        BeanProperty idProp = target.getIdProperty();
        BeanProperty[] others = target.propertiesBaseScalar();
        if (this.descriptor.isSqlSelectBased()) {
            String dbColumn = owner.getDbColumn();
            return new ImportedIdSimple(owner, dbColumn, idProp, 0);
        }
        TableJoinColumn[] cols = join.columns();
        if (idProp == null) {
            return null;
        }
        if (!idProp.isEmbedded()) {
            if (cols.length != 1) {
                String msg = "No Imported Id column for [" + idProp + "] in table [" + join.getTable() + "]";
                logger.error(msg);
                return null;
            }
            BeanProperty[] idProps = new BeanProperty[]{idProp};
            return this.createImportedScalar(owner, cols[0], idProps, others);
        }
        BeanPropertyAssocOne embProp = (BeanPropertyAssocOne)idProp;
        BeanProperty[] embBaseProps = embProp.getTargetDescriptor().propertiesBaseScalar();
        ImportedIdSimple[] scalars = this.createImportedList(owner, cols, embBaseProps, others);
        return new ImportedIdEmbedded(owner, embProp, scalars);
    }

    private ImportedIdSimple[] createImportedList(BeanPropertyAssoc<?> owner, TableJoinColumn[] cols, BeanProperty[] props, BeanProperty[] others) {
        ArrayList<ImportedIdSimple> list = new ArrayList<ImportedIdSimple>();
        for (int i = 0; i < cols.length; ++i) {
            list.add(this.createImportedScalar(owner, cols[i], props, others));
        }
        return ImportedIdSimple.sort(list);
    }

    private ImportedIdSimple createImportedScalar(BeanPropertyAssoc<?> owner, TableJoinColumn col, BeanProperty[] props, BeanProperty[] others) {
        int j;
        String matchColumn = col.getForeignDbColumn();
        String localColumn = col.getLocalDbColumn();
        for (j = 0; j < props.length; ++j) {
            if (!props[j].getDbColumn().equalsIgnoreCase(matchColumn)) continue;
            return new ImportedIdSimple(owner, localColumn, props[j], j);
        }
        for (j = 0; j < others.length; ++j) {
            if (!others[j].getDbColumn().equalsIgnoreCase(matchColumn)) continue;
            return new ImportedIdSimple(owner, localColumn, others[j], j + props.length);
        }
        String msg = "Error with the Join on [" + this.getFullBeanName() + "]. Could not find the local match for [" + matchColumn + "] " + " Perhaps an error in a @JoinColumn";
        throw new PersistenceException(msg);
    }
}

