/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.cache;

import com.avaje.ebean.annotation.CacheTuning;
import com.avaje.ebean.cache.ServerCache;
import com.avaje.ebean.cache.ServerCacheFactory;
import com.avaje.ebean.cache.ServerCacheOptions;
import com.avaje.ebean.cache.ServerCacheType;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultCacheHolder {
    private final ConcurrentHashMap<String, ServerCache> concMap = new ConcurrentHashMap();
    private final HashMap<String, ServerCache> synchMap = new HashMap();
    private final Object monitor = new Object();
    private final ServerCacheFactory cacheFactory;
    private final ServerCacheOptions defaultOptions;
    private final boolean useBeanTuning;

    public DefaultCacheHolder(ServerCacheFactory cacheFactory, ServerCacheOptions defaultOptions, boolean useBeanTuning) {
        this.cacheFactory = cacheFactory;
        this.defaultOptions = defaultOptions;
        this.useBeanTuning = useBeanTuning;
    }

    public ServerCacheOptions getDefaultOptions() {
        return this.defaultOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerCache getCache(String cacheKey, ServerCacheType type) {
        ServerCache cache = this.concMap.get(cacheKey);
        if (cache != null) {
            return cache;
        }
        Object object = this.monitor;
        synchronized (object) {
            cache = this.synchMap.get(cacheKey);
            if (cache == null) {
                ServerCacheOptions options = this.getCacheOptions(cacheKey);
                cache = this.cacheFactory.createCache(type, cacheKey, options);
                this.synchMap.put(cacheKey, cache);
                this.concMap.put(cacheKey, cache);
            }
            return cache;
        }
    }

    public void clearCache(String cacheKey) {
        ServerCache cache = this.concMap.get(cacheKey);
        if (cache != null) {
            cache.clear();
        }
    }

    public boolean isCaching(String beanType) {
        return this.concMap.containsKey(beanType);
    }

    public void clearAll() {
        for (ServerCache serverCache : this.concMap.values()) {
            serverCache.clear();
        }
    }

    private ServerCacheOptions getCacheOptions(String beanType) {
        if (this.useBeanTuning) {
            try {
                Class<?> cls = Class.forName(beanType);
                CacheTuning cacheTuning = cls.getAnnotation(CacheTuning.class);
                if (cacheTuning != null) {
                    ServerCacheOptions o = new ServerCacheOptions(cacheTuning);
                    o.applyDefaults(this.defaultOptions);
                    return o;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return this.defaultOptions.copy();
    }
}

