/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.autotune.service;

import com.avaje.ebeaninternal.api.SpiQuery;
import com.avaje.ebeaninternal.server.autotune.model.Origin;
import com.avaje.ebeaninternal.server.querydefn.OrmQueryDetail;
import com.avaje.ebeaninternal.server.querydefn.OrmQueryDetailParser;
import java.io.Serializable;

public class TunedQueryInfo
implements Serializable {
    private final Origin origin;
    private final OrmQueryDetail tunedDetail;

    public TunedQueryInfo(Origin origin) {
        this.origin = origin;
        this.tunedDetail = new OrmQueryDetailParser(origin.getDetail()).parse();
    }

    public Origin getOrigin() {
        return this.origin;
    }

    public OrmQueryDetail getTunedDetail() {
        return this.tunedDetail;
    }

    public boolean tuneQuery(SpiQuery<?> query) {
        boolean tuned;
        if (this.tunedDetail == null) {
            return false;
        }
        if (query.isDetailEmpty()) {
            tuned = true;
            query.setDetail(this.tunedDetail.copy());
        } else {
            tuned = query.tuneFetchProperties(this.tunedDetail);
        }
        if (tuned) {
            query.setAutoTuned(true);
        }
        return tuned;
    }

    public String toString() {
        return this.tunedDetail.toString();
    }
}

