/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.autotune.service;

import com.avaje.ebean.config.AutoTuneConfig;
import com.avaje.ebean.config.ServerConfig;
import com.avaje.ebeaninternal.api.SpiEbeanServer;
import com.avaje.ebeaninternal.api.SpiQuery;
import com.avaje.ebeaninternal.server.autotune.AutoTuneCollection;
import com.avaje.ebeaninternal.server.autotune.AutoTuneService;
import com.avaje.ebeaninternal.server.autotune.model.Autotune;
import com.avaje.ebeaninternal.server.autotune.model.Origin;
import com.avaje.ebeaninternal.server.autotune.service.AutoTuneAllCollection;
import com.avaje.ebeaninternal.server.autotune.service.AutoTuneDiffCollection;
import com.avaje.ebeaninternal.server.autotune.service.AutoTuneXmlReader;
import com.avaje.ebeaninternal.server.autotune.service.AutoTuneXmlWriter;
import com.avaje.ebeaninternal.server.autotune.service.BaseQueryTuner;
import com.avaje.ebeaninternal.server.autotune.service.ProfileManager;
import java.io.File;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAutoTuneService
implements AutoTuneService {
    private static final Logger logger = LoggerFactory.getLogger(DefaultAutoTuneService.class);
    private final SpiEbeanServer server;
    private final long defaultGarbageCollectionWait;
    private final boolean skipGarbageCollectionOnShutdown;
    private final boolean skipProfileReportingOnShutdown;
    private final BaseQueryTuner queryTuner;
    private final ProfileManager profileManager;
    private final boolean profiling;
    private final boolean queryTuning;
    private final String tuningFile;
    private final String profilingFile;
    private final String serverName;
    private final int profilingUpdateFrequency;
    private long runtimeChangeCount;

    public DefaultAutoTuneService(SpiEbeanServer server, ServerConfig serverConfig) {
        AutoTuneConfig config = serverConfig.getAutoTuneConfig();
        this.server = server;
        this.queryTuning = config.isQueryTuning();
        this.profiling = config.isProfiling();
        this.tuningFile = config.getQueryTuningFile();
        this.profilingFile = config.getProfilingFile();
        this.profilingUpdateFrequency = config.getProfilingUpdateFrequency();
        this.serverName = server.getName();
        this.profileManager = new ProfileManager(config, server);
        this.queryTuner = new BaseQueryTuner(config, server, this.profileManager);
        this.skipGarbageCollectionOnShutdown = config.isSkipGarbageCollectionOnShutdown();
        this.skipProfileReportingOnShutdown = config.isSkipProfileReportingOnShutdown();
        this.defaultGarbageCollectionWait = config.getGarbageCollectionWait();
    }

    @Override
    public void startup() {
        if (this.queryTuning) {
            this.loadTuningFile();
            if (this.isRuntimeTuningUpdates()) {
                this.server.getBackgroundExecutor().executePeriodically(new ProfilingUpdate(), this.profilingUpdateFrequency, TimeUnit.SECONDS);
            }
        }
    }

    private boolean isRuntimeTuningUpdates() {
        return this.profilingUpdateFrequency > 0;
    }

    private void loadTuningFile() {
        File file = new File(this.tuningFile);
        if (!file.exists()) {
            logger.warn("AutoTune file {} not found - no initial automatic query tuning", (Object)file.getAbsolutePath());
        } else {
            AutoTuneXmlReader reader = new AutoTuneXmlReader();
            Autotune profiling = reader.read(file);
            logger.info("AutoTune loading {} tuning entries", (Object)profiling.getOrigin().size());
            for (Origin origin : profiling.getOrigin()) {
                this.queryTuner.put(origin);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runtimeTuningUpdate() {
        DefaultAutoTuneService defaultAutoTuneService = this;
        synchronized (defaultAutoTuneService) {
            try {
                long start = System.currentTimeMillis();
                AutoTuneCollection profiling = this.profileManager.profilingCollection(false);
                AutoTuneDiffCollection event = new AutoTuneDiffCollection(profiling, this.queryTuner, true);
                event.process();
                if (event.isEmpty()) {
                    long exeMillis = System.currentTimeMillis() - start;
                    logger.debug("No query tuning updates for server:{} executionMillis:{}", (Object)this.serverName, (Object)exeMillis);
                } else {
                    this.runtimeChangeCount += (long)event.getChangeCount();
                    event.writeFile(this.profilingFile + "-" + this.serverName + "-update");
                    long exeMillis = System.currentTimeMillis() - start;
                    logger.info("query tuning updates - new:{} diff:{} for server:{} executionMillis:{}", new Object[]{event.getNewCount(), event.getDiffCount(), this.serverName, exeMillis});
                }
            }
            catch (Throwable e) {
                logger.error("Error collecting or applying automatic query tuning", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveProfilingOnShutdown(boolean reset) {
        DefaultAutoTuneService defaultAutoTuneService = this;
        synchronized (defaultAutoTuneService) {
            if (this.isRuntimeTuningUpdates()) {
                this.runtimeTuningUpdate();
                this.outputAllTuning();
            } else {
                AutoTuneCollection profiling = this.profileManager.profilingCollection(reset);
                AutoTuneDiffCollection event = new AutoTuneDiffCollection(profiling, this.queryTuner, false);
                event.process();
                if (event.isEmpty()) {
                    logger.info("No new or diff entries for profiling server:{}", (Object)this.serverName);
                } else {
                    event.writeFile(this.profilingFile + "-" + this.serverName);
                    logger.info("writing new:{} diff:{} profiling entries for server:{}", new Object[]{event.getNewCount(), event.getDiffCount(), this.serverName});
                }
            }
        }
    }

    private void outputAllTuning() {
        if (this.runtimeChangeCount == 0L) {
            logger.info("no runtime query tuning changes for server:{}", (Object)this.serverName);
        } else {
            AutoTuneAllCollection event = new AutoTuneAllCollection(this.queryTuner);
            int size = event.size();
            File existingTuning = new File(this.tuningFile);
            if (existingTuning.exists() && !existingTuning.renameTo(new File(this.tuningFile + "." + AutoTuneXmlWriter.now()))) {
                logger.warn("Failed to rename autotune file [{}]", (Object)this.tuningFile);
            }
            event.writeFile(this.tuningFile, false);
            logger.info("query tuning detected [{}] changes, writing all [{}] tuning entries for server:{}", new Object[]{this.runtimeChangeCount, size, this.serverName});
        }
    }

    @Override
    public void shutdown() {
        if (this.profiling) {
            if (!this.skipGarbageCollectionOnShutdown && !this.skipProfileReportingOnShutdown) {
                this.collectProfiling(-1L);
            }
            if (!this.skipProfileReportingOnShutdown) {
                this.saveProfilingOnShutdown(false);
            }
        }
    }

    @Override
    public void reportProfiling() {
        this.saveProfilingOnShutdown(false);
    }

    @Override
    public void collectProfiling() {
        this.collectProfiling(-1L);
    }

    public void collectProfiling(long waitMillis) {
        System.gc();
        try {
            if (waitMillis < 0L) {
                waitMillis = this.defaultGarbageCollectionWait;
            }
            Thread.sleep(waitMillis);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.warn("Error while sleeping after System.gc() request.", (Throwable)e);
        }
    }

    @Override
    public boolean tuneQuery(SpiQuery<?> query) {
        return this.queryTuner.tuneQuery(query);
    }

    private class ProfilingUpdate
    implements Runnable {
        private ProfilingUpdate() {
        }

        @Override
        public void run() {
            DefaultAutoTuneService.this.runtimeTuningUpdate();
        }
    }
}

