/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.autotune.service;

import com.avaje.ebean.bean.ObjectGraphOrigin;
import com.avaje.ebeaninternal.server.autotune.AutoTuneCollection;
import com.avaje.ebeaninternal.server.autotune.model.Autotune;
import com.avaje.ebeaninternal.server.autotune.model.Origin;
import com.avaje.ebeaninternal.server.autotune.model.ProfileDiff;
import com.avaje.ebeaninternal.server.autotune.model.ProfileNew;
import com.avaje.ebeaninternal.server.autotune.service.AutoTuneXmlWriter;
import com.avaje.ebeaninternal.server.autotune.service.BaseQueryTuner;
import com.avaje.ebeaninternal.server.querydefn.OrmQueryDetail;

public class AutoTuneDiffCollection {
    final Autotune document = new Autotune();
    final AutoTuneCollection profiling;
    final BaseQueryTuner queryTuner;
    final boolean updateTuning;
    int newCount;
    int diffCount;

    public AutoTuneDiffCollection(AutoTuneCollection profiling, BaseQueryTuner queryTuner, boolean updateTuning) {
        this.profiling = profiling;
        this.queryTuner = queryTuner;
        this.updateTuning = updateTuning;
    }

    public boolean isEmpty() {
        return this.newCount == 0 && this.diffCount == 0;
    }

    public Autotune getDocument() {
        return this.document;
    }

    public int getDiffCount() {
        return this.diffCount;
    }

    public int getNewCount() {
        return this.newCount;
    }

    public int getChangeCount() {
        return this.newCount + this.diffCount;
    }

    public void writeFile(String filePrefix) {
        AutoTuneXmlWriter writer = new AutoTuneXmlWriter();
        writer.write(this.document, filePrefix, true);
    }

    public void process() {
        for (AutoTuneCollection.Entry entry : this.profiling.getEntries()) {
            this.addToDocument(entry);
        }
    }

    private void addToDocument(AutoTuneCollection.Entry entry) {
        ObjectGraphOrigin point = entry.getOrigin();
        OrmQueryDetail profileDetail = entry.getDetail();
        OrmQueryDetail tuneDetail = this.queryTuner.get(point.getKey());
        if (tuneDetail == null) {
            this.addToDocumentNewEntry(entry, point);
        } else if (!tuneDetail.isAutoTuneEqual(profileDetail)) {
            this.addToDocumentDiffEntry(entry, point, tuneDetail);
        }
    }

    private void addToDocumentDiffEntry(AutoTuneCollection.Entry entry, ObjectGraphOrigin point, OrmQueryDetail tuneDetail) {
        ++this.diffCount;
        Origin origin = this.createOrigin(entry, point, tuneDetail.toString());
        ProfileDiff diff = this.document.getProfileDiff();
        if (diff == null) {
            diff = new ProfileDiff();
            this.document.setProfileDiff(diff);
        }
        diff.getOrigin().add(origin);
    }

    private void addToDocumentNewEntry(AutoTuneCollection.Entry entry, ObjectGraphOrigin point) {
        ++this.newCount;
        ProfileNew profileNew = this.document.getProfileNew();
        if (profileNew == null) {
            profileNew = new ProfileNew();
            this.document.setProfileNew(profileNew);
        }
        Origin origin = this.createOrigin(entry, point, entry.getOriginalQuery());
        profileNew.getOrigin().add(origin);
    }

    private Origin createOrigin(AutoTuneCollection.Entry entry, ObjectGraphOrigin point, String query) {
        Origin origin = new Origin();
        origin.setKey(point.getKey());
        origin.setBeanType(point.getBeanType());
        origin.setDetail(entry.getDetail().toString());
        origin.setCallStack(point.getCallStack().description("\n"));
        origin.setOriginal(query);
        if (this.updateTuning) {
            this.queryTuner.put(origin);
        }
        return origin;
    }
}

