/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.text.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Set;

class EJsonWriter {
    static final JsonFactory jsonFactory = new JsonFactory();
    private final JsonGenerator jsonGenerator;

    static String write(Object object) throws IOException {
        StringWriter writer = new StringWriter(200);
        EJsonWriter.write(object, writer);
        return writer.toString();
    }

    static void write(Object object, Writer writer) throws IOException {
        JsonGenerator generator = jsonFactory.createGenerator(writer);
        EJsonWriter.write(object, generator);
        generator.close();
    }

    static void write(Object object, JsonGenerator jsonGenerator) {
        new EJsonWriter(jsonGenerator).writeJson(object);
    }

    static void writeCollection(Collection<Object> collection, JsonGenerator jsonGenerator) throws IOException {
        new EJsonWriter(jsonGenerator).writeCollection(null, collection);
    }

    private EJsonWriter(JsonGenerator jsonGenerator) {
        this.jsonGenerator = jsonGenerator;
    }

    private void writeJson(Object object) {
        this.writeJson(null, object);
    }

    private void writeJson(String name, Object object) {
        try {
            if (object == null) {
                this.writeNull(name);
            } else if (object instanceof Number) {
                this.writeNumber(name, (Number)object);
            } else if (object instanceof String) {
                this.writeString(name, (String)object);
            } else if (object instanceof Map) {
                this.writeMap(name, (Map)object);
            } else if (object instanceof Collection) {
                this.writeCollection(name, (Collection)object);
            } else if (object instanceof Boolean) {
                this.writeBoolean(name, (Boolean)object);
            } else if (object instanceof Date) {
                this.writeDate(name, (Date)object);
            } else if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                this.writeJson(entry.getKey().toString(), entry.getValue());
            } else {
                this.writeString(name, object.toString());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeBoolean(String name, Boolean object) throws IOException {
        if (name == null) {
            this.jsonGenerator.writeBoolean(object.booleanValue());
        } else {
            this.jsonGenerator.writeBooleanField(name, object.booleanValue());
        }
    }

    private void writeDate(String name, Date object) throws IOException {
        if (name == null) {
            this.jsonGenerator.writeNumber(object.getTime());
        } else {
            this.jsonGenerator.writeNumberField(name, object.getTime());
        }
    }

    private void writeNumber(String name, Number object) throws IOException {
        if (object instanceof Long) {
            this.writeLong(name, object);
        } else if (object instanceof Integer) {
            this.writeInteger(name, object);
        } else if (object instanceof Double) {
            this.writeDouble(name, object);
        } else if (object instanceof BigDecimal) {
            this.writeBigDecimal(name, object);
        } else if (object instanceof BigInteger) {
            this.writeBigInteger(name, object);
        } else {
            this.writeGeneralNumber(name, object);
        }
    }

    private void writeGeneralNumber(String name, Number object) throws IOException {
        this.writeBigDecimal(name, new BigDecimal(object.toString()));
    }

    private void writeBigDecimal(String name, Number object) throws IOException {
        if (name == null) {
            this.jsonGenerator.writeNumber((BigDecimal)object);
        } else {
            this.jsonGenerator.writeNumberField(name, (BigDecimal)object);
        }
    }

    private void writeBigInteger(String name, Number object) throws IOException {
        if (name == null) {
            this.jsonGenerator.writeNumber((BigInteger)object);
        } else {
            this.jsonGenerator.writeNumberField(name, object.longValue());
        }
    }

    private void writeDouble(String name, Number object) throws IOException {
        if (name == null) {
            this.jsonGenerator.writeNumber(((Double)object).doubleValue());
        } else {
            this.jsonGenerator.writeNumberField(name, ((Double)object).doubleValue());
        }
    }

    private void writeLong(String name, Number object) throws IOException {
        if (name == null) {
            this.jsonGenerator.writeNumber(((Long)object).longValue());
        } else {
            this.jsonGenerator.writeNumberField(name, ((Long)object).longValue());
        }
    }

    private void writeInteger(String name, Number object) throws IOException {
        if (name == null) {
            this.jsonGenerator.writeNumber(((Integer)object).intValue());
        } else {
            this.jsonGenerator.writeNumberField(name, ((Integer)object).intValue());
        }
    }

    private void writeNull(String name) throws IOException {
        if (name == null) {
            this.jsonGenerator.writeNull();
        } else {
            this.jsonGenerator.writeNullField(name);
        }
    }

    private void writeString(String name, String object) throws IOException {
        if (name == null) {
            this.jsonGenerator.writeString(object);
        } else {
            this.jsonGenerator.writeStringField(name, object);
        }
    }

    private void writeCollection(String name, Collection<Object> collection) throws IOException {
        if (name != null) {
            this.jsonGenerator.writeFieldName(name);
        }
        this.jsonGenerator.writeStartArray();
        for (Object object : collection) {
            this.writeJson(null, object);
        }
        this.jsonGenerator.writeEndArray();
    }

    private void writeMap(String name, Map<Object, Object> map) throws IOException {
        if (name != null) {
            this.jsonGenerator.writeFieldName(name);
        }
        this.jsonGenerator.writeStartObject();
        Set<Map.Entry<Object, Object>> entrySet = map.entrySet();
        for (Map.Entry<Object, Object> entry : entrySet) {
            this.writeJson(entry.getKey().toString(), entry.getValue());
        }
        this.jsonGenerator.writeEndObject();
    }
}

