/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.dbmigration.runner;

import com.avaje.ebean.EbeanServer;
import com.avaje.ebean.SqlQuery;
import com.avaje.ebean.SqlRow;
import com.avaje.ebean.SqlUpdate;
import com.avaje.ebean.Transaction;
import com.avaje.ebean.config.DbMigrationConfig;
import com.avaje.ebean.config.ServerConfig;
import com.avaje.ebean.config.dbplatform.DatabasePlatform;
import com.avaje.ebean.dbmigration.runner.Checksum;
import com.avaje.ebean.dbmigration.runner.LocalMigrationResource;
import com.avaje.ebean.dbmigration.runner.MigrationMetaRow;
import com.avaje.ebean.dbmigration.runner.MigrationScriptRunner;
import com.avaje.ebean.dbmigration.runner.PlaceholderBuilder;
import com.avaje.ebean.dbmigration.runner.ScriptTransform;
import com.avaje.ebean.plugin.SpiServer;
import com.avaje.ebeaninternal.server.transaction.ExternalJdbcTransaction;
import com.avaje.ebeaninternal.util.IOUtils;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationTable {
    private static final Logger logger = LoggerFactory.getLogger(MigrationTable.class);
    private final Connection connection;
    private final EbeanServer server;
    private final DatabasePlatform databasePlatform;
    private final String catalog;
    private final String schema;
    private final String table;
    private final ServerConfig serverConfig;
    private final String envUserName;
    private final ScriptTransform scriptTransform;
    private final String insertSql;
    private final LinkedHashMap<String, MigrationMetaRow> migrations;
    private MigrationMetaRow lastMigration;

    public MigrationTable(EbeanServer server, DbMigrationConfig migrationConfig, Connection connection) {
        this.connection = connection;
        this.server = server;
        this.migrations = new LinkedHashMap();
        SpiServer pluginApi = server.getPluginApi();
        this.serverConfig = pluginApi.getServerConfig();
        this.databasePlatform = pluginApi.getDatabasePlatform();
        this.catalog = null;
        this.schema = null;
        this.table = migrationConfig.getMetaTable();
        this.insertSql = MigrationMetaRow.insertSql(this.table);
        this.scriptTransform = this.createScriptTransform(migrationConfig);
        this.envUserName = System.getProperty("user.name");
    }

    private ScriptTransform createScriptTransform(DbMigrationConfig config) {
        Map<String, String> map = PlaceholderBuilder.build(config.getRunPlaceholders(), config.getRunPlaceholderMap());
        return new ScriptTransform(map);
    }

    public void createIfNeeded() throws SQLException, IOException {
        if (!this.tableExists(this.connection)) {
            this.createTable(this.connection);
        }
        ExternalJdbcTransaction t = new ExternalJdbcTransaction(this.connection);
        SqlQuery sqlQuery = this.server.createSqlQuery("select * from " + this.table + " order by id for update");
        List<SqlRow> metaRows = this.server.findList(sqlQuery, (Transaction)t);
        for (SqlRow row : metaRows) {
            this.addMigration(new MigrationMetaRow(row));
        }
    }

    private void createTable(Connection connection) throws IOException {
        String script = ScriptTransform.table(this.table, this.getCreateTableScript());
        MigrationScriptRunner run = new MigrationScriptRunner(connection);
        run.runScript(false, script, "create migration table");
    }

    private String getCreateTableScript() throws IOException {
        String script = this.readResource("migration-support/create-table.sql");
        if (script == null) {
            script = this.readResource("migration-support/default-create-table.sql");
        }
        return script;
    }

    private String readResource(String location) throws IOException {
        Enumeration<URL> resources = this.serverConfig.getClassLoadConfig().getResources(location);
        if (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            return IOUtils.readUtf8(url.openStream());
        }
        return null;
    }

    private boolean tableExists(Connection connection) throws SQLException {
        return this.databasePlatform.tableExists(connection, this.catalog, this.schema, this.table);
    }

    public boolean shouldRun(LocalMigrationResource localVersion, LocalMigrationResource priorVersion) {
        MigrationMetaRow existing;
        if (priorVersion != null && (existing = this.migrations.get(priorVersion.getVersion().normalised())) == null) {
            logger.warn("Migration {} requires prior migration {} which has not been run", (Object)localVersion.getVersion(), (Object)priorVersion.getVersion());
            return false;
        }
        existing = this.migrations.get(localVersion.getVersion().normalised());
        if (existing == null) {
            this.runMigration(localVersion, priorVersion);
            return true;
        }
        existing.getChecksum();
        return true;
    }

    private void runMigration(LocalMigrationResource localVersion, LocalMigrationResource prior) {
        logger.debug("run migration " + localVersion.getLocation());
        String script = this.convertScript(localVersion.getContent());
        MigrationScriptRunner run = new MigrationScriptRunner(this.connection);
        run.runScript(false, script, "run migration version: " + localVersion.getVersion());
        int checksum = Checksum.calculate(script);
        MigrationMetaRow metaRow = this.createMetaRow(localVersion, prior, checksum);
        SqlUpdate insert = this.server.createSqlUpdate(this.insertSql);
        metaRow.bindInsert(insert);
        this.server.execute(insert, (Transaction)new ExternalJdbcTransaction(this.connection));
        this.addMigration(metaRow);
    }

    private MigrationMetaRow createMetaRow(LocalMigrationResource localVersion, LocalMigrationResource prior, int checksum) {
        int nextId = 1;
        if (this.lastMigration != null) {
            nextId = this.lastMigration.getId() + 1;
        }
        String runVersion = localVersion.getVersion().normalised();
        String comment = this.getMigrationComment(localVersion);
        String priorVersion = this.getMigrationPriorVersion(prior);
        return new MigrationMetaRow(nextId, runVersion, priorVersion, comment, checksum, this.envUserName);
    }

    private String getMigrationPriorVersion(LocalMigrationResource prior) {
        return prior != null ? prior.getVersion().normalised() : "-";
    }

    private String getMigrationComment(LocalMigrationResource localVersion) {
        String comment = localVersion.getVersion().getComment();
        return comment == null || comment.isEmpty() ? "-" : comment;
    }

    private String convertScript(String script) {
        return this.scriptTransform.transform(script);
    }

    private void addMigration(MigrationMetaRow metaRow) {
        this.lastMigration = metaRow;
        this.migrations.put(metaRow.getRunVersion(), metaRow);
    }
}

