/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.dbmigration.model.visitor;

import com.avaje.ebean.dbmigration.model.build.ModelBuildPropertyVisitor;
import com.avaje.ebean.dbmigration.model.visitor.BeanPropertyVisitor;
import com.avaje.ebean.dbmigration.model.visitor.BeanVisitor;
import com.avaje.ebeaninternal.api.SpiEbeanServer;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.BeanProperty;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssocOne;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyCompound;
import com.avaje.ebeaninternal.server.deploy.InheritInfo;
import com.avaje.ebeaninternal.server.deploy.InheritInfoVisitor;
import java.util.List;

public class VisitAllUsing {
    protected final BeanVisitor visitor;
    protected final List<BeanDescriptor<?>> descriptors;

    public VisitAllUsing(BeanVisitor visitor, SpiEbeanServer server) {
        this(visitor, server.getBeanDescriptors());
    }

    public VisitAllUsing(BeanVisitor visitor, List<BeanDescriptor<?>> descriptors) {
        this.visitor = visitor;
        this.descriptors = descriptors;
    }

    public void visitAllBeans() {
        for (BeanDescriptor<?> desc : this.descriptors) {
            if (desc.getBaseTable() == null) continue;
            this.visitBean(desc, this.visitor);
        }
    }

    protected void visitBean(BeanDescriptor<?> desc, BeanVisitor visitor) {
        ModelBuildPropertyVisitor propertyVisitor = visitor.visitBean(desc);
        if (propertyVisitor != null) {
            BeanPropertyAssocOne<?> unidirectional;
            BeanProperty idProp = desc.getIdProperty();
            if (idProp != null) {
                this.visit(propertyVisitor, idProp);
            }
            if ((unidirectional = desc.getUnidirectional()) != null) {
                this.visit(propertyVisitor, unidirectional);
            }
            BeanProperty[] propertiesNonTransient = desc.propertiesNonTransient();
            for (int i = 0; i < propertiesNonTransient.length; ++i) {
                BeanProperty p = propertiesNonTransient[i];
                if (p.isFormula() || p.isSecondaryTable()) continue;
                this.visit(propertyVisitor, p);
            }
            this.visitInheritanceProperties(desc, propertyVisitor);
            propertyVisitor.visitEnd();
        }
    }

    protected void visit(BeanPropertyVisitor pv, BeanProperty p) {
        if (p instanceof BeanPropertyAssocMany) {
            pv.visitMany((BeanPropertyAssocMany)p);
        } else if (p instanceof BeanPropertyAssocOne) {
            BeanPropertyAssocOne assocOne = (BeanPropertyAssocOne)p;
            if (assocOne.isEmbedded()) {
                pv.visitEmbedded(assocOne);
                BeanProperty[] embProps = assocOne.getProperties();
                for (int i = 0; i < embProps.length; ++i) {
                    pv.visitEmbeddedScalar(embProps[i], assocOne);
                }
            } else if (assocOne.isOneToOneExported()) {
                pv.visitOneExported(assocOne);
            } else {
                pv.visitOneImported(assocOne);
            }
        } else if (p instanceof BeanPropertyCompound) {
            BeanPropertyCompound compound = (BeanPropertyCompound)p;
            pv.visitCompound(compound);
            BeanProperty[] properties = compound.getScalarProperties();
            for (int i = 0; i < properties.length; ++i) {
                pv.visitCompoundScalar(compound, properties[i]);
            }
        } else {
            pv.visitScalar(p);
        }
    }

    protected void visitInheritanceProperties(BeanDescriptor<?> descriptor, BeanPropertyVisitor pv) {
        InheritInfo inheritInfo = descriptor.getInheritInfo();
        if (inheritInfo != null && inheritInfo.isRoot()) {
            InheritChildVisitor childVisitor = new InheritChildVisitor(this, pv);
            inheritInfo.visitChildren(childVisitor);
        }
    }

    protected class InheritChildVisitor
    implements InheritInfoVisitor {
        private final VisitAllUsing owner;
        private final BeanPropertyVisitor pv;

        protected InheritChildVisitor(VisitAllUsing owner, BeanPropertyVisitor pv) {
            this.owner = owner;
            this.pv = pv;
        }

        @Override
        public void visit(InheritInfo inheritInfo) {
            BeanProperty[] propertiesLocal = inheritInfo.getBeanDescriptor().propertiesLocal();
            for (int i = 0; i < propertiesLocal.length; ++i) {
                this.owner.visit(this.pv, propertiesLocal[i]);
            }
        }
    }
}

