/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.dbmigration.model;

import com.avaje.ebean.config.DbMigrationConfig;
import com.avaje.ebean.config.ServerConfig;
import com.avaje.ebean.config.dbplatform.DatabasePlatform;
import com.avaje.ebean.dbmigration.ddlgeneration.DdlBuffer;
import com.avaje.ebean.dbmigration.ddlgeneration.DdlHandler;
import com.avaje.ebean.dbmigration.ddlgeneration.DdlWrite;
import com.avaje.ebean.dbmigration.migration.ChangeSet;
import com.avaje.ebean.dbmigration.migration.ChangeSetType;
import com.avaje.ebean.dbmigration.migration.Migration;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;

public class PlatformDdlWriter {
    private final ServerConfig serverConfig;
    private final DatabasePlatform platform;
    private final String platformPrefix;
    private final DbMigrationConfig config;

    public PlatformDdlWriter(DatabasePlatform platform, ServerConfig serverConfig, String platformPrefix, DbMigrationConfig config) {
        this.platform = platform;
        this.serverConfig = serverConfig;
        this.platformPrefix = platformPrefix;
        this.config = config;
    }

    public void processMigration(Migration dbMigration, DdlWrite write, File writePath, String fullVersion) throws IOException {
        DdlHandler handler = this.handler();
        List<ChangeSet> changeSets = dbMigration.getChangeSet();
        for (ChangeSet changeSet : changeSets) {
            if (!this.isApply(changeSet)) continue;
            handler.generate(write, changeSet);
        }
        handler.generateExtra(write);
        this.writePlatformDdl(write, writePath, fullVersion);
    }

    private boolean isApply(ChangeSet changeSet) {
        return changeSet.getType() == ChangeSetType.APPLY && !changeSet.getChangeSetChildren().isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writePlatformDdl(DdlWrite write, File resourcePath, String fullVersion) throws IOException {
        if (!write.isApplyEmpty()) {
            FileWriter applyWriter = this.createWriter(resourcePath, fullVersion, "", this.config.getApplySuffix());
            try {
                this.writeApplyDdl(applyWriter, write);
                applyWriter.flush();
            }
            finally {
                applyWriter.close();
            }
        }
    }

    protected FileWriter createWriter(File path, String fullVersion, String subPath, String suffix) throws IOException {
        String fileName = fullVersion;
        if (!this.platformPrefix.isEmpty()) {
            fileName = fileName + "-" + this.platformPrefix;
        }
        if (subPath != null && !subPath.isEmpty()) {
            path = this.subPath(path, subPath);
        }
        fileName = fileName + suffix;
        File applyFile = new File(path, fileName);
        return new FileWriter(applyFile);
    }

    protected File subPath(File path, String suffix) {
        File subPath = new File(path, suffix);
        if (!subPath.exists()) {
            subPath.mkdirs();
        }
        return subPath;
    }

    protected void writeApplyDdl(Writer writer, DdlWrite write) throws IOException {
        this.prependDropDependencies(writer, write.applyDropDependencies());
        writer.append("-- apply changes\n");
        writer.append(write.apply().getBuffer());
        writer.append(write.applyForeignKeys().getBuffer());
        writer.append(write.applyHistory().getBuffer());
    }

    private void prependDropDependencies(Writer writer, DdlBuffer buffer) throws IOException {
        if (!buffer.isEmpty()) {
            writer.append("-- drop dependencies\n");
            writer.append(buffer.getBuffer());
            writer.append("\n");
        }
    }

    protected DdlHandler handler() {
        return this.platform.createDdlHandler(this.serverConfig);
    }
}

