/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.dbmigration.model;

import com.avaje.ebean.dbmigration.migration.AddColumn;
import com.avaje.ebean.dbmigration.migration.AddHistoryTable;
import com.avaje.ebean.dbmigration.migration.AlterColumn;
import com.avaje.ebean.dbmigration.migration.ChangeSet;
import com.avaje.ebean.dbmigration.migration.ChangeSetType;
import com.avaje.ebean.dbmigration.migration.CreateIndex;
import com.avaje.ebean.dbmigration.migration.DropColumn;
import com.avaje.ebean.dbmigration.migration.DropHistoryTable;
import com.avaje.ebean.dbmigration.migration.DropIndex;
import com.avaje.ebean.dbmigration.migration.Migration;
import com.avaje.ebean.dbmigration.model.MIndex;
import com.avaje.ebean.dbmigration.model.MTable;
import com.avaje.ebean.dbmigration.model.ModelContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ModelDiff {
    private final ModelContainer baseModel;
    private final List<Object> applyChanges = new ArrayList<Object>();
    private final List<Object> dropChanges = new ArrayList<Object>();

    public ModelDiff(ModelContainer baseModel) {
        this.baseModel = baseModel;
    }

    public ModelDiff() {
        this.baseModel = new ModelContainer();
    }

    public boolean isEmpty() {
        return this.applyChanges.isEmpty() && this.dropChanges.isEmpty();
    }

    public Migration getMigration() {
        Migration migration = new Migration();
        if (!this.applyChanges.isEmpty()) {
            migration.getChangeSet().add(this.getApplyChangeSet());
        }
        if (!this.dropChanges.isEmpty()) {
            migration.getChangeSet().add(this.getDropChangeSet());
        }
        return migration;
    }

    List<Object> getApplyChanges() {
        return this.applyChanges;
    }

    List<Object> getDropChanges() {
        return this.dropChanges;
    }

    public ChangeSet getApplyChangeSet() {
        ChangeSet applyChangeSet = new ChangeSet();
        applyChangeSet.setType(ChangeSetType.APPLY);
        applyChangeSet.getChangeSetChildren().addAll(this.applyChanges);
        return applyChangeSet;
    }

    ChangeSet getDropChangeSet() {
        ChangeSet createChangeSet = new ChangeSet();
        createChangeSet.setType(ChangeSetType.PENDING_DROPS);
        createChangeSet.getChangeSetChildren().addAll(this.dropChanges);
        return createChangeSet;
    }

    public void compareTo(ModelContainer newModel) {
        Map<String, MTable> newTables = newModel.getTables();
        for (MTable newTable : newTables.values()) {
            MTable currentTable = this.baseModel.getTable(newTable.getName());
            if (currentTable == null) {
                this.addNewTable(newTable);
                continue;
            }
            this.compareTables(currentTable, newTable);
        }
        for (MTable existingTable : this.baseModel.getTables().values()) {
            if (newTables.containsKey(existingTable.getName())) continue;
            this.addDropTable(existingTable);
        }
        Map<String, MIndex> newIndexes = newModel.getIndexes();
        for (MIndex newIndex : newIndexes.values()) {
            MIndex currentIndex = this.baseModel.getIndex(newIndex.getIndexName());
            if (currentIndex == null) {
                this.addCreateIndex(newIndex.createIndex());
                continue;
            }
            this.compareIndexes(currentIndex, newIndex);
        }
        for (MIndex existingIndex : this.baseModel.getIndexes().values()) {
            if (newIndexes.containsKey(existingIndex.getIndexName())) continue;
            this.addDropIndex(existingIndex.dropIndex());
        }
        this.baseModel.registerPendingHistoryDropColumns(newModel);
        if (!this.dropChanges.isEmpty()) {
            newModel.registerPendingHistoryDropColumns(this.getDropChangeSet());
        }
    }

    protected void addDropTable(MTable existingTable) {
        this.dropChanges.add(existingTable.dropTable());
    }

    protected void addNewTable(MTable newTable) {
        this.applyChanges.add(newTable.createTable());
    }

    protected void compareTables(MTable currentTable, MTable newTable) {
        currentTable.compare(this, newTable);
    }

    protected void compareIndexes(MIndex currentIndex, MIndex newIndex) {
        currentIndex.compare(this, newIndex);
    }

    public void addAlterColumn(AlterColumn alterColumn) {
        this.applyChanges.add(alterColumn);
    }

    public void addAddColumn(AddColumn addColumn) {
        this.applyChanges.add(addColumn);
    }

    public void addDropColumn(DropColumn dropColumn) {
        this.dropChanges.add(dropColumn);
    }

    public void addAddHistoryTable(AddHistoryTable addHistoryTable) {
        this.applyChanges.add(addHistoryTable);
    }

    public void addDropHistoryTable(DropHistoryTable dropHistoryTable) {
        this.dropChanges.add(dropHistoryTable);
    }

    public void addDropIndex(DropIndex dropIndex) {
        this.applyChanges.add(dropIndex);
    }

    public void addCreateIndex(CreateIndex createIndex) {
        this.applyChanges.add(createIndex);
    }
}

