/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.dbmigration;

import com.avaje.ebean.EbeanServer;
import com.avaje.ebean.config.DbMigrationConfig;
import com.avaje.ebean.config.ServerConfig;
import com.avaje.ebean.dbmigration.runner.LocalMigrationResource;
import com.avaje.ebean.dbmigration.runner.LocalMigrationResources;
import com.avaje.ebean.dbmigration.runner.MigrationTable;
import com.avaje.ebeaninternal.util.JdbcClose;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationRunner {
    private static final Logger logger = LoggerFactory.getLogger(MigrationRunner.class);
    private final EbeanServer server;
    private final ServerConfig config;
    private final DbMigrationConfig migrationConfig;

    public MigrationRunner(EbeanServer server, DbMigrationConfig migrationConfig) {
        this.server = server;
        this.config = server.getPluginApi().getServerConfig();
        this.migrationConfig = migrationConfig;
    }

    public void run() {
        Connection connection;
        LocalMigrationResources resources = new LocalMigrationResources(this.config, this.migrationConfig);
        if (!resources.readResources()) {
            logger.debug("no migrations to check");
            return;
        }
        String migrationUser = this.migrationConfig.getDbUser();
        String migrationPwd = this.migrationConfig.getDbPassword();
        DataSource dataSource = this.server.getPluginApi().getDataSource();
        try {
            connection = dataSource.getConnection(migrationUser, migrationPwd);
        }
        catch (SQLException e) {
            throw new IllegalArgumentException("Error trying to connect to database using DB Migration user [" + migrationUser + "]", e);
        }
        try {
            connection.setAutoCommit(false);
            this.runMigrations(resources, connection);
            connection.commit();
        }
        catch (Exception e) {
            JdbcClose.rollback(connection);
            throw new RuntimeException(e);
        }
        finally {
            JdbcClose.close(connection);
        }
    }

    private void runMigrations(LocalMigrationResources resources, Connection connection) throws SQLException, IOException {
        LocalMigrationResource localVersion;
        MigrationTable table = new MigrationTable(this.server, this.migrationConfig, connection);
        table.createIfNeeded();
        List<LocalMigrationResource> localVersions = resources.getVersions();
        LocalMigrationResource priorVersion = null;
        for (int i = 0; i < localVersions.size() && table.shouldRun(localVersion = localVersions.get(i), priorVersion); ++i) {
            priorVersion = localVersion;
        }
    }
}

