/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.dbmigration;

import com.avaje.ebean.Ebean;
import com.avaje.ebean.EbeanServer;
import com.avaje.ebean.config.DbConstraintNaming;
import com.avaje.ebean.config.DbMigrationConfig;
import com.avaje.ebean.config.ServerConfig;
import com.avaje.ebean.config.dbplatform.DB2Platform;
import com.avaje.ebean.config.dbplatform.DatabasePlatform;
import com.avaje.ebean.config.dbplatform.DbPlatformName;
import com.avaje.ebean.config.dbplatform.H2Platform;
import com.avaje.ebean.config.dbplatform.MsSqlServer2005Platform;
import com.avaje.ebean.config.dbplatform.MySqlPlatform;
import com.avaje.ebean.config.dbplatform.OraclePlatform;
import com.avaje.ebean.config.dbplatform.PostgresPlatform;
import com.avaje.ebean.config.dbplatform.SQLitePlatform;
import com.avaje.ebean.dbmigration.DbOffline;
import com.avaje.ebean.dbmigration.ddlgeneration.DdlWrite;
import com.avaje.ebean.dbmigration.migration.Migration;
import com.avaje.ebean.dbmigration.migrationreader.MigrationXmlWriter;
import com.avaje.ebean.dbmigration.model.CurrentModel;
import com.avaje.ebean.dbmigration.model.MConfiguration;
import com.avaje.ebean.dbmigration.model.MigrationModel;
import com.avaje.ebean.dbmigration.model.MigrationVersion;
import com.avaje.ebean.dbmigration.model.ModelContainer;
import com.avaje.ebean.dbmigration.model.ModelDiff;
import com.avaje.ebean.dbmigration.model.PlatformDdlWriter;
import com.avaje.ebeaninternal.api.SpiEbeanServer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbMigration {
    protected static final Logger logger = LoggerFactory.getLogger(DbMigration.class);
    private static final String initialVersion = "1.0";
    private static final String GENERATED_COMMENT = "THIS IS A GENERATED FILE - DO NOT MODIFY";
    protected final boolean online;
    protected SpiEbeanServer server;
    protected DbMigrationConfig migrationConfig;
    protected String pathToResources = "src/main/resources";
    protected DatabasePlatform databasePlatform;
    protected List<Pair> platforms = new ArrayList<Pair>();
    protected ServerConfig serverConfig;
    protected DbConstraintNaming constraintNaming;

    public DbMigration() {
        this.online = false;
    }

    public DbMigration(EbeanServer server) {
        this.online = true;
        this.setServer(server);
    }

    public void setPathToResources(String pathToResources) {
        this.pathToResources = pathToResources;
    }

    public void setServer(EbeanServer ebeanServer) {
        this.server = (SpiEbeanServer)ebeanServer;
        this.setServerConfig(this.server.getServerConfig());
    }

    public void setServerConfig(ServerConfig config) {
        if (this.serverConfig == null) {
            this.serverConfig = config;
        }
        if (this.migrationConfig == null) {
            this.migrationConfig = this.serverConfig.getMigrationConfig();
        }
        if (this.constraintNaming == null) {
            this.constraintNaming = this.serverConfig.getConstraintNaming();
        }
    }

    public void setPlatform(DbPlatformName platform) {
        this.setPlatform(this.getPlatform(platform));
    }

    public void setPlatform(DatabasePlatform databasePlatform) {
        this.databasePlatform = databasePlatform;
        if (!this.online) {
            DbOffline.setPlatform(databasePlatform.getName());
        }
    }

    public void addPlatform(DbPlatformName platform, String prefix) {
        if (!prefix.endsWith("-")) {
            prefix = prefix + "-";
        }
        this.platforms.add(new Pair(this.getPlatform(platform), prefix));
    }

    public void generateMigration() throws IOException {
        if (!this.online) {
            DbOffline.setRunningMigration();
        }
        this.setDefaults();
        try {
            Request request = this.createRequest();
            String pendingVersion = this.generatePendingDrop();
            if (pendingVersion != null) {
                this.generatePendingDrop(request, pendingVersion);
            } else {
                this.generateDiff(request);
            }
        }
        finally {
            if (!this.online) {
                DbOffline.reset();
            }
        }
    }

    private void generateDiff(Request request) throws IOException {
        Migration migration;
        List<String> pendingDrops = request.getPendingDrops();
        if (!pendingDrops.isEmpty()) {
            logger.info("Pending un-applied drops in versions {}", pendingDrops);
        }
        if ((migration = request.createDiffMigration()) == null) {
            logger.info("no changes detected - no migration written");
        } else {
            this.generateMigration(request, migration, null);
        }
    }

    private void generatePendingDrop(Request request, String pendingVersion) throws IOException {
        Migration migration = request.migrationForPendingDrop(pendingVersion);
        this.generateMigration(request, migration, pendingVersion);
        List<String> pendingDrops = request.getPendingDrops();
        if (!pendingDrops.isEmpty()) {
            logger.info("... remaining pending un-applied drops in versions {}", pendingDrops);
        }
    }

    private Request createRequest() {
        return new Request();
    }

    private void generateMigration(Request request, Migration dbMigration, String dropsFor) throws IOException {
        String fullVersion = this.getFullVersion(request.migrationModel, dropsFor);
        logger.info("generating migration:{}", (Object)fullVersion);
        if (!this.writeMigrationXml(dbMigration, request.modelDir, fullVersion)) {
            logger.warn("migration already exists, not generating DDL");
        } else {
            if (this.databasePlatform != null) {
                DdlWrite write = new DdlWrite(new MConfiguration(), request.current);
                PlatformDdlWriter writer = this.createDdlWriter(this.databasePlatform, "");
                writer.processMigration(dbMigration, write, request.migrationDir, fullVersion);
            }
            this.writeExtraPlatformDdl(fullVersion, request.currentModel, dbMigration, request.migrationDir);
        }
    }

    private String generatePendingDrop() {
        String nextDrop = System.getProperty("ddl.migration.pendingDropsFor");
        if (nextDrop != null) {
            return nextDrop;
        }
        return this.migrationConfig.getGeneratePendingDrop();
    }

    private String getFullVersion(MigrationModel migrationModel, String dropsFor) {
        String version = this.migrationConfig.getVersion();
        if (version == null) {
            version = migrationModel.getNextVersion(initialVersion);
        }
        String fullVersion = version;
        if (this.migrationConfig.getName() != null) {
            fullVersion = fullVersion + "__" + this.toUnderScore(this.migrationConfig.getName());
        } else if (dropsFor != null) {
            fullVersion = fullVersion + "__" + this.toUnderScore("dropsFor_" + MigrationVersion.trim(dropsFor));
        } else if (version.equals(initialVersion)) {
            fullVersion = fullVersion + "__initial";
        }
        return fullVersion;
    }

    private String toUnderScore(String name) {
        return name.replace(' ', '_');
    }

    protected void writeExtraPlatformDdl(String fullVersion, CurrentModel currentModel, Migration dbMigration, File writePath) throws IOException {
        for (Pair pair : this.platforms) {
            DdlWrite platformBuffer = new DdlWrite(new MConfiguration(), currentModel.read());
            PlatformDdlWriter platformWriter = this.createDdlWriter(pair);
            platformWriter.processMigration(dbMigration, platformBuffer, writePath, fullVersion);
        }
    }

    private PlatformDdlWriter createDdlWriter(Pair pair) {
        return this.createDdlWriter(pair.platform, pair.prefix);
    }

    private PlatformDdlWriter createDdlWriter(DatabasePlatform platform, String prefix) {
        return new PlatformDdlWriter(platform, this.serverConfig, prefix, this.migrationConfig);
    }

    protected boolean writeMigrationXml(Migration dbMigration, File resourcePath, String fullVersion) {
        String modelFile = fullVersion + this.migrationConfig.getModelSuffix();
        File file = new File(resourcePath, modelFile);
        if (file.exists()) {
            return false;
        }
        String comment = this.migrationConfig.isIncludeGeneratedFileComment() ? GENERATED_COMMENT : null;
        MigrationXmlWriter xmlWriter = new MigrationXmlWriter(comment);
        xmlWriter.write(dbMigration, file);
        return true;
    }

    protected void setDefaults() {
        if (this.server == null) {
            this.setServer(Ebean.getDefaultServer());
        }
        if (this.databasePlatform == null && this.platforms.isEmpty()) {
            this.databasePlatform = this.server.getDatabasePlatform();
            logger.debug("set platform to {}", (Object)this.databasePlatform.getName());
        }
    }

    protected File getMigrationDirectory() {
        File resourceRootDir = new File(this.pathToResources);
        String resourcePath = this.migrationConfig.getMigrationPath();
        File path = new File(resourceRootDir, resourcePath);
        if (!path.exists() && !path.mkdirs()) {
            logger.debug("Unable to ensure migration directory exists at {}", (Object)path.getAbsolutePath());
        }
        return path;
    }

    protected File getModelDirectory(File migrationDirectory) {
        String modelPath = this.migrationConfig.getModelPath();
        if (modelPath == null || modelPath.isEmpty()) {
            return migrationDirectory;
        }
        File modelDir = new File(migrationDirectory, this.migrationConfig.getModelPath());
        if (!modelDir.exists() && !modelDir.mkdirs()) {
            logger.debug("Unable to ensure migration model directory exists at {}", (Object)modelDir.getAbsolutePath());
        }
        return modelDir;
    }

    protected DatabasePlatform getPlatform(DbPlatformName platform) {
        switch (platform) {
            case H2: {
                return new H2Platform();
            }
            case POSTGRES: {
                return new PostgresPlatform();
            }
            case MYSQL: {
                return new MySqlPlatform();
            }
            case ORACLE: {
                return new OraclePlatform();
            }
            case SQLSERVER: {
                return new MsSqlServer2005Platform();
            }
            case DB2: {
                return new DB2Platform();
            }
            case SQLITE: {
                return new SQLitePlatform();
            }
        }
        throw new IllegalArgumentException("Platform missing? " + (Object)((Object)platform));
    }

    public static class Pair {
        public final DatabasePlatform platform;
        public final String prefix;

        public Pair(DatabasePlatform platform, String prefix) {
            this.platform = platform;
            this.prefix = prefix;
        }
    }

    private class Request {
        final File migrationDir;
        final File modelDir;
        final MigrationModel migrationModel;
        final CurrentModel currentModel;
        final ModelContainer migrated;
        final ModelContainer current;

        private Request() {
            this.migrationDir = DbMigration.this.getMigrationDirectory();
            this.modelDir = DbMigration.this.getModelDirectory(this.migrationDir);
            this.migrationModel = new MigrationModel(this.modelDir, DbMigration.this.migrationConfig.getModelSuffix());
            this.migrated = this.migrationModel.read();
            this.currentModel = new CurrentModel(DbMigration.this.server, DbMigration.this.constraintNaming);
            this.current = this.currentModel.read();
        }

        public Migration migrationForPendingDrop(String pendingVersion) {
            Migration migration = this.migrated.migrationForPendingDrop(pendingVersion);
            this.migrated.registerPendingHistoryDropColumns(this.current);
            return migration;
        }

        public List<String> getPendingDrops() {
            return this.migrated.getPendingDrops();
        }

        public Migration createDiffMigration() {
            ModelDiff diff = new ModelDiff(this.migrated);
            diff.compareTo(this.current);
            return diff.isEmpty() ? null : diff.getMigration();
        }
    }
}

